/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.reflection.FieldReader;
import org.mockito.internal.util.reflection.FieldSetter;

public class InstanceField {
    private final Field field;
    private final Object instance;
    private FieldReader fieldReader;

    public InstanceField(Field field, Object object) {
        this.field = Checks.checkNotNull(field, "field");
        this.instance = Checks.checkNotNull(object, "instance");
    }

    public Object read() {
        return this.reader().read();
    }

    public void set(Object object) {
        new FieldSetter(this.instance, this.field).set(object);
    }

    public boolean isNull() {
        return this.reader().isNull();
    }

    public boolean isAnnotatedBy(Class<? extends Annotation> clazz) {
        return this.field.isAnnotationPresent(clazz);
    }

    public <A extends Annotation> A annotation(Class<A> clazz) {
        return this.field.getAnnotation(clazz);
    }

    public Field jdkField() {
        return this.field;
    }

    private FieldReader reader() {
        if (this.fieldReader == null) {
            this.fieldReader = new FieldReader(this.instance, this.field);
        }
        return this.fieldReader;
    }

    public String name() {
        return this.field.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InstanceField instanceField = (InstanceField)object;
        return this.field.equals(instanceField.field) && this.instance.equals(instanceField.instance);
    }

    public int hashCode() {
        int n = this.field.hashCode();
        n = 31 * n + this.instance.hashCode();
        return n;
    }
}

