/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class Uri {
    public static final String ROOT_NODE = ".";
    public static final char ROOT_NODE_CHAR = '.';
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    private static final char[] BASE_64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '_'};

    private Uri() {
    }

    public static String mangle(String string) {
        return string;
    }

    public static String toUri(String[] stringArray) {
        if (0 == stringArray.length) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('/');
            }
            if (stringArray[i] == null) {
                throw new NullPointerException("One of its segments is null.");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static int getSegmentLength(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("URI segment is empty.");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '\\') {
                if (i == stringBuffer.length() - 1) {
                    throw new IllegalArgumentException("URI segment ends with the escape character.");
                }
                stringBuffer.deleteCharAt(i);
                continue;
            }
            if (stringBuffer.charAt(i) != '/') continue;
            throw new IllegalArgumentException("URI segment contains an unescaped '/' character.");
        }
        if (stringBuffer.toString().equals("..")) {
            throw new IllegalArgumentException("URI segment must not be \"..\".");
        }
        try {
            return stringBuffer.toString().getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public static String[] toPath(String string) {
        if (string == null) {
            throw new NullPointerException("'uri' parameter is null.");
        }
        if (!Uri.isValidUri(string)) {
            throw new IllegalArgumentException("Malformed URI: " + string);
        }
        if (string.length() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c == '/' || c == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            if (c == '/') {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isAbsoluteUri(String string) {
        if (null == string) {
            throw new NullPointerException("'uri' parameter is null.");
        }
        if (!Uri.isValidUri(string)) {
            throw new IllegalArgumentException("Malformed URI: " + string);
        }
        return string.equals(ROOT_NODE) || string.equals("\\.") || string.startsWith("./") || string.startsWith("\\./");
    }

    public static String encode(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\' && c != '/') continue;
            StringBuffer stringBuffer = new StringBuffer(string);
            while (i < stringBuffer.length()) {
                c = stringBuffer.charAt(i);
                if (c == '\\' || c == '/') {
                    stringBuffer.insert(i++, '\\');
                }
                ++i;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String decode(String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n >= 0 && n < stringBuffer.length()) {
            stringBuffer.deleteCharAt(n);
            ++n;
            while (n < stringBuffer.length() && stringBuffer.charAt(n) != '\\') {
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static boolean isValidUri(String string) {
        if (null == string) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (string.charAt(0) == '/' || string.charAt(n - 1) == '\\') {
            return false;
        }
        int n2 = 0;
        string = string + '/';
        ++n;
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            if (string.charAt(i) != '/' || string.charAt(i - 1) == '\\') continue;
            String string2 = string.substring(n3, i);
            if (++n2 > 1 && string2.equals(ROOT_NODE)) {
                return false;
            }
            try {
                Uri.getSegmentLength(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            n3 = i + 1;
        }
        return true;
    }

    static String mangle(String string, int n) {
        if (string == null) {
            throw new NullPointerException("The 'nodeName' parameter must not be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("The 'nodeName' parameter must not be empty.");
        }
        if (string.length() > n) {
            return Uri.getHash(string);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\' && stringBuffer.charAt(i) != '/') continue;
            stringBuffer.insert(i++, '\\');
        }
        return stringBuffer.toString();
    }

    private static String getHash(String string) {
        int n;
        int n2;
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("there's no UTF-8 encoder here!");
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Can't get an instance of a SHA MessageDigest provider!");
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        StringBuffer stringBuffer = new StringBuffer(byArray2.length * 2);
        for (n2 = 0; n2 < 6; ++n2) {
            n = byArray2[n2 * 3] & 0xFF;
            int n3 = byArray2[n2 * 3 + 1] & 0xFF;
            int n4 = byArray2[n2 * 3 + 2] & 0xFF;
            stringBuffer.append(BASE_64_TABLE[n >> 2]);
            stringBuffer.append(BASE_64_TABLE[(n << 4 | n3 >> 4) & 0x3F]);
            stringBuffer.append(BASE_64_TABLE[(n3 << 2 | n4 >> 6) & 0x3F]);
            stringBuffer.append(BASE_64_TABLE[n4 & 0x3F]);
        }
        n2 = byArray2[18] & 0xFF;
        n = byArray2[19] & 0xFF;
        stringBuffer.append(BASE_64_TABLE[n2 >> 2]);
        stringBuffer.append(BASE_64_TABLE[(n2 << 4 | n >> 4) & 0x3F]);
        stringBuffer.append(BASE_64_TABLE[n << 2 & 0x3F]);
        return stringBuffer.toString();
    }
}

