/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class XMLParserActivator
implements BundleActivator,
ServiceFactory {
    private volatile BundleContext context;
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String PARSERCLASSFILEPATH = "/META-INF/services/";
    public static final String SAXCLASSFILE = "/META-INF/services/javax.xml.parsers.SAXParserFactory";
    public static final String DOMCLASSFILE = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAXFACTORYDESCRIPTION = "A JAXP Compliant SAX Parser";
    private static final String DOMFACTORYDESCRIPTION = "A JAXP Compliant DOM Parser";
    public static final String PARSER_VALIDATING = "parser.validating";
    public static final String PARSER_NAMESPACEAWARE = "parser.namespaceAware";
    private static final String FACTORYNAMEKEY = "parser.factoryname";

    public void start(BundleContext bundleContext) throws Exception {
        this.context = bundleContext;
        Bundle bundle = bundleContext.getBundle();
        this.registerSAXParsers(this.getParserFactoryClassNames(bundle.getResource(SAXCLASSFILE)));
        this.registerDOMParsers(this.getParserFactoryClassNames(bundle.getResource(DOMCLASSFILE)));
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    private List getParserFactoryClassNames(URL uRL) throws IOException {
        if (uRL == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        String string = null;
        InputStream inputStream = uRL.openStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            String string2 = string.trim();
            if (string2.length() == 0 || (n = string2.indexOf("#")) == 0) continue;
            if (n < 0) {
                arrayList.add(string2);
                continue;
            }
            arrayList.add(string2.substring(0, n).trim());
        }
        return arrayList;
    }

    private void registerSAXParsers(List list) throws FactoryConfigurationError {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SAXParserFactory sAXParserFactory = (SAXParserFactory)this.getFactory(string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>(7);
            this.setDefaultSAXProperties(sAXParserFactory, hashtable, n);
            hashtable.put(FACTORYNAMEKEY, string);
            this.context.registerService(SAXFACTORYNAME, (Object)this, hashtable);
            ++n;
        }
    }

    private void setDefaultSAXProperties(SAXParserFactory sAXParserFactory, Hashtable hashtable, int n) {
        hashtable.put("service.description", SAXFACTORYDESCRIPTION);
        hashtable.put("service.pid", "javax.xml.parsers.SAXParserFactory." + this.context.getBundle().getBundleId() + "." + n);
        this.setSAXProperties(sAXParserFactory, hashtable);
    }

    public void setSAXProperties(SAXParserFactory sAXParserFactory, Hashtable hashtable) {
        boolean bl = true;
        sAXParserFactory.setValidating(true);
        sAXParserFactory.setNamespaceAware(false);
        try {
            sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            bl = false;
        }
        boolean bl2 = true;
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        try {
            sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        sAXParserFactory.setValidating(bl);
        sAXParserFactory.setNamespaceAware(bl2);
        hashtable.put(PARSER_NAMESPACEAWARE, new Boolean(bl2));
        hashtable.put(PARSER_VALIDATING, new Boolean(bl));
    }

    private void registerDOMParsers(List list) throws FactoryConfigurationError {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DocumentBuilderFactory documentBuilderFactory = (DocumentBuilderFactory)this.getFactory(string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>(7);
            this.setDefaultDOMProperties(documentBuilderFactory, hashtable, n);
            hashtable.put(FACTORYNAMEKEY, string);
            this.context.registerService(DOMFACTORYNAME, (Object)this, hashtable);
            ++n;
        }
    }

    private void setDefaultDOMProperties(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable, int n) {
        hashtable.put("service.description", DOMFACTORYDESCRIPTION);
        hashtable.put("service.pid", "javax.xml.parsers.DocumentBuilderFactory." + this.context.getBundle().getBundleId() + "." + n);
        this.setDOMProperties(documentBuilderFactory, hashtable);
    }

    public void setDOMProperties(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable) {
        boolean bl = true;
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(false);
        try {
            documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            bl = false;
        }
        boolean bl2 = true;
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            bl2 = false;
        }
        documentBuilderFactory.setValidating(bl);
        documentBuilderFactory.setNamespaceAware(bl2);
        hashtable.put(PARSER_VALIDATING, new Boolean(bl));
        hashtable.put(PARSER_NAMESPACEAWARE, new Boolean(bl2));
    }

    private Object getFactory(String string) throws FactoryConfigurationError {
        try {
            return this.context.getBundle().loadClass(string).newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError(exception);
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        ServiceReference serviceReference = serviceRegistration.getReference();
        String string = (String)serviceReference.getProperty(FACTORYNAMEKEY);
        Object object = this.getFactory(string);
        if (object instanceof SAXParserFactory) {
            ((SAXParserFactory)object).setValidating((Boolean)serviceReference.getProperty(PARSER_VALIDATING));
            ((SAXParserFactory)object).setNamespaceAware((Boolean)serviceReference.getProperty(PARSER_NAMESPACEAWARE));
        } else if (object instanceof DocumentBuilderFactory) {
            ((DocumentBuilderFactory)object).setValidating((Boolean)serviceReference.getProperty(PARSER_VALIDATING));
            ((DocumentBuilderFactory)object).setNamespaceAware((Boolean)serviceReference.getProperty(PARSER_NAMESPACEAWARE));
        }
        return object;
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object object) {
    }
}

