/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.PositionRange;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;

public class FilterEnumerator
implements NodeEnumeration {
    private NodeEnumeration base;
    private Expression filter;
    private int position = 0;
    private int last = -1;
    int min = 1;
    int max = Integer.MAX_VALUE;
    private NodeInfo current = null;
    private Context filterContext;
    private int dataType = -1;
    private boolean positional = false;
    private boolean finished = false;
    private boolean finishAfterReject = false;

    public FilterEnumerator(NodeEnumeration nodeEnumeration, Expression expression, Context context, boolean bl) throws XPathException {
        this.base = nodeEnumeration;
        this.filter = expression;
        this.finishAfterReject = bl;
        this.filterContext = context.newContext();
        this.dataType = expression.getDataType();
        if (expression instanceof NumericValue) {
            double d = ((NumericValue)expression).asNumber();
            if (Math.floor(d) == d) {
                this.max = this.min = (int)d;
                this.positional = true;
            } else {
                this.finished = true;
            }
        } else if (expression instanceof PositionRange) {
            this.min = ((PositionRange)expression).getMinPosition();
            this.max = ((PositionRange)expression).getMaxPosition();
            this.positional = true;
        }
        if (nodeEnumeration instanceof LastPositionFinder) {
            this.filterContext.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        } else {
            this.base = new LookaheadEnumerator(nodeEnumeration);
            this.filterContext.setLastPositionFinder((LastPositionFinder)((Object)this.base));
        }
        this.current = this.getNextMatchingElement();
    }

    @Override
    public boolean hasMoreElements() {
        if (this.finished) {
            return false;
        }
        return this.current != null;
    }

    @Override
    public NodeInfo nextElement() throws XPathException {
        NodeInfo nodeInfo = this.current;
        this.current = this.getNextMatchingElement();
        return nodeInfo;
    }

    private NodeInfo getNextMatchingElement() throws XPathException {
        while (!this.finished && this.base.hasMoreElements()) {
            NodeInfo nodeInfo = this.base.nextElement();
            ++this.position;
            if (this.matches(nodeInfo)) {
                return nodeInfo;
            }
            if (!this.finishAfterReject) continue;
            return null;
        }
        return null;
    }

    private boolean matches(NodeInfo nodeInfo) throws XPathException {
        if (this.positional) {
            if (this.position < this.min) {
                return false;
            }
            if (this.position > this.max) {
                this.finished = true;
                return false;
            }
            return true;
        }
        this.filterContext.setPosition(this.position);
        this.filterContext.setContextNode(nodeInfo);
        if (this.dataType == 2) {
            double d = (int)this.filter.evaluateAsNumber(this.filterContext);
            return (double)this.position == d;
        }
        if (this.dataType == -1) {
            Value value = this.filter.evaluate(this.filterContext);
            if (value instanceof NumericValue) {
                return (double)this.position == value.asNumber();
            }
            return value.asBoolean();
        }
        return this.filter.evaluateAsBoolean(this.filterContext);
    }

    @Override
    public boolean isSorted() {
        return this.base.isSorted();
    }

    @Override
    public boolean isReverseSorted() {
        return this.base.isReverseSorted();
    }

    @Override
    public boolean isPeer() {
        return this.base.isPeer();
    }
}

