/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.Comparer;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.sort.QuickSort;
import com.icl.saxon.sort.SortKeyDefinition;
import com.icl.saxon.sort.Sortable;

public final class SortKeyEnumeration
implements NodeEnumeration,
LastPositionFinder,
Sortable {
    protected NodeEnumeration base;
    private SortKeyDefinition[] sortkeys;
    private int recordSize;
    private Object[] nodeKeys;
    private int count = -1;
    private int index = 0;
    private Context context;
    private Controller controller;
    private Comparer[] keyComparers;

    public SortKeyEnumeration(Context context, NodeEnumeration nodeEnumeration, SortKeyDefinition[] sortKeyDefinitionArray) throws XPathException {
        int n;
        this.context = context.newContext();
        this.controller = context.getController();
        this.base = nodeEnumeration;
        this.sortkeys = sortKeyDefinitionArray;
        this.recordSize = sortKeyDefinitionArray.length + 1;
        this.keyComparers = new Comparer[sortKeyDefinitionArray.length];
        for (n = 0; n < sortKeyDefinitionArray.length; ++n) {
            this.keyComparers[n] = sortKeyDefinitionArray[n].getComparer(context);
        }
        if (!this.base.isSorted()) {
            n = 0;
            for (int i = 0; i < sortKeyDefinitionArray.length; ++i) {
                SortKeyDefinition sortKeyDefinition = sortKeyDefinitionArray[i];
                Expression expression = sortKeyDefinition.getSortKey();
                if ((expression.getDependencies() & 0x30) == 0) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                NodeSetExtent nodeSetExtent = new NodeSetExtent(this.base, (NodeOrderComparer)this.controller);
                nodeSetExtent.sort();
                this.base = nodeSetExtent.enumerate();
            }
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.count < 0) {
            return this.base.hasMoreElements();
        }
        return this.index < this.count;
    }

    @Override
    public NodeInfo nextElement() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return (NodeInfo)this.nodeKeys[this.index++ * this.recordSize];
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isReverseSorted() {
        return false;
    }

    @Override
    public boolean isPeer() {
        return this.base.isPeer();
    }

    @Override
    public int getLastPosition() throws XPathException {
        if (this.base instanceof LastPositionFinder && !(this.base instanceof LookaheadEnumerator)) {
            return ((LastPositionFinder)((Object)this.base)).getLastPosition();
        }
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    private void buildArray() throws XPathException {
        int n;
        if (this.base instanceof LastPositionFinder && !(this.base instanceof LookaheadEnumerator)) {
            n = ((LastPositionFinder)((Object)this.base)).getLastPosition();
            this.context.setLast(n);
        } else {
            n = 100;
        }
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        while (this.base.hasMoreElements()) {
            NodeInfo nodeInfo = this.base.nextElement();
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            this.context.setCurrentNode(nodeInfo);
            this.context.setContextNode(nodeInfo);
            this.context.setPosition(this.count + 1);
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = nodeInfo;
            for (int i = 0; i < this.sortkeys.length; ++i) {
                this.nodeKeys[n2 + i + 1] = this.sortkeys[i].getSortKey().evaluateAsString(this.context);
            }
            ++this.count;
        }
    }

    private void diag() {
        System.err.println("Diagnostic print of keys");
        for (int i = 0; i < this.count * this.recordSize; ++i) {
            System.err.println(i + " : " + this.nodeKeys[i]);
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        QuickSort.sort(this, 0, this.count - 1);
    }

    @Override
    public int compare(int n, int n2) {
        int n3 = n * this.recordSize + 1;
        int n4 = n2 * this.recordSize + 1;
        for (int i = 0; i < this.sortkeys.length; ++i) {
            Comparer comparer = this.keyComparers[i];
            int n5 = comparer.compare(this.nodeKeys[n3 + i], this.nodeKeys[n4 + i]);
            if (n5 == 0) continue;
            return n5;
        }
        return this.controller.compare((NodeInfo)this.nodeKeys[n3 - 1], (NodeInfo)this.nodeKeys[n4 - 1]);
    }

    @Override
    public void swap(int n, int n2) {
        int n3 = n * this.recordSize;
        int n4 = n2 * this.recordSize;
        for (int i = 0; i < this.recordSize; ++i) {
            Object object = this.nodeKeys[n3 + i];
            this.nodeKeys[n3 + i] = this.nodeKeys[n4 + i];
            this.nodeKeys[n4 + i] = object;
        }
    }
}

