/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class ElementAvailable
extends Function {
    @Override
    public String getName() {
        return "element-available";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        if (this.argument[0] instanceof Value) {
            return this.evaluate(null);
        }
        return this;
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        String string = this.argument[0].evaluateAsString(context);
        return this.getStaticContext().isElementAvailable(string);
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public int getDependencies() {
        return this.argument[0].getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        ElementAvailable elementAvailable = new ElementAvailable();
        elementAvailable.addArgument(this.argument[0].reduce(n, context));
        elementAvailable.setStaticContext(this.getStaticContext());
        return elementAvailable.simplify();
    }
}

