/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.CDATAFilter;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.HTMLEmitter;
import com.icl.saxon.output.HTMLIndenter;
import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.output.XMLIndenter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class UncommittedEmitter
extends ProxyEmitter {
    boolean committed = false;
    boolean initialNewline = false;
    boolean initialEscaping = true;
    StringBuffer pendingCharacters;

    @Override
    public void startDocument() throws TransformerException {
        this.committed = false;
    }

    @Override
    public void endDocument() throws TransformerException {
        if (!this.committed) {
            this.switchToXML();
        }
        super.endDocument();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (!this.committed) {
            boolean bl = true;
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            for (int i = n; i < n + n2; ++i) {
                char c = cArray[i];
                if (!Character.isWhitespace(c)) {
                    bl = false;
                }
                if (this.initialEscaping) {
                    if (c == '<') {
                        this.pendingCharacters.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        this.pendingCharacters.append("&gt;");
                        continue;
                    }
                    if (c == '&') {
                        this.pendingCharacters.append("&amp;");
                        continue;
                    }
                    this.pendingCharacters.append(c);
                    continue;
                }
                this.pendingCharacters.append(c);
            }
            if (!bl) {
                this.switchToXML();
            }
        } else {
            super.characters(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws TransformerException {
        if (!this.committed) {
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            this.pendingCharacters.append("<?" + string + " " + string2 + "?>");
        } else {
            super.processingInstruction(string, string2);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        if (!this.committed) {
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            this.pendingCharacters.append("<!--" + new String(cArray, n, n2) + "-->");
        } else {
            super.comment(cArray, n, n2);
        }
    }

    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        if (!this.committed) {
            String string = this.namePool.getLocalName(n);
            short s = this.namePool.getURICode(n);
            if (string.equalsIgnoreCase("html") && s == 0) {
                this.switchToHTML();
            } else {
                this.switchToXML();
            }
        }
        super.startElement(n, attributes, nArray, n2);
    }

    private void switchToXML() throws TransformerException {
        Object object;
        Object object2 = new XMLEmitter();
        String string = this.outputProperties.getProperty("indent");
        if (string != null && string.equals("yes")) {
            object = new XMLIndenter();
            ((ProxyEmitter)object).setUnderlyingEmitter((Emitter)object2);
            object2 = object;
        }
        if ((object = this.outputProperties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            CDATAFilter cDATAFilter = new CDATAFilter();
            cDATAFilter.setUnderlyingEmitter((Emitter)object2);
            object2 = cDATAFilter;
        }
        this.switchTo((Emitter)object2);
    }

    private void switchToHTML() throws TransformerException {
        Emitter emitter = new HTMLEmitter();
        String string = this.outputProperties.getProperty("indent");
        if (string == null || string.equals("yes")) {
            HTMLIndenter hTMLIndenter = new HTMLIndenter();
            hTMLIndenter.setUnderlyingEmitter(emitter);
            emitter = hTMLIndenter;
        }
        this.switchTo(emitter);
    }

    @Override
    public void setEscaping(boolean bl) throws TransformerException {
        if (!this.committed) {
            this.initialEscaping = bl;
        }
        super.setEscaping(bl);
    }

    private void switchTo(Emitter emitter) throws TransformerException {
        this.setUnderlyingEmitter(emitter);
        this.committed = true;
        emitter.setWriter(this.writer);
        emitter.setOutputProperties(this.outputProperties);
        emitter.startDocument();
        if (this.pendingCharacters != null) {
            emitter.setEscaping(false);
            int n = this.pendingCharacters.length();
            char[] cArray = new char[n];
            this.pendingCharacters.getChars(0, n, cArray, 0);
            emitter.characters(cArray, 0, n);
        }
        emitter.setEscaping(this.initialEscaping);
    }
}

