/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLAttribute;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class XSLAttributeSet
extends StyleElement {
    int fingerprint;
    String use;
    Procedure procedure = new Procedure();

    public int getAttributeSetFingerprint() {
        return this.fingerprint;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        this.use = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.NAME) {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.USE_ATTRIBUTE_SETS) {
                this.use = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        if (!Name.isQName(string)) {
            this.compileError("Attribute set name must be a valid QName");
        }
        try {
            this.fingerprint = this.makeNameCode(string, false) & 0xFFFFF;
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof XSLAttribute) continue;
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set");
        }
        if (this.use != null) {
            this.findAttributeSets(this.use);
        }
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
    }

    @Override
    public void process(Context context) throws TransformerException {
    }

    public void expand(Context context) throws TransformerException {
        this.processAttributeSets(context);
        if (this.procedure.getNumberOfVariables() == 0) {
            this.processChildren(context);
        } else {
            Bindery bindery = context.getController().getBindery();
            bindery.openStackFrame(null);
            this.processChildren(context);
            bindery.closeStackFrame();
        }
    }
}

