/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.Version;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.XSLGeneralOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;

public class XSLDocument
extends XSLGeneralOutput {
    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        super.prepareAttributes();
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        if (this.getURI().equals("http://www.w3.org/1999/XSL/Transform") && !this.forwardsCompatibleModeIsEnabled()) {
            this.compileError("To use xsl:document, set xsl:stylesheet version='1.1'");
        }
        this.checkWithinTemplate();
    }

    @Override
    public void process(Context context) throws TransformerException {
        FileOutputStream fileOutputStream;
        Object object;
        Object object2;
        Object object3;
        Controller controller = context.getController();
        Outputter outputter = controller.getOutputter();
        Properties properties = outputter.getOutputProperties();
        Properties properties2 = new Properties(properties);
        this.updateOutputProperties(properties2, context);
        Object object4 = null;
        String string = this.href.evaluateAsString(context);
        try {
            object3 = new File(string);
            if (!((File)object3).exists() && (object2 = ((File)object3).getParent()) != null && !Version.isPreJDK12()) {
                object = new File((String)object2);
                if (object != null && !((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                ((File)object3).createNewFile();
            }
            fileOutputStream = new FileOutputStream((File)object3);
            object4 = new StreamResult(fileOutputStream);
        }
        catch (IOException iOException) {
            throw new TransformerException("Failed to create output file " + string, iOException);
        }
        if (this.nextInChain != null) {
            object3 = this.nextInChain.evaluateAsString(context);
            object2 = this.prepareNextStylesheet((String)object3, context);
            object = new ContentHandlerProxy();
            ((Emitter)object).setSystemId(this.getSystemId());
            ((ContentHandlerProxy)object).setUnderlyingContentHandler((ContentHandler)object2);
            ((ContentHandlerProxy)object).setRequireWellFormed(false);
            object2.setResult((Result)object4);
            object4 = object;
        }
        controller.changeOutputDestination(properties2, (Result)object4);
        this.processChildren(context);
        controller.resetOutputDestination(outputter);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new TransformerException("Failed to close output file", iOException);
        }
    }
}

