/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLForEach
extends StyleElement {
    Expression select = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.SELECT) {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.select = this.handleSortKeys(this.select);
    }

    @Override
    public void process(Context context) throws TransformerException {
        XSLTemplate xSLTemplate = context.getCurrentTemplate();
        context.setCurrentTemplate(null);
        NodeEnumeration nodeEnumeration = this.select.enumerate(context, false);
        if (!(nodeEnumeration instanceof LastPositionFinder)) {
            nodeEnumeration = new LookaheadEnumerator(nodeEnumeration);
        }
        Context context2 = context.newContext();
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        int n = 1;
        if (context.getController().isTracing()) {
            TraceListener traceListener = context.getController().getTraceListener();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                context2.setPosition(n++);
                context2.setCurrentNode(nodeInfo);
                context2.setContextNode(nodeInfo);
                traceListener.enterSource(null, context2);
                this.processChildren(context2);
                traceListener.leaveSource(null, context2);
                context.setReturnValue(context2.getReturnValue());
            }
        } else {
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                context2.setPosition(n++);
                context2.setCurrentNode(nodeInfo);
                context2.setContextNode(nodeInfo);
                this.processChildren(context2);
                context.setReturnValue(context2.getReturnValue());
            }
        }
        context.setCurrentTemplate(xSLTemplate);
    }
}

