/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.KeyManager;
import com.icl.saxon.Mode;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.RuleManager;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.Stripper;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLGeneralIncorporate;
import com.icl.saxon.style.XSLNamespaceAlias;
import com.icl.saxon.style.XSLOutput;
import com.icl.saxon.style.XSLScript;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.trace.SimpleTraceListener;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLStyleSheet
extends StyleElement {
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStyleSheet importer = null;
    private PreparedStyleSheet stylesheet;
    private Vector topLevel;
    private Mode stripperRules = null;
    private RuleManager ruleManager;
    private KeyManager keyManager = new KeyManager();
    private DecimalFormatManager decimalFormatManager = new DecimalFormatManager();
    private PreviewManager previewManager = null;
    private int numberOfAliases = 0;
    private short[] aliasSCodes = new short[5];
    private short[] aliasRCodes = new short[5];
    private int numberOfVariables = 0;
    private int largestStackFrame = 0;

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.stylesheet = preparedStyleSheet;
        this.ruleManager = new RuleManager(preparedStyleSheet.getNamePool());
    }

    @Override
    public PreparedStyleSheet getPreparedStyleSheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStyleSheet();
        }
        return this.stylesheet;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    protected Mode getStripperRules() {
        if (this.stripperRules == null) {
            this.stripperRules = new Mode();
        }
        return this.stripperRules;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        StandardNames standardNames = this.getStandardNames();
        for (int i = 0; i < this.topLevel.size(); ++i) {
            NodeInfo nodeInfo = (NodeInfo)this.topLevel.elementAt(i);
            if (nodeInfo.getFingerprint() != standardNames.XSL_STRIP_SPACE) continue;
            return true;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public PreviewManager getPreviewManager() {
        return this.previewManager;
    }

    public void setPreviewManager(PreviewManager previewManager) {
        this.previewManager = previewManager;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    @Override
    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int n) {
        this.minImportPrecedence = n;
    }

    public void setImporter(XSLStyleSheet xSLStyleSheet) {
        this.importer = xSLStyleSheet;
    }

    public XSLStyleSheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public boolean wasIncluded() {
        return this.wasIncluded;
    }

    public Vector getTopLevel() {
        return this.topLevel;
    }

    public int allocateSlotNumber() {
        return this.numberOfVariables++;
    }

    public void allocateLocalSlots(int n) {
        if (n > this.largestStackFrame) {
            this.largestStackFrame = n;
        }
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.VERSION) {
                this.version = attributeCollection.getValueByFingerprint(n2);
                continue;
            }
            if (n2 == standardNames.ID || n2 == standardNames.EXTENSION_ELEMENT_PREFIXES || n2 == standardNames.EXCLUDE_RESULT_PREFIXES) continue;
            this.checkUnknownAttribute(n);
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
    }

    @Override
    protected void processVersionAttribute(int n) {
        this.version = this.getAttributeValue(n & 0xFFFFF);
    }

    protected short getNamespaceAlias(short s) {
        for (int i = this.numberOfAliases - 1; i >= 0; --i) {
            if (s != this.aliasSCodes[i]) continue;
            return this.aliasRCodes[i];
        }
        return s;
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (!(this.getParentNode() instanceof DocumentInfo)) {
            throw new TransformerConfigurationException(this.getDisplayName() + " must be the outermost element");
        }
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        Object e;
        int n;
        this.spliceIncludes();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        this.validate();
        for (n = 0; n < this.topLevel.size(); ++n) {
            e = this.topLevel.elementAt(n);
            if (!(e instanceof StyleElement)) continue;
            ((StyleElement)e).validateSubtree();
        }
        for (n = 0; n < this.topLevel.size(); ++n) {
            e = this.topLevel.elementAt(n);
            if (!(e instanceof StyleElement)) continue;
            try {
                ((StyleElement)e).preprocess();
                continue;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                ((StyleElement)e).compileError(transformerConfigurationException);
            }
        }
    }

    public void spliceIncludes() throws TransformerConfigurationException {
        boolean bl = false;
        this.topLevel = new Vector();
        this.minImportPrecedence = this.precedence;
        StyleElement styleElement = this;
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            if (nodeImpl.getNodeType() == 3) {
                if (Navigator.isWhite(nodeImpl.getStringValue())) continue;
                styleElement.compileError("No character data is allowed between top-level elements");
                continue;
            }
            styleElement = (StyleElement)nodeImpl;
            if (nodeImpl instanceof XSLGeneralIncorporate) {
                XSLStyleSheet xSLStyleSheet;
                XSLGeneralIncorporate xSLGeneralIncorporate = (XSLGeneralIncorporate)nodeImpl;
                xSLGeneralIncorporate.processAttributes();
                if (xSLGeneralIncorporate.isImport()) {
                    if (bl) {
                        xSLGeneralIncorporate.compileError("xsl:import elements must come first");
                    }
                } else {
                    bl = true;
                }
                if ((xSLStyleSheet = xSLGeneralIncorporate.getIncludedStyleSheet(this, this.precedence)) == null) {
                    return;
                }
                if (xSLGeneralIncorporate.isImport()) {
                    this.precedence = xSLStyleSheet.getPrecedence() + 1;
                } else {
                    this.precedence = xSLStyleSheet.getPrecedence();
                    xSLStyleSheet.setMinImportPrecedence(this.minImportPrecedence);
                    xSLStyleSheet.setWasIncluded();
                }
                Vector vector = xSLStyleSheet.topLevel;
                for (int i = 0; i < vector.size(); ++i) {
                    StyleElement styleElement2 = (StyleElement)vector.elementAt(i);
                    int n = this.topLevel.size() - 1;
                    if (n < 0 || styleElement2.getPrecedence() >= ((StyleElement)this.topLevel.elementAt(n)).getPrecedence()) {
                        this.topLevel.addElement(styleElement2);
                        continue;
                    }
                    while (n >= 0 && styleElement2.getPrecedence() < ((StyleElement)this.topLevel.elementAt(n)).getPrecedence()) {
                        --n;
                    }
                    this.topLevel.insertElementAt(styleElement2, n + 1);
                }
                continue;
            }
            bl = true;
            this.topLevel.addElement(nodeImpl);
        }
    }

    private void collectNamespaceAliases() {
        for (int i = 0; i < this.topLevel.size(); ++i) {
            Object e = this.topLevel.elementAt(i);
            if (!(e instanceof XSLNamespaceAlias)) continue;
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)e;
            if (this.numberOfAliases == this.aliasSCodes.length) {
                short[] sArray = new short[this.numberOfAliases * 2];
                short[] sArray2 = new short[this.numberOfAliases * 2];
                System.arraycopy(this.aliasSCodes, 0, sArray, 0, this.numberOfAliases);
                System.arraycopy(this.aliasRCodes, 0, sArray2, 0, this.numberOfAliases);
                this.aliasSCodes = sArray;
                this.aliasRCodes = sArray2;
            }
            this.aliasSCodes[this.numberOfAliases] = xSLNamespaceAlias.getStylesheetURICode();
            this.aliasRCodes[this.numberOfAliases] = xSLNamespaceAlias.getResultURICode();
            ++this.numberOfAliases;
        }
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    @Override
    public void processAllAttributes() throws TransformerConfigurationException {
        this.prepareAttributes();
        Vector vector = this.topLevel;
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof StyleElement)) continue;
            try {
                ((StyleElement)e).processAllAttributes();
                continue;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                ((StyleElement)e).compileError(transformerConfigurationException);
            }
        }
    }

    public void initialiseBindery(Bindery bindery) {
        bindery.allocateGlobals(this.numberOfVariables);
        bindery.allocateLocals(this.largestStackFrame);
    }

    public void gatherOutputProperties(Properties properties) {
        Vector vector = this.topLevel;
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof XSLOutput)) continue;
            ((XSLOutput)e).gatherOutputProperties(properties);
        }
    }

    public void updateOutputProperties(Properties properties, Context context) throws TransformerException {
        Vector vector = this.topLevel;
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof XSLOutput)) continue;
            ((XSLOutput)e).updateOutputProperties(properties, context);
        }
    }

    public Class getExternalJavaClass(String string) throws TransformerException {
        Vector vector = this.topLevel;
        if (!((Boolean)this.getPreparedStyleSheet().getTransformerFactory().getAttribute("http://icl.com/saxon/feature/allow-external-functions")).booleanValue()) {
            return null;
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            XSLScript xSLScript;
            Class clazz;
            Object e = vector.elementAt(i);
            if (!(e instanceof XSLScript) || (clazz = (xSLScript = (XSLScript)e).getJavaClass(string)) == null) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public void process(Context context) throws TransformerException {
        Object e;
        int n;
        Controller controller = context.getController();
        String string = this.getAttributeValue("http://icl.com/saxon", "trace");
        if (string != null && string.equals("yes")) {
            controller.setTraceListener(new SimpleTraceListener());
        }
        Vector vector = this.topLevel;
        boolean bl = controller.isTracing();
        TraceListener traceListener = null;
        if (bl) {
            traceListener = controller.getTraceListener();
            for (n = 0; n < vector.size(); ++n) {
                e = vector.elementAt(n);
                traceListener.toplevel((NodeInfo)e);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            e = vector.elementAt(n);
            if (!(e instanceof StyleElement)) continue;
            try {
                if (bl && !(e instanceof XSLTemplate)) {
                    traceListener.enter((StyleElement)e, context);
                    ((StyleElement)e).process(context);
                    traceListener.leave((StyleElement)e, context);
                    continue;
                }
                ((StyleElement)e).process(context);
                continue;
            }
            catch (TransformerException transformerException) {
                throw ((StyleElement)e).styleError(transformerException);
            }
        }
    }
}

