/* Request.c generated by valac 0.52.4, the Vala compiler
 * generated from Request.vala, do not modify */

#include <libsoup/soup.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>

#define TOOTLE_TYPE_REQUEST (tootle_request_get_type ())
#define TOOTLE_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_REQUEST, TootleRequest))
#define TOOTLE_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_REQUEST, TootleRequestClass))
#define TOOTLE_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_REQUEST))
#define TOOTLE_IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_REQUEST))
#define TOOTLE_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_REQUEST, TootleRequestClass))

typedef struct _TootleRequest TootleRequest;
typedef struct _TootleRequestClass TootleRequestClass;
typedef struct _TootleRequestPrivate TootleRequestPrivate;
typedef void (*TootleNetworkSuccessCallback) (SoupSession* session, SoupMessage* msg, gpointer user_data, GError** error);
typedef void (*TootleNetworkErrorCallback) (gint32 code, const gchar* reason, gpointer user_data);

#define TOOTLE_TYPE_ENTITY (tootle_entity_get_type ())
#define TOOTLE_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_ENTITY, TootleEntity))
#define TOOTLE_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_ENTITY, TootleEntityClass))
#define TOOTLE_IS_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_ENTITY))
#define TOOTLE_IS_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_ENTITY))
#define TOOTLE_ENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_ENTITY, TootleEntityClass))

typedef struct _TootleEntity TootleEntity;
typedef struct _TootleEntityClass TootleEntityClass;

#define TOOTLE_API_TYPE_ACCOUNT (tootle_api_account_get_type ())
#define TOOTLE_API_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_API_TYPE_ACCOUNT, TootleAPIAccount))
#define TOOTLE_API_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_API_TYPE_ACCOUNT, TootleAPIAccountClass))
#define TOOTLE_API_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_API_TYPE_ACCOUNT))
#define TOOTLE_API_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_API_TYPE_ACCOUNT))
#define TOOTLE_API_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_API_TYPE_ACCOUNT, TootleAPIAccountClass))

typedef struct _TootleAPIAccount TootleAPIAccount;
typedef struct _TootleAPIAccountClass TootleAPIAccountClass;

#define TOOTLE_TYPE_INSTANCE_ACCOUNT (tootle_instance_account_get_type ())
#define TOOTLE_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_INSTANCE_ACCOUNT, TootleInstanceAccount))
#define TOOTLE_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_INSTANCE_ACCOUNT, TootleInstanceAccountClass))
#define TOOTLE_IS_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_INSTANCE_ACCOUNT))
#define TOOTLE_IS_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_INSTANCE_ACCOUNT))
#define TOOTLE_INSTANCE_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_INSTANCE_ACCOUNT, TootleInstanceAccountClass))

typedef struct _TootleInstanceAccount TootleInstanceAccount;
typedef struct _TootleInstanceAccountClass TootleInstanceAccountClass;
enum  {
	TOOTLE_REQUEST_0_PROPERTY,
	TOOTLE_REQUEST_URL_PROPERTY,
	TOOTLE_REQUEST_NUM_PROPERTIES
};
static GParamSpec* tootle_request_properties[TOOTLE_REQUEST_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*TootleNetworkNodeCallback) (JsonNode* node, SoupMessage* msg, gpointer user_data, GError** error);
typedef struct _Block1Data Block1Data;

#define TOOTLE_TYPE_NETWORK (tootle_network_get_type ())
#define TOOTLE_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_NETWORK, TootleNetwork))
#define TOOTLE_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_NETWORK, TootleNetworkClass))
#define TOOTLE_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_NETWORK))
#define TOOTLE_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_NETWORK))
#define TOOTLE_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_NETWORK, TootleNetworkClass))

typedef struct _TootleNetwork TootleNetwork;
typedef struct _TootleNetworkClass TootleNetworkClass;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _TootleRequestAwaitData TootleRequestAwaitData;
typedef struct _Block5Data Block5Data;

struct _TootleRequest {
	SoupMessage parent_instance;
	TootleRequestPrivate * priv;
};

struct _TootleRequestClass {
	SoupMessageClass parent_class;
};

struct _TootleRequestPrivate {
	gchar* _url;
	TootleNetworkSuccessCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	TootleNetworkErrorCallback error_cb;
	gpointer error_cb_target;
	GDestroyNotify error_cb_target_destroy_notify;
	GeeHashMap* pars;
	TootleInstanceAccount* account;
	gboolean needs_token;
	GtkWidget* ctx;
	gboolean has_ctx;
};

struct _Block1Data {
	int _ref_count_;
	TootleRequest* self;
	TootleNetworkNodeCallback _cb;
	gpointer _cb_target;
	GDestroyNotify _cb_target_destroy_notify;
};

struct _Block2Data {
	int _ref_count_;
	TootleRequest* self;
	gchar* parameters;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gint parameters_counter;
};

struct _Block4Data {
	int _ref_count_;
	TootleRequest* self;
	gchar* _error_;
	gpointer _async_data_;
};

typedef enum  {
	TOOTLE_OOPSIE_USER,
	TOOTLE_OOPSIE_PARSING,
	TOOTLE_OOPSIE_INSTANCE,
	TOOTLE_OOPSIE_INTERNAL
} TootleOopsie;
#define TOOTLE_OOPSIE tootle_oopsie_quark ()
struct _TootleRequestAwaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TootleRequest* self;
	TootleRequest* result;
	Block4Data* _data4_;
	TootleRequest* _tmp0_;
	TootleRequest* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	TootleRequest* _tmp5_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	gchar* _result_;
	GeeArrayList* array;
	gchar* key;
};

static gint TootleRequest_private_offset;
static gpointer tootle_request_parent_class = NULL;
extern TootleNetwork* tootle_network;

GType tootle_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleRequest, g_object_unref)
GType tootle_entity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleEntity, g_object_unref)
GType tootle_api_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleAPIAccount, g_object_unref)
GType tootle_instance_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleInstanceAccount, g_object_unref)
TootleRequest* tootle_request_new_GET (const gchar* url);
TootleRequest* tootle_request_construct_GET (GType object_type,
                                             const gchar* url);
TootleRequest* tootle_request_new_POST (const gchar* url);
TootleRequest* tootle_request_construct_POST (GType object_type,
                                              const gchar* url);
TootleRequest* tootle_request_new_PUT (const gchar* url);
TootleRequest* tootle_request_construct_PUT (GType object_type,
                                             const gchar* url);
TootleRequest* tootle_request_new_DELETE (const gchar* url);
TootleRequest* tootle_request_construct_DELETE (GType object_type,
                                                const gchar* url);
TootleRequest* tootle_request_then (TootleRequest* self,
                                    TootleNetworkSuccessCallback cb,
                                    gpointer cb_target,
                                    GDestroyNotify cb_target_destroy_notify);
TootleRequest* tootle_request_then_parse_array (TootleRequest* self,
                                                TootleNetworkNodeCallback _cb,
                                                gpointer _cb_target,
                                                GDestroyNotify _cb_target_destroy_notify);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda19_ (Block1Data* _data1_,
                  SoupSession* sess,
                  SoupMessage* msg,
                  GError** error);
void tootle_network_parse_array (SoupMessage* msg,
                                 TootleNetworkNodeCallback cb,
                                 gpointer cb_target,
                                 GDestroyNotify cb_target_destroy_notify,
                                 GError** error);
static void ___lambda19__tootle_network_success_callback (SoupSession* session,
                                                   SoupMessage* msg,
                                                   gpointer self,
                                                   GError** error);
TootleRequest* tootle_request_with_ctx (TootleRequest* self,
                                        GtkWidget* ctx);
static void __lambda20_ (TootleRequest* self);
GType tootle_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleNetwork, g_object_unref)
void tootle_network_cancel (TootleNetwork* self,
                            SoupMessage* msg);
static void ___lambda20__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
TootleRequest* tootle_request_on_error (TootleRequest* self,
                                        TootleNetworkErrorCallback cb,
                                        gpointer cb_target,
                                        GDestroyNotify cb_target_destroy_notify);
TootleRequest* tootle_request_with_account (TootleRequest* self,
                                            TootleInstanceAccount* account);
TootleRequest* tootle_request_with_param (TootleRequest* self,
                                          const gchar* name,
                                          const gchar* val);
TootleRequest* tootle_request_exec (TootleRequest* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
const gchar* tootle_request_get_url (TootleRequest* self);
static gboolean ___lambda21_ (Block3Data* _data3_,
                       GeeMapEntry* entry);
static gboolean ____lambda21__gee_forall_func (gpointer g,
                                        gpointer self);
const gchar* tootle_instance_account_get_access_token (TootleInstanceAccount* self);
const gchar* tootle_instance_account_get_instance (TootleInstanceAccount* self);
void tootle_request_set_url (TootleRequest* self,
                             const gchar* value);
static void _vala_SoupURI_free (SoupURI* self);
void tootle_network_queue (TootleNetwork* self,
                           SoupMessage* mess,
                           TootleNetworkSuccessCallback cb,
                           gpointer cb_target,
                           GDestroyNotify cb_target_destroy_notify,
                           TootleNetworkErrorCallback ecb,
                           gpointer ecb_target,
                           GDestroyNotify ecb_target_destroy_notify);
static void tootle_request_await_data_free (gpointer _data);
void tootle_request_await (TootleRequest* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
TootleRequest* tootle_request_await_finish (TootleRequest* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static gboolean tootle_request_await_co (TootleRequestAwaitData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda22_ (Block4Data* _data4_,
                  gint32 code,
                  const gchar* reason);
static void ___lambda22__tootle_network_error_callback (gint32 code,
                                                 const gchar* reason,
                                                 gpointer self);
static void __lambda23_ (Block4Data* _data4_,
                  SoupSession* sess,
                  SoupMessage* msg,
                  GError** error);
static void ___lambda23__tootle_network_success_callback (SoupSession* session,
                                                   SoupMessage* msg,
                                                   gpointer self,
                                                   GError** error);
GQuark tootle_oopsie_quark (void);
gchar* tootle_request_array2string (GeeArrayList* array,
                                    const gchar* key);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda24_ (Block5Data* _data5_,
                      gchar* i);
static gboolean ___lambda24__gee_forall_func (gpointer g,
                                       gpointer self);
TootleRequest* tootle_request_new (void);
TootleRequest* tootle_request_construct (GType object_type);
static void tootle_request_finalize (GObject * obj);
static GType tootle_request_get_type_once (void);
static void _vala_tootle_request_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_tootle_request_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tootle_request_get_instance_private (TootleRequest* self)
{
	return G_STRUCT_MEMBER_P (self, TootleRequest_private_offset);
}

TootleRequest*
tootle_request_construct_GET (GType object_type,
                              const gchar* url)
{
	TootleRequest * self = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TootleRequest*) g_object_new (object_type, "method", "GET", "url", url, NULL);
	return self;
}

TootleRequest*
tootle_request_new_GET (const gchar* url)
{
	return tootle_request_construct_GET (TOOTLE_TYPE_REQUEST, url);
}

TootleRequest*
tootle_request_construct_POST (GType object_type,
                               const gchar* url)
{
	TootleRequest * self = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TootleRequest*) g_object_new (object_type, "method", "POST", "url", url, NULL);
	return self;
}

TootleRequest*
tootle_request_new_POST (const gchar* url)
{
	return tootle_request_construct_POST (TOOTLE_TYPE_REQUEST, url);
}

TootleRequest*
tootle_request_construct_PUT (GType object_type,
                              const gchar* url)
{
	TootleRequest * self = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TootleRequest*) g_object_new (object_type, "method", "PUT", "url", url, NULL);
	return self;
}

TootleRequest*
tootle_request_new_PUT (const gchar* url)
{
	return tootle_request_construct_PUT (TOOTLE_TYPE_REQUEST, url);
}

TootleRequest*
tootle_request_construct_DELETE (GType object_type,
                                 const gchar* url)
{
	TootleRequest * self = NULL;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TootleRequest*) g_object_new (object_type, "method", "DELETE", "url", url, NULL);
	return self;
}

TootleRequest*
tootle_request_new_DELETE (const gchar* url)
{
	return tootle_request_construct_DELETE (TOOTLE_TYPE_REQUEST, url);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TootleRequest*
tootle_request_then (TootleRequest* self,
                     TootleNetworkSuccessCallback cb,
                     gpointer cb_target,
                     GDestroyNotify cb_target_destroy_notify)
{
	TootleNetworkSuccessCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	TootleRequest* _tmp1_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	self->priv->cb = _tmp0_;
	self->priv->cb_target = _tmp0__target;
	self->priv->cb_target_destroy_notify = _tmp0__target_destroy_notify;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TootleRequest* self;
		self = _data1_->self;
		(_data1_->_cb_target_destroy_notify == NULL) ? NULL : (_data1_->_cb_target_destroy_notify (_data1_->_cb_target), NULL);
		_data1_->_cb = NULL;
		_data1_->_cb_target = NULL;
		_data1_->_cb_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda19_ (Block1Data* _data1_,
             SoupSession* sess,
             SoupMessage* msg,
             GError** error)
{
	TootleRequest* self;
	TootleNetworkNodeCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (sess != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = _data1_->_cb;
	_tmp0__target = _data1_->_cb_target;
	_tmp0__target_destroy_notify = _data1_->_cb_target_destroy_notify;
	_data1_->_cb = NULL;
	_data1_->_cb_target = NULL;
	_data1_->_cb_target_destroy_notify = NULL;
	tootle_network_parse_array (msg, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda19__tootle_network_success_callback (SoupSession* session,
                                              SoupMessage* msg,
                                              gpointer self,
                                              GError** error)
{
	__lambda19_ (self, session, msg, error);
}

TootleRequest*
tootle_request_then_parse_array (TootleRequest* self,
                                 TootleNetworkNodeCallback _cb,
                                 gpointer _cb_target,
                                 GDestroyNotify _cb_target_destroy_notify)
{
	Block1Data* _data1_;
	TootleRequest* _tmp0_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	(_data1_->_cb_target_destroy_notify == NULL) ? NULL : (_data1_->_cb_target_destroy_notify (_data1_->_cb_target), NULL);
	_data1_->_cb = NULL;
	_data1_->_cb_target = NULL;
	_data1_->_cb_target_destroy_notify = NULL;
	_data1_->_cb = _cb;
	_data1_->_cb_target = _cb_target;
	_data1_->_cb_target_destroy_notify = _cb_target_destroy_notify;
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	self->priv->cb = ___lambda19__tootle_network_success_callback;
	self->priv->cb_target = block1_data_ref (_data1_);
	self->priv->cb_target_destroy_notify = block1_data_unref;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
__lambda20_ (TootleRequest* self)
{
	TootleNetwork* _tmp0_;
	_tmp0_ = tootle_network;
	tootle_network_cancel (_tmp0_, (SoupMessage*) self);
	self->priv->ctx = NULL;
}

static void
___lambda20__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda20_ ((TootleRequest*) self);
}

TootleRequest*
tootle_request_with_ctx (TootleRequest* self,
                         GtkWidget* ctx)
{
	GtkWidget* _tmp0_;
	TootleRequest* _tmp1_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ctx != NULL, NULL);
	self->priv->has_ctx = TRUE;
	self->priv->ctx = ctx;
	_tmp0_ = self->priv->ctx;
	g_signal_connect_object (_tmp0_, "destroy", (GCallback) ___lambda20__gtk_widget_destroy, self, 0);
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

TootleRequest*
tootle_request_on_error (TootleRequest* self,
                         TootleNetworkErrorCallback cb,
                         gpointer cb_target,
                         GDestroyNotify cb_target_destroy_notify)
{
	TootleNetworkErrorCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	TootleRequest* _tmp1_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	(self->priv->error_cb_target_destroy_notify == NULL) ? NULL : (self->priv->error_cb_target_destroy_notify (self->priv->error_cb_target), NULL);
	self->priv->error_cb = NULL;
	self->priv->error_cb_target = NULL;
	self->priv->error_cb_target_destroy_notify = NULL;
	self->priv->error_cb = _tmp0_;
	self->priv->error_cb_target = _tmp0__target;
	self->priv->error_cb_target_destroy_notify = _tmp0__target_destroy_notify;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	return result;
}

TootleRequest*
tootle_request_with_account (TootleRequest* self,
                             TootleInstanceAccount* account)
{
	TootleRequest* _tmp0_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->needs_token = TRUE;
	if (account != NULL) {
		self->priv->account = account;
	}
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

TootleRequest*
tootle_request_with_param (TootleRequest* self,
                           const gchar* name,
                           const gchar* val)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	TootleRequest* _tmp3_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = self->priv->pars;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->pars);
		self->priv->pars = _tmp1_;
	}
	_tmp2_ = self->priv->pars;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, name, val);
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TootleRequest* self;
		self = _data2_->self;
		_g_free0 (_data2_->parameters);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TootleRequest* self;
		self = _data3_->_data2_->self;
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
___lambda21_ (Block3Data* _data3_,
              GeeMapEntry* entry)
{
	Block2Data* _data2_;
	TootleRequest* self;
	gint _tmp0_;
	gchar* key = NULL;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* val = NULL;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeHashMap* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean result = FALSE;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = _data3_->parameters_counter;
	_data3_->parameters_counter = _tmp0_ + 1;
	_tmp1_ = gee_map_entry_get_key (entry);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup ((const gchar*) ((const gchar*) _tmp2_));
	key = _tmp3_;
	_tmp4_ = gee_map_entry_get_value (entry);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup ((const gchar*) ((const gchar*) _tmp5_));
	val = _tmp6_;
	_tmp7_ = _data2_->parameters;
	_tmp8_ = key;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = val;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat (_tmp9_, "=", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
	_g_free0 (_data2_->parameters);
	_data2_->parameters = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = self->priv->pars;
	_tmp16_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_data3_->parameters_counter < _tmp17_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = _data2_->parameters;
		_tmp19_ = g_strconcat (_tmp18_, "&", NULL);
		_g_free0 (_data2_->parameters);
		_data2_->parameters = _tmp19_;
	}
	result = TRUE;
	_g_free0 (val);
	_g_free0 (key);
	_g_object_unref0 (entry);
	return result;
}

static gboolean
____lambda21__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda21_ (self, (GeeMapEntry*) g);
	return result;
}

static void
_vala_SoupURI_free (SoupURI* self)
{
	g_boxed_free (soup_uri_get_type (), self);
}

TootleRequest*
tootle_request_exec (TootleRequest* self)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp25_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	SoupURI* _tmp36_;
	SoupURI* _tmp37_;
	TootleNetwork* _tmp38_;
	SoupMessage* _tmp39_;
	TootleNetworkSuccessCallback _tmp40_;
	gpointer _tmp40__target;
	GDestroyNotify _tmp40__target_destroy_notify;
	TootleNetworkErrorCallback _tmp41_;
	gpointer _tmp41__target;
	GDestroyNotify _tmp41__target_destroy_notify;
	TootleRequest* _tmp42_;
	TootleRequest* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_data2_->parameters = _tmp0_;
	_tmp1_ = self->priv->pars;
	if (_tmp1_ != NULL) {
		Block3Data* _data3_;
		const gchar* _tmp2_;
		GeeHashMap* _tmp5_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp2_ = self->priv->_url;
		if (string_contains (_tmp2_, "?")) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			_g_free0 (_data2_->parameters);
			_data2_->parameters = _tmp3_;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("?");
			_g_free0 (_data2_->parameters);
			_data2_->parameters = _tmp4_;
		}
		_data3_->parameters_counter = 0;
		_tmp5_ = self->priv->pars;
		gee_abstract_map_foreach ((GeeAbstractMap*) _tmp5_, ____lambda21__gee_forall_func, _data3_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	if (self->priv->needs_token) {
		TootleInstanceAccount* _tmp6_;
		SoupMessageHeaders* _tmp18_;
		TootleInstanceAccount* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp6_ = self->priv->account;
		if (_tmp6_ == NULL) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			TootleRequest* _tmp17_;
			g_object_get ((SoupMessage*) self, "method", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = self->priv->_url;
			_tmp12_ = string_to_string (_tmp11_);
			_tmp13_ = _data2_->parameters;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("No account was specified or found for ", _tmp10_, ": ", _tmp12_, _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			g_warning ("Request.vala:94: %s", _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp9_);
			_tmp17_ = _g_object_ref0 (self);
			result = _tmp17_;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
		_tmp18_ = ((SoupMessage*) self)->request_headers;
		_tmp19_ = self->priv->account;
		_tmp20_ = tootle_instance_account_get_access_token (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("Bearer ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		soup_message_headers_append (_tmp18_, "Authorization", _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = self->priv->_url;
	if (!string_contains (_tmp25_, "://")) {
		TootleInstanceAccount* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp26_ = self->priv->account;
		_tmp27_ = tootle_instance_account_get_instance (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_url;
		_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		tootle_request_set_url (self, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = self->priv->_url;
	_tmp33_ = _data2_->parameters;
	_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = soup_uri_new (_tmp35_);
	_tmp37_ = _tmp36_;
	soup_message_set_uri ((SoupMessage*) self, _tmp37_);
	__vala_SoupURI_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp38_ = tootle_network;
	_tmp39_ = _g_object_ref0 ((SoupMessage*) self);
	_tmp40_ = self->priv->cb;
	_tmp40__target = self->priv->cb_target;
	_tmp40__target_destroy_notify = self->priv->cb_target_destroy_notify;
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	_tmp41_ = self->priv->error_cb;
	_tmp41__target = self->priv->error_cb_target;
	_tmp41__target_destroy_notify = self->priv->error_cb_target_destroy_notify;
	self->priv->error_cb = NULL;
	self->priv->error_cb_target = NULL;
	self->priv->error_cb_target_destroy_notify = NULL;
	tootle_network_queue (_tmp38_, _tmp39_, _tmp40_, _tmp40__target, _tmp40__target_destroy_notify, _tmp41_, _tmp41__target, _tmp41__target_destroy_notify);
	_tmp42_ = _g_object_ref0 (self);
	result = _tmp42_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
tootle_request_await_data_free (gpointer _data)
{
	TootleRequestAwaitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TootleRequestAwaitData, _data_);
}

void
tootle_request_await (TootleRequest* self,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	TootleRequestAwaitData* _data_;
	TootleRequest* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TootleRequestAwaitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tootle_request_await_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tootle_request_await_co (_data_);
}

TootleRequest*
tootle_request_await_finish (TootleRequest* self,
                             GAsyncResult* _res_,
                             GError** error)
{
	TootleRequest* result;
	TootleRequestAwaitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TootleRequest* self;
		self = _data4_->self;
		_g_free0 (_data4_->_error_);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda22_ (Block4Data* _data4_,
             gint32 code,
             const gchar* reason)
{
	TootleRequest* self;
	gchar* _tmp0_;
	self = _data4_->self;
	g_return_if_fail (reason != NULL);
	_tmp0_ = g_strdup (reason);
	_g_free0 (_data4_->_error_);
	_data4_->_error_ = _tmp0_;
	tootle_request_await_co (_data4_->_async_data_);
}

static void
___lambda22__tootle_network_error_callback (gint32 code,
                                            const gchar* reason,
                                            gpointer self)
{
	__lambda22_ (self, code, reason);
}

static void
__lambda23_ (Block4Data* _data4_,
             SoupSession* sess,
             SoupMessage* msg,
             GError** error)
{
	TootleRequest* self;
	self = _data4_->self;
	g_return_if_fail (sess != NULL);
	g_return_if_fail (msg != NULL);
	tootle_request_await_co (_data4_->_async_data_);
}

static void
___lambda23__tootle_network_success_callback (SoupSession* session,
                                              SoupMessage* msg,
                                              gpointer self,
                                              GError** error)
{
	__lambda23_ (self, session, msg, error);
}

static gboolean
tootle_request_await_co (TootleRequestAwaitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_data4_->_error_ = NULL;
	(_data_->self->priv->error_cb_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->error_cb_target_destroy_notify (_data_->self->priv->error_cb_target), NULL);
	_data_->self->priv->error_cb = NULL;
	_data_->self->priv->error_cb_target = NULL;
	_data_->self->priv->error_cb_target_destroy_notify = NULL;
	_data_->self->priv->error_cb = ___lambda22__tootle_network_error_callback;
	_data_->self->priv->error_cb_target = block4_data_ref (_data_->_data4_);
	_data_->self->priv->error_cb_target_destroy_notify = block4_data_unref;
	(_data_->self->priv->cb_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->cb_target_destroy_notify (_data_->self->priv->cb_target), NULL);
	_data_->self->priv->cb = NULL;
	_data_->self->priv->cb_target = NULL;
	_data_->self->priv->cb_target_destroy_notify = NULL;
	_data_->self->priv->cb = ___lambda23__tootle_network_success_callback;
	_data_->self->priv->cb_target = block4_data_ref (_data_->_data4_);
	_data_->self->priv->cb_target_destroy_notify = block4_data_unref;
	_data_->_tmp0_ = tootle_request_exec (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp2_ = _data_->_data4_->_error_;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->_data4_->_error_;
		_data_->_tmp4_ = g_error_new_literal (TOOTLE_OOPSIE, TOOTLE_OOPSIE_INSTANCE, _data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp5_ = _g_object_ref0 (_data_->self);
		_data_->result = _data_->_tmp5_;
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_free0 (_data5_->_result_);
		_g_object_unref0 (_data5_->array);
		_g_free0 (_data5_->key);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda24_ (Block5Data* _data5_,
             gchar* i)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (i != NULL, FALSE);
	_tmp0_ = string_to_string (_data5_->key);
	_tmp1_ = string_to_string (i);
	_tmp2_ = g_strconcat (_tmp0_, "[]=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_data5_->_result_, _tmp3_, NULL);
	_g_free0 (_data5_->_result_);
	_data5_->_result_ = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data5_->array);
	_tmp6_ = _tmp5_;
	if ((gee_abstract_list_index_of ((GeeAbstractList*) _data5_->array, i) + 1) != _tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strconcat (_data5_->_result_, "&", NULL);
		_g_free0 (_data5_->_result_);
		_data5_->_result_ = _tmp7_;
	}
	result = TRUE;
	_g_free0 (i);
	return result;
}

static gboolean
___lambda24__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda24_ (self, (gchar*) g);
	return result;
}

gchar*
tootle_request_array2string (GeeArrayList* array,
                             const gchar* key)
{
	Block5Data* _data5_;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (array != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (array);
	_g_object_unref0 (_data5_->array);
	_data5_->array = _tmp0_;
	_tmp1_ = g_strdup (key);
	_g_free0 (_data5_->key);
	_data5_->key = _tmp1_;
	_tmp2_ = g_strdup ("");
	_data5_->_result_ = _tmp2_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _data5_->array, ___lambda24__gee_forall_func, _data5_);
	_tmp3_ = g_strdup (_data5_->_result_);
	result = _tmp3_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

TootleRequest*
tootle_request_construct (GType object_type)
{
	TootleRequest * self = NULL;
	self = (TootleRequest*) g_object_new (object_type, NULL);
	return self;
}

TootleRequest*
tootle_request_new (void)
{
	return tootle_request_construct (TOOTLE_TYPE_REQUEST);
}

const gchar*
tootle_request_get_url (TootleRequest* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

void
tootle_request_set_url (TootleRequest* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tootle_request_get_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_url);
		self->priv->_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tootle_request_properties[TOOTLE_REQUEST_URL_PROPERTY]);
	}
}

static void
tootle_request_class_init (TootleRequestClass * klass,
                           gpointer klass_data)
{
	tootle_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TootleRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tootle_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tootle_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = tootle_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOOTLE_REQUEST_URL_PROPERTY, tootle_request_properties[TOOTLE_REQUEST_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tootle_request_instance_init (TootleRequest * self,
                              gpointer klass)
{
	self->priv = tootle_request_get_instance_private (self);
	self->priv->needs_token = FALSE;
	self->priv->has_ctx = FALSE;
}

static void
tootle_request_finalize (GObject * obj)
{
	TootleRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_REQUEST, TootleRequest);
	_g_free0 (self->priv->_url);
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	(self->priv->error_cb_target_destroy_notify == NULL) ? NULL : (self->priv->error_cb_target_destroy_notify (self->priv->error_cb_target), NULL);
	self->priv->error_cb = NULL;
	self->priv->error_cb_target = NULL;
	self->priv->error_cb_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->pars);
	G_OBJECT_CLASS (tootle_request_parent_class)->finalize (obj);
}

static GType
tootle_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TootleRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleRequest), 0, (GInstanceInitFunc) tootle_request_instance_init, NULL };
	GType tootle_request_type_id;
	tootle_request_type_id = g_type_register_static (soup_message_get_type (), "TootleRequest", &g_define_type_info, 0);
	TootleRequest_private_offset = g_type_add_instance_private (tootle_request_type_id, sizeof (TootleRequestPrivate));
	return tootle_request_type_id;
}

GType
tootle_request_get_type (void)
{
	static volatile gsize tootle_request_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_request_type_id__volatile)) {
		GType tootle_request_type_id;
		tootle_request_type_id = tootle_request_get_type_once ();
		g_once_init_leave (&tootle_request_type_id__volatile, tootle_request_type_id);
	}
	return tootle_request_type_id__volatile;
}

static void
_vala_tootle_request_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	TootleRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TOOTLE_TYPE_REQUEST, TootleRequest);
	switch (property_id) {
		case TOOTLE_REQUEST_URL_PROPERTY:
		g_value_set_string (value, tootle_request_get_url (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tootle_request_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	TootleRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TOOTLE_TYPE_REQUEST, TootleRequest);
	switch (property_id) {
		case TOOTLE_REQUEST_URL_PROPERTY:
		tootle_request_set_url (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

