/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class Builder {
    private static final Logger logger = LoggerFactory.getLogger(Builder.class);

    public static void build(Element element, Buildable buildable) {
        if (element == null) {
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            try {
                Buildable buildable2 = Builder.create((Element)node);
                if (buildable == null) continue;
                buildable2.addTo(buildable);
                buildable.add(buildable2);
                continue;
            }
            catch (IllegalBuildException illegalBuildException) {
                ErrorDialog.bug(illegalBuildException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                logger.error("Error building " + node.getNodeName());
                throw runtimeException;
            }
            catch (Error error) {
                logger.error("Error building " + node.getNodeName());
                throw error;
            }
        }
    }

    public static Buildable create(Element element) throws IllegalBuildException {
        GameModule gameModule = GameModule.getGameModule();
        String string = element.getTagName();
        try {
            Buildable buildable = (Buildable)(gameModule == null ? Class.forName(string) : gameModule.getDataArchive().loadClass(string)).getConstructor(new Class[0]).newInstance(new Object[0]);
            buildable.build(element);
            return buildable;
        }
        catch (Throwable throwable) {
            ThrowableUtils.throwRecent(OutOfMemoryError.class, throwable);
            if (throwable instanceof ClassCastException || throwable instanceof ClassNotFoundException || throwable instanceof IllegalAccessException || throwable instanceof IllegalArgumentException || throwable instanceof InstantiationException || throwable instanceof InvocationTargetException || throwable instanceof NoSuchMethodException || throwable instanceof SecurityException || throwable instanceof ExceptionInInitializerError || throwable instanceof LinkageError) {
                throw new IllegalBuildException("failed to load class " + string, throwable);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(throwable);
        }
    }

    public static Document createDocument(InputStream inputStream) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            inputStream.close();
            Document document2 = document;
            return document2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorDialog.bug(parserConfigurationException);
            Document document = null;
            return document;
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException().initCause(sAXException);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static Document createNewDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ErrorDialog.bug(parserConfigurationException);
            return null;
        }
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(writer);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw (IOException)new IOException().initCause(transformerException);
        }
    }

    public static String getText(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3) {
                stringBuilder.append(((Text)nodeList.item(i)).getData());
                continue;
            }
            if (nodeList.item(i).getNodeType() != 5) continue;
            stringBuilder.append(nodeList.item(i).getFirstChild().toString());
        }
        return stringBuilder.toString().trim();
    }

    public static String toString(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            Builder.writeDocument(document, stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static void main(String[] stringArray) {
        Document document = Builder.createNewDocument();
        Element element = document.createElement("test");
        Element element2 = document.createElement("sub1");
        element.appendChild(element2);
        Element element3 = document.createElement("sub2");
        element3.setAttribute("one", "1");
        element3.setAttribute("two", "2");
        element.appendChild(element3);
        Element element4 = document.createElement("sub3");
        Element element5 = document.createElement("sub4");
        element5.appendChild(document.createTextNode("4 > 2"));
        element4.appendChild(element5);
        element.appendChild(element4);
        document.appendChild(element);
        System.err.println(Builder.toString(document));
        System.err.println("StringBuilder");
        StringBuilder stringBuilder = new StringBuilder(300000);
        for (int i = 0; i < 500000; ++i) {
            stringBuilder.append("  ");
            if (i % 10000 != 0) continue;
            System.err.println(stringBuilder.length());
        }
    }
}

