/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.GpIdSupport;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PlaceMarker;
import java.util.ArrayList;
import java.util.HashMap;

public class GpIdChecker {
    protected GpIdSupport gpIdSupport;
    protected int maxId;
    protected boolean useName = false;
    protected boolean extensionsLoaded = false;
    final HashMap<String, SlotElement> goodSlots = new HashMap();
    final ArrayList<SlotElement> errorSlots = new ArrayList();

    public GpIdChecker() {
        this(null);
    }

    public GpIdChecker(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.maxId = -1;
    }

    public GpIdChecker(boolean bl) {
        this();
        this.useName = bl;
        this.extensionsLoaded = true;
    }

    public void add(PieceSlot pieceSlot) {
        this.testGpId(pieceSlot.getGpId(), new SlotElement(pieceSlot));
        GamePiece gamePiece = pieceSlot.getPiece();
        this.checkTrait(gamePiece, pieceSlot);
    }

    protected void checkTrait(GamePiece gamePiece, PieceSlot pieceSlot) {
        if (gamePiece == null || gamePiece instanceof BasicPiece) {
            return;
        }
        if (gamePiece instanceof PlaceMarker) {
            PlaceMarker placeMarker = (PlaceMarker)gamePiece;
            this.testGpId(placeMarker.getGpId(), new SlotElement(placeMarker, pieceSlot));
        }
        this.checkTrait(((Decorator)gamePiece).getInner(), pieceSlot);
    }

    protected void testGpId(String string, SlotElement slotElement) {
        if (!this.extensionsLoaded && string.contains(":")) {
            string = string.split(":")[1];
        }
        if (string == null || string.length() == 0) {
            this.errorSlots.add(slotElement);
        } else {
            if (this.goodSlots.get(string) != null) {
                this.errorSlots.add(slotElement);
            }
            try {
                if (this.extensionsLoaded) {
                    this.goodSlots.put(string, slotElement);
                    System.out.println("Add Id " + string);
                } else {
                    int n = Integer.parseInt(string);
                    this.goodSlots.put(string, slotElement);
                    if (n >= this.maxId) {
                        this.maxId = n + 1;
                    }
                }
            }
            catch (Exception exception) {
                this.errorSlots.add(slotElement);
            }
        }
    }

    public boolean hasErrors() {
        return this.errorSlots.size() > 0;
    }

    public void fixErrors() {
        if (this.maxId >= this.gpIdSupport.getNextGpId()) {
            this.gpIdSupport.setNextGpId(this.maxId + 1);
        }
        for (SlotElement slotElement : this.errorSlots) {
            slotElement.updateGpId();
        }
    }

    public GamePiece createUpdatedPiece(GamePiece gamePiece) {
        Object object;
        String string = (String)gamePiece.getProperty("PieceId");
        if (string != null && string.length() > 0 && (object = this.goodSlots.get(string)) != null) {
            return ((SlotElement)object).createPiece(gamePiece);
        }
        if (this.useName) {
            object = Decorator.getInnermost(gamePiece).getName();
            for (SlotElement slotElement : this.goodSlots.values()) {
                GamePiece gamePiece2 = slotElement.getPiece();
                String string2 = Decorator.getInnermost(gamePiece2).getName();
                if (!((String)object).equals(string2)) continue;
                return slotElement.createPiece(gamePiece);
            }
        }
        return gamePiece;
    }

    public boolean findUpdatedPiece(GamePiece gamePiece) {
        Object object;
        String string = (String)gamePiece.getProperty("PieceId");
        if (string != null && string.length() > 0 && (object = this.goodSlots.get(string)) != null) {
            return true;
        }
        if (this.useName) {
            object = Decorator.getInnermost(gamePiece).getName();
            for (SlotElement slotElement : this.goodSlots.values()) {
                GamePiece gamePiece2 = slotElement.getPiece();
                String string2 = Decorator.getInnermost(gamePiece2).getName();
                if (!((String)object).equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SlotElement {
        private PieceSlot slot = null;
        private PlaceMarker marker = null;
        private String id;

        public SlotElement() {
        }

        public SlotElement(PieceSlot pieceSlot) {
            this();
            this.slot = pieceSlot;
            this.id = pieceSlot.getGpId();
        }

        public SlotElement(PlaceMarker placeMarker, PieceSlot pieceSlot) {
            this();
            this.marker = placeMarker;
            this.slot = pieceSlot;
            this.id = placeMarker.getGpId();
        }

        public String getGpId() {
            return this.id;
        }

        public void updateGpId() {
            if (this.marker == null) {
                this.slot.updateGpId();
            } else {
                this.marker.updateGpId();
            }
        }

        public GamePiece getPiece() {
            if (this.slot == null) {
                return this.marker;
            }
            return this.slot.getPiece();
        }

        public GamePiece createPiece(GamePiece gamePiece) {
            GamePiece gamePiece2 = this.slot != null ? this.slot.getPiece() : this.marker.createMarker();
            gamePiece2 = PieceCloner.getInstance().clonePiece(gamePiece2);
            this.copyState(gamePiece, gamePiece2);
            gamePiece2.setProperty("PieceId", this.getGpId());
            return gamePiece2;
        }

        protected void copyState(GamePiece gamePiece, GamePiece gamePiece2) {
            GamePiece gamePiece3 = gamePiece2;
            while (gamePiece3 != null) {
                if (gamePiece3 instanceof BasicPiece) {
                    ((BasicPiece)gamePiece3).setState(((BasicPiece)Decorator.getInnermost(gamePiece)).getState());
                    gamePiece3 = null;
                    continue;
                }
                Decorator decorator = (Decorator)gamePiece3;
                String string = decorator.myGetType();
                String string2 = this.findStateFromType(gamePiece, string, gamePiece3.getClass());
                if (string2 != null && string2.length() > 0) {
                    decorator.mySetState(string2);
                }
                gamePiece3 = decorator.getInner();
            }
        }

        protected String findStateFromType(GamePiece gamePiece, String string, Class<? extends GamePiece> clazz) {
            GamePiece gamePiece2 = gamePiece;
            while (gamePiece2 != null && !(gamePiece2 instanceof BasicPiece)) {
                Decorator decorator = (Decorator)Decorator.getDecorator(gamePiece2, clazz);
                if (decorator != null) {
                    if (decorator.getClass().equals(clazz) && decorator.myGetType().equals(string)) {
                        return decorator.myGetState();
                    }
                    gamePiece2 = decorator.getInner();
                    continue;
                }
                gamePiece2 = null;
            }
            return null;
        }
    }
}

