/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.ServerAddressBook;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.io.IOUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class AddressBookServerConfigurer
extends Configurer {
    private static final String CONNECTED = Resources.getString("Server.please_disconnect");
    private static final String DISCONNECTED = Resources.getString("ServerAddressBook.select_server");
    private static final String ENCODING = "UTF-8";
    protected JComponent controls;
    protected ServerAddressBook addressBook;
    private HybridClient client;
    private JLabel header;

    public AddressBookServerConfigurer(String string, String string2, HybridClient hybridClient) {
        super(string, string2, hybridClient);
        this.client = hybridClient;
        hybridClient.addPropertyChangeListener("Connected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AddressBookServerConfigurer.this.enableControls(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
            }
        });
        this.getControls();
        this.setValue(this.addressBook.getDefaultServerProperties());
        hybridClient.updateDisplayControls(this.addressBook.getCurrentIcon(), this.addressBook.getCurrentDescription());
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel(new MigLayout());
            this.header = new JLabel(DISCONNECTED);
            this.controls.add((Component)this.header, "wrap");
            this.addressBook = new ServerAddressBook();
            this.addressBook.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("currentServer".equals(propertyChangeEvent.getPropertyName())) {
                        AddressBookServerConfigurer.this.addressBook.setFrozen(true);
                        AddressBookServerConfigurer.this.setValue((Properties)propertyChangeEvent.getNewValue());
                        AddressBookServerConfigurer.this.addressBook.setFrozen(false);
                    }
                }
            });
            this.controls.add(this.addressBook.getControls());
        }
        return this.controls;
    }

    private void enableControls(boolean bl) {
        this.addressBook.setEnabled(!bl);
        this.header.setText(bl ? CONNECTED : DISCONNECTED);
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (!this.noUpdate && object instanceof Properties && this.controls != null) {
            this.addressBook.setCurrentServer((Properties)object);
        }
        if (this.client != null && !CONNECTED.equals(this.header.getText())) {
            this.client.setDelegate(ChatServerFactory.build(this.getServerInfo()));
            this.client.updateDisplayControls(this.addressBook.getCurrentIcon(), this.addressBook.getCurrentDescription());
        }
    }

    private Properties getServerInfo() {
        Properties properties = (Properties)this.getValue();
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueString() {
        String string = "";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Properties properties = (Properties)this.getValue();
            if (properties != null) {
                properties.store(byteArrayOutputStream, null);
            }
            string = new String(byteArrayOutputStream.toByteArray(), ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        }
        return string;
    }

    public void setValue(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(string.getBytes(ENCODING)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setValue(properties);
    }
}

