/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.math.LongRange;
import org.apache.commons.lang.math.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgiServerStatus
implements ServerStatus {
    private static final long DAY = 86400000L;
    public static final String LAST_DAY = "Server.last_24_hours";
    public static final String LAST_WEEK = "Server.last_week";
    public static final String LAST_MONTH = "Server.last_month";
    private static final Map<String, Long> timeRanges = new HashMap<String, Long>();
    private static final String[] times = new String[]{Resources.getString("Server.last_24_hours"), Resources.getString("Server.last_week"), Resources.getString("Server.last_month")};
    private HttpRequestWrapper request;
    private SortedMap<Long, List<String[]>> records = new TreeMap<Long, List<String[]>>();
    private List<LongRange> requests = new ArrayList<LongRange>();

    public CgiServerStatus() {
        this.request = new HttpRequestWrapper("http://www.vassalengine.org/util/");
        timeRanges.put(Resources.getString(LAST_DAY), 86400000L);
        timeRanges.put(Resources.getString(LAST_WEEK), 604800000L);
        timeRanges.put(Resources.getString(LAST_MONTH), 2592000000L);
    }

    @Override
    public ServerStatus.ModuleSummary[] getStatus() {
        HashMap<String, ServerStatus.ModuleSummary> hashMap = new HashMap<String, ServerStatus.ModuleSummary>();
        try {
            for (String string : this.request.doGet("getCurrentConnections", new Properties())) {
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
                try {
                    String string2 = decoder.nextToken();
                    String string3 = decoder.nextToken();
                    String string4 = decoder.nextToken();
                    ServerStatus.ModuleSummary moduleSummary = hashMap.get(string2);
                    if (moduleSummary == null) {
                        hashMap.put(string2, this.createEntry(string2, string3, string4));
                        continue;
                    }
                    this.updateEntry(moduleSummary, string3, string4);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.sortEntriesByModuleName(hashMap);
    }

    @Override
    public ServerStatus.ModuleSummary[] getHistory(String string) {
        Long l = timeRanges.get(string);
        return l != null ? this.getHistory(l) : new ServerStatus.ModuleSummary[]{};
    }

    @Override
    public String[] getSupportedTimeRanges() {
        return times;
    }

    /*
     * WARNING - void declaration
     */
    private ServerStatus.ModuleSummary[] getHistory(long l) {
        String string;
        String string2;
        long l2;
        long l3;
        long l4;
        long l5;
        if (l <= 0L) {
            return this.getStatus();
        }
        long l6 = System.currentTimeMillis();
        LongRange longRange = new LongRange(l6 - l, l6);
        ArrayList<LongRange> arrayList = new ArrayList<LongRange>();
        arrayList.add(longRange);
        for (LongRange object2 : this.requests) {
            ListIterator<LongRange> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                LongRange longRange2 = (LongRange)listIterator.next();
                if (!longRange2.overlapsRange((Range)object2)) continue;
                listIterator.remove();
                l5 = longRange2.getMinimumLong();
                l4 = longRange2.getMaximumLong();
                l3 = object2.getMinimumLong();
                l2 = object2.getMaximumLong();
                if (l5 < l3 && l3 <= l4) {
                    listIterator.add(new LongRange(l5, l3));
                }
                if (l5 > l2 || l2 >= l4) continue;
                listIterator.add(new LongRange(l2, l4));
            }
        }
        for (LongRange longRange3 : arrayList) {
            for (String string3 : this.getInterval(longRange3)) {
                SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string3, '\t');
                try {
                    string2 = decoder.nextToken();
                    String string4 = decoder.nextToken();
                    string = decoder.nextToken();
                    Long l7 = Long.valueOf(decoder.nextToken());
                    ArrayList<String[]> arrayList2 = (ArrayList<String[]>)this.records.get(l7);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String[]>();
                        this.records.put(l7, arrayList2);
                    }
                    arrayList2.add(new String[]{string2, string4, string});
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            this.requests.add(longRange3);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            void var9_18;
            LongRange longRange4 = this.requests.get(i);
            int n = i + 1;
            while (var9_18 < this.requests.size()) {
                LongRange longRange5 = this.requests.get((int)var9_18);
                if (longRange4.overlapsRange((Range)longRange5)) {
                    l5 = longRange4.getMinimumLong();
                    l4 = longRange4.getMaximumLong();
                    l3 = longRange5.getMinimumLong();
                    l2 = longRange5.getMaximumLong();
                    this.requests.set(i, new LongRange(Math.min(l5, l3), Math.max(l4, l2)));
                    this.requests.remove((int)var9_18--);
                }
                ++var9_18;
            }
        }
        HashMap<String, ServerStatus.ModuleSummary> hashMap = new HashMap<String, ServerStatus.ModuleSummary>();
        for (List<String[]> list : this.records.subMap(longRange.getMinimumLong(), longRange.getMaximumLong()).values()) {
            for (String[] stringArray : list) {
                string2 = stringArray[0];
                String string5 = stringArray[1];
                string = stringArray[2];
                ServerStatus.ModuleSummary moduleSummary = hashMap.get(string2);
                if (moduleSummary == null) {
                    hashMap.put(string2, this.createEntry(string2, string5, string));
                    continue;
                }
                this.updateEntry(moduleSummary, string5, string);
            }
        }
        return this.sortEntriesByModuleName(hashMap);
    }

    private ServerStatus.ModuleSummary[] sortEntriesByModuleName(Map<String, ServerStatus.ModuleSummary> map) {
        ServerStatus.ModuleSummary[] moduleSummaryArray = map.values().toArray(new ServerStatus.ModuleSummary[map.size()]);
        Arrays.sort(moduleSummaryArray, new Comparator<ServerStatus.ModuleSummary>(){

            @Override
            public int compare(ServerStatus.ModuleSummary moduleSummary, ServerStatus.ModuleSummary moduleSummary2) {
                return moduleSummary.getModuleName().compareTo(moduleSummary2.getModuleName());
            }
        });
        return moduleSummaryArray;
    }

    private List<String> getInterval(LongRange longRange) {
        Properties properties = new Properties();
        properties.setProperty("start", Long.toString(longRange.getMinimumLong()));
        properties.setProperty("end", Long.toString(longRange.getMaximumLong()));
        try {
            return this.request.doGet("getConnectionHistory", properties);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private ServerStatus.ModuleSummary updateEntry(ServerStatus.ModuleSummary moduleSummary, String string, String string2) {
        SimpleRoom simpleRoom = moduleSummary.getRoom(string);
        if (simpleRoom == null) {
            simpleRoom = new SimpleRoom(string);
            simpleRoom.setPlayers(new Player[]{new SimplePlayer(string2)});
            moduleSummary.addRoom(simpleRoom);
        } else {
            simpleRoom.addPlayer(new SimplePlayer(string2));
        }
        return moduleSummary;
    }

    private ServerStatus.ModuleSummary createEntry(String string, String string2, String string3) {
        SimpleRoom simpleRoom = new SimpleRoom(string2);
        simpleRoom.setPlayers(new Player[]{new SimplePlayer(string3)});
        return new ServerStatus.ModuleSummary(string, new Room[]{simpleRoom});
    }
}

