/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PrivMsgCommand;
import VASSAL.chat.PrivateChatManager;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.tools.SequenceEncoder;

public class PrivateChatEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "PRIV_CHAT";
    private PlayerEncoder playerEncoder;
    private PrivateChatManager pChatMgr;

    public PrivateChatEncoder(PlayerEncoder playerEncoder, PrivateChatManager privateChatManager) {
        this.playerEncoder = playerEncoder;
        this.pChatMgr = privateChatManager;
    }

    public String encode(Command command) {
        if (command instanceof PrivMsgCommand) {
            PrivMsgCommand privMsgCommand = (PrivMsgCommand)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder(COMMAND_PREFIX, '/');
            sequenceEncoder.append(this.playerEncoder.playerToString(privMsgCommand.getSender()));
            sequenceEncoder.append(privMsgCommand.getMessage());
            return sequenceEncoder.getValue();
        }
        return null;
    }

    public Command decode(String string) {
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
            decoder.nextToken();
            Player player = this.playerEncoder.stringToPlayer(decoder.nextToken());
            return new PrivMsgCommand(this.pChatMgr, player, decoder.nextToken());
        }
        return null;
    }
}

