/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.NullExpression;
import VASSAL.tools.ErrorDialog;

public class PropertyExpression
implements PieceFilter {
    protected Expression expression = new NullExpression();

    public PropertyExpression() {
    }

    public PropertyExpression(String string) {
        this.setExpression(string);
    }

    public void setExpression(String string) {
        this.expression = Expression.createPropertyExpression(string);
    }

    public String getExpression() {
        return this.expression.getExpression();
    }

    public boolean isNull() {
        return this.expression == null || this.expression instanceof NullExpression;
    }

    public PieceFilter getFilter(PropertySource propertySource) {
        return this.expression.getFilter(propertySource);
    }

    public PieceFilter getFilter() {
        return this.expression.getFilter();
    }

    public boolean accept(GamePiece gamePiece) {
        return this.accept(gamePiece, gamePiece);
    }

    public boolean accept(GamePiece gamePiece, GamePiece gamePiece2) {
        return this.getFilter(gamePiece).accept(gamePiece2);
    }

    public boolean equals(Object object) {
        if (object instanceof PropertyExpression) {
            return this.getExpression().equals(((PropertyExpression)object).getExpression());
        }
        return false;
    }

    public boolean isTrue(PropertySource propertySource) {
        String string = null;
        try {
            string = this.expression.evaluate(propertySource);
        }
        catch (ExpressionException expressionException) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.expression_error"), "Expression=" + this.getExpression() + ", Error=" + expressionException.getError(), expressionException));
        }
        return "true".equals(string);
    }
}

