/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class ColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static Font FONT = new Font("Dialog", 0, 10);
    private Color color;

    public ColorButton() {
        this((Color)null);
    }

    public ColorButton(Color color) {
        this.color = color;
        this.setIcon(new SwatchIcon(30, 15));
        this.setMargin(new Insets(2, 2, 2, 2));
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private class SwatchIcon
    implements Icon {
        private final int swatchWidth;
        private final int swatchHeight;

        public SwatchIcon(int n, int n2) {
            this.swatchWidth = n;
            this.swatchHeight = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, this.swatchWidth - 1, this.swatchHeight - 1);
            if (ColorButton.this.color != null) {
                graphics.setColor(ColorButton.this.color);
                graphics.fillRect(n + 1, n2 + 1, this.swatchWidth - 2, this.swatchHeight - 2);
            } else {
                graphics.setColor(UIManager.getColor("controlText"));
                graphics.setFont(FONT);
                graphics.drawString("nil", n + (this.swatchWidth - graphics.getFontMetrics(FONT).stringWidth("nil")) / 2, n2 + (this.swatchHeight + graphics.getFontMetrics(FONT).getAscent()) / 2);
            }
        }

        public int getIconWidth() {
            return this.swatchWidth;
        }

        public int getIconHeight() {
            return this.swatchHeight;
        }
    }
}

