/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class IconButton
extends JButton {
    private static final long serialVersionUID = 1L;
    public static final int PLUS_ICON = 0;
    public static final int MINUS_ICON = 1;
    public static final int TICK_ICON = 2;
    public static final int CROSS_ICON = 3;

    public IconButton(int n) {
        this(n, 22);
    }

    public IconButton(int n, int n2) {
        this(n, n2, IconButton.getDefaultColor(n), 2.0f);
    }

    public static Color getDefaultColor(int n) {
        switch (n) {
            case 2: {
                return Color.green;
            }
            case 3: {
                return Color.red;
            }
        }
        return Color.black;
    }

    public IconButton(int n, int n2, Color color, float f) {
        this.setMinimumSize(new Dimension(n2, n2));
        this.setPreferredSize(new Dimension(n2, n2));
        BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(n2, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setStroke(new BasicStroke(f));
        graphics2D.setColor(color);
        switch (n) {
            case 0: {
                graphics2D.drawLine(5, n2 / 2, n2 - 5, n2 / 2);
                graphics2D.drawLine(n2 / 2, 5, n2 / 2, n2 - 5);
                break;
            }
            case 1: {
                graphics2D.drawLine(5, n2 / 2, n2 - 5, n2 / 2);
                break;
            }
            case 2: {
                graphics2D.drawLine(5, n2 / 2, n2 / 2, n2 - 5);
                graphics2D.drawLine(n2 / 2, n2 - 5, 5, n2 - 5);
                break;
            }
            case 3: {
                graphics2D.drawLine(5, 5, n2 - 5, n2 - 5);
                graphics2D.drawLine(5, n2 - 5, n2 - 5, 5);
            }
        }
        this.setIcon(new ImageIcon(bufferedImage));
    }
}

