/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.tools.concurrent.RangedRunnable;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.EDT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Progressor
extends RangedRunnable<Integer> {
    protected final int max;

    public Progressor(int n, int n2) {
        super(n);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.max = n2;
    }

    public synchronized void set(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("prog == " + n);
        }
        if (n > this.max) {
            throw new IllegalArgumentException("prog == " + n);
        }
        int n2 = this.get();
        if (n == n2) {
            return;
        }
        if (n < n2) {
            throw new IllegalArgumentException("prog == " + n + ", get() == " + this.get());
        }
        this.setLast(n, 100 * n / this.max > 100 * (Integer)this.range.first / this.max);
    }

    public synchronized int get() {
        return this.range.second != null ? (Integer)this.range.second : (Integer)this.range.first;
    }

    public synchronized void increment() {
        this.add(1);
    }

    public synchronized void add(int n) {
        if (n != 0) {
            this.set(this.get() + n);
        }
    }

    public void setPct(int n) {
        this.set(n * this.max / 100);
    }

    public int getPct() {
        return 100 * this.get() / this.max;
    }

    @Override
    protected abstract void run(Pair<Integer, Integer> var1);

    @Override
    protected void submit() {
        EDT.execute(this);
    }
}

