/*
 * Decompiled with CFR 0.152.
 */
package VASSAL;

import VASSAL.tools.version.VassalVersionTokenizer;
import VASSAL.tools.version.VersionFormatException;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import org.apache.commons.lang.SystemUtils;

public final class Info {
    private static final String VERSION = "3.2.17";
    private static final String EXPIRY_VERSION = "3.3";
    private static final String UPDATE_VERSION = "3.2";
    private static final File homeDir;
    private static final File tmpDir;
    public static final String javaBinPath;
    private static final int instanceID;

    private Info() {
    }

    public static String getVersion() {
        return VERSION;
    }

    @Deprecated
    public static String getMinorVersion() {
        VassalVersionTokenizer vassalVersionTokenizer = new VassalVersionTokenizer(VERSION);
        try {
            return Integer.toString(vassalVersionTokenizer.next()) + "." + Integer.toString(vassalVersionTokenizer.next());
        }
        catch (VersionFormatException versionFormatException) {
            return null;
        }
    }

    public static int getInstanceID() {
        return instanceID;
    }

    public static Rectangle getScreenBounds(Component component) {
        Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.translate(insets.left, insets.top);
        rectangle.setSize(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        return rectangle;
    }

    @Deprecated
    public static boolean isMacOSX() {
        return SystemUtils.IS_OS_MAC_OSX;
    }

    @Deprecated
    public static boolean isMacOsX() {
        return SystemUtils.IS_OS_MAC_OSX;
    }

    @Deprecated
    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isModuleTooNew(String string) {
        return Info.compareVersions(string, EXPIRY_VERSION) >= 0;
    }

    public static boolean hasOldFormat(String string) {
        return Info.compareVersions(string, UPDATE_VERSION) < 0;
    }

    public static int compareVersions(String string, String string2) {
        VassalVersionTokenizer vassalVersionTokenizer = new VassalVersionTokenizer(string);
        VassalVersionTokenizer vassalVersionTokenizer2 = new VassalVersionTokenizer(string2);
        try {
            while (vassalVersionTokenizer.hasNext() && vassalVersionTokenizer2.hasNext()) {
                int n;
                int n2 = vassalVersionTokenizer.next();
                if (n2 == (n = vassalVersionTokenizer2.next())) continue;
                return n2 - n;
            }
        }
        catch (VersionFormatException versionFormatException) {
            return 0;
        }
        return vassalVersionTokenizer.hasNext() ? 1 : (vassalVersionTokenizer2.hasNext() ? -1 : 0);
    }

    public static File getBaseDir() {
        return new File(System.getProperty("user.dir"));
    }

    @Deprecated
    public static File getDocsDir() {
        return Info.getDocDir();
    }

    public static File getBinDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getDocDir() {
        String string = SystemUtils.IS_OS_MAC_OSX ? "Contents/Resources/doc" : "doc";
        return new File(Info.getBaseDir(), string);
    }

    public static File getConfDir() {
        return Info.getHomeDir();
    }

    public static File getTempDir() {
        return tmpDir;
    }

    public static File getPrefsDir() {
        return new File(Info.getConfDir(), "prefs");
    }

    public static File getHomeDir() {
        return homeDir;
    }

    @Deprecated
    public static boolean isDndEnabled() {
        return true;
    }

    @Deprecated
    public static boolean is2dEnabled() {
        return true;
    }

    static {
        Object object = SystemUtils.IS_OS_MAC_OSX ? new File(System.getProperty("user.home"), "Library/Application Support/VASSAL") : (SystemUtils.IS_OS_WINDOWS ? new File(System.getenv("APPDATA") + "/VASSAL") : new File(System.getProperty("user.home"), ".VASSAL"));
        homeDir = object;
        tmpDir = new File(homeDir, "tmp");
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        javaBinPath = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        object = System.getProperty("VASSAL.id");
        if (object == null) {
            instanceID = 0;
        } else {
            int n;
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            instanceID = n;
        }
    }
}

