/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.DefaultPieceCollection;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.ForwardToChatter;
import VASSAL.build.module.map.ForwardToKeyBuffer;
import VASSAL.build.module.map.GlobalMap;
import VASSAL.build.module.map.HidePiecesButton;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.build.module.map.ImageSaver;
import VASSAL.build.module.map.KeyBufferer;
import VASSAL.build.module.map.LOS_Thread;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.module.map.MapCenterer;
import VASSAL.build.module.map.MapShader;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceCollection;
import VASSAL.build.module.map.PieceMover;
import VASSAL.build.module.map.PieceRecenterer;
import VASSAL.build.module.map.Scroller;
import VASSAL.build.module.map.SelectionHighlighters;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.StackExpander;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.map.TextSaver;
import VASSAL.build.module.map.Zoomer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.widget.MapWidget;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.MandatoryComponent;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.WrapLayout;
import VASSAL.tools.menu.MenuManager;
import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map
extends AbstractConfigurable
implements GameComponent,
MouseListener,
MouseMotionListener,
DropTargetListener,
Configurable,
UniqueIdManager.Identifyable,
ToolBarComponent,
MutablePropertiesContainer,
PropertySource,
PlayerRoster.SideChangeListener {
    protected static boolean changeReportingEnabled = true;
    protected String mapID = "";
    protected String mapName = "";
    protected static final String MAIN_WINDOW_HEIGHT = "mainWindowHeight";
    protected static UniqueIdManager idMgr = new UniqueIdManager("Map");
    protected JPanel theMap;
    protected ArrayList<Drawable> drawComponents = new ArrayList();
    protected JLayeredPane layeredPane = new JLayeredPane();
    protected JScrollPane scroll;
    protected ComponentSplitter.SplitPane mainWindowDock;
    protected BoardPicker picker;
    protected JToolBar toolBar = new JToolBar();
    protected Zoomer zoom;
    protected StackMetrics metrics;
    protected Dimension edgeBuffer = new Dimension(0, 0);
    protected Color bgColor = Color.white;
    protected LaunchButton launchButton;
    protected boolean useLaunchButton = false;
    protected boolean useLaunchButtonEdit = false;
    protected String markMovedOption = "Always";
    protected String markUnmovedIcon = "/images/unmoved.gif";
    protected String markUnmovedText = "";
    protected String markUnmovedTooltip = Resources.getString("Map.mark_unmoved");
    protected MouseListener multicaster = null;
    protected ArrayList<MouseListener> mouseListenerStack = new ArrayList();
    protected List<Board> boards = new CopyOnWriteArrayList<Board>();
    protected int[][] boardWidths;
    protected int[][] boardHeights;
    protected PieceCollection pieces = new DefaultPieceCollection();
    protected Highlighter highlighter = new ColoredBorder();
    protected ArrayList<Highlighter> highlighters = new ArrayList();
    protected boolean clearFirst = false;
    protected boolean hideCounters = false;
    protected float pieceOpacity = 1.0f;
    protected boolean allowMultiple = false;
    protected VisibilityCondition visibilityCondition;
    protected DragGestureListener dragGestureListener;
    protected String moveWithinFormat;
    protected String moveToFormat;
    protected String createFormat;
    protected String changeFormat = "$message$";
    protected NamedKeyStroke moveKey;
    protected PropertyChangeListener globalPropertyListener;
    protected String tooltip = "";
    protected MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    protected PropertyChangeListener repaintOnPropertyChange = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Map.this.repaint();
        }
    };
    protected PieceMover pieceMover;
    protected KeyListener[] saveKeyListeners = null;
    public static final String NAME = "mapName";
    public static final String MARK_MOVED = "markMoved";
    public static final String MARK_UNMOVED_ICON = "markUnmovedIcon";
    public static final String MARK_UNMOVED_TEXT = "markUnmovedText";
    public static final String MARK_UNMOVED_TOOLTIP = "markUnmovedTooltip";
    public static final String EDGE_WIDTH = "edgeWidth";
    public static final String EDGE_HEIGHT = "edgeHeight";
    public static final String BACKGROUND_COLOR = "backgroundcolor";
    public static final String HIGHLIGHT_COLOR = "color";
    public static final String HIGHLIGHT_THICKNESS = "thickness";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String USE_LAUNCH_BUTTON = "launch";
    public static final String BUTTON_NAME = "buttonName";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String SUPPRESS_AUTO = "suppressAuto";
    public static final String MOVE_WITHIN_FORMAT = "moveWithinFormat";
    public static final String MOVE_TO_FORMAT = "moveToFormat";
    public static final String CREATE_FORMAT = "createFormat";
    public static final String CHANGE_FORMAT = "changeFormat";
    public static final String MOVE_KEY = "moveKey";
    public static final String MOVING_STACKS_PICKUP_UNITS = "movingStacksPickupUnits";
    public static Map activeMap = null;
    public static final int PREFERRED_EDGE_SCROLL_DELAY = 200;
    public static final String PREFERRED_EDGE_DELAY = "PreferredEdgeDelay";
    public static final int SCROLL_ZONE = 30;
    protected int sx;
    protected int sy;
    protected int dx;
    protected int dy;
    protected Animator scroller = new Animator(-1, (TimingTarget)new TimingTargetAdapter(){
        private long t0;

        public void timingEvent(float f) {
            long l = System.currentTimeMillis();
            int n = (int)((l - this.t0) / 2L);
            this.t0 = l;
            Map.this.scroll(Map.this.sx * n, Map.this.sy * n);
            Rectangle rectangle = Map.this.scroll.getViewport().getViewRect();
            if (Map.this.sx == -1 && rectangle.x == 0 || Map.this.sx == 1 && rectangle.x + rectangle.width >= Map.this.theMap.getWidth()) {
                Map.this.sx = 0;
            }
            if (Map.this.sy == -1 && rectangle.y == 0 || Map.this.sy == 1 && rectangle.y + rectangle.height >= Map.this.theMap.getHeight()) {
                Map.this.sy = 0;
            }
            if (Map.this.sx == 0 && Map.this.sy == 0) {
                Map.this.scroller.stop();
            }
        }

        public void begin() {
            this.t0 = System.currentTimeMillis();
        }
    });
    public static final String LOCATION = "location";
    public static final String OLD_LOCATION = "previousLocation";
    public static final String OLD_MAP = "previousMap";
    public static final String MAP_NAME = "mapName";
    public static final String PIECE_NAME = "pieceName";
    public static final String MESSAGE = "message";

    public Map() {
        this.getView();
        this.theMap.addMouseListener(this);
        if (this.shouldDockIntoMainWindow()) {
            this.toolBar.setLayout(new MigLayout("ins 0,gapx 0,hidemode 3"));
        } else {
            this.toolBar.setLayout(new WrapLayout(0, 0, 0));
        }
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setFloatable(false);
    }

    public static void setChangeReportingEnabled(boolean bl) {
        changeReportingEnabled = bl;
    }

    public static boolean isChangeReportingEnabled() {
        return changeReportingEnabled;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("mapName".equals(string)) {
            this.setMapName((String)object);
        } else if (MARK_MOVED.equals(string)) {
            this.markMovedOption = (String)object;
        } else if (MARK_UNMOVED_ICON.equals(string)) {
            this.markUnmovedIcon = (String)object;
            if (this.pieceMover != null) {
                this.pieceMover.setAttribute(string, object);
            }
        } else if (MARK_UNMOVED_TEXT.equals(string)) {
            this.markUnmovedText = (String)object;
            if (this.pieceMover != null) {
                this.pieceMover.setAttribute(string, object);
            }
        } else if (MARK_UNMOVED_TOOLTIP.equals(string)) {
            this.markUnmovedTooltip = (String)object;
        } else if ("edge".equals(string)) {
            String string2 = (String)object;
            int n = string2.indexOf(44);
            if (n > 0) {
                this.edgeBuffer = new Dimension(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
            }
        } else if (EDGE_WIDTH.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            try {
                this.edgeBuffer = new Dimension((Integer)object, this.edgeBuffer.height);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalBuildException(numberFormatException);
            }
        } else if (EDGE_HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            try {
                this.edgeBuffer = new Dimension(this.edgeBuffer.width, (Integer)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalBuildException(numberFormatException);
            }
        } else if (BACKGROUND_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.bgColor = (Color)object;
        } else if (ALLOW_MULTIPLE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.allowMultiple = (Boolean)object;
            if (this.picker != null) {
                this.picker.setAllowMultiple(this.allowMultiple);
            }
        } else if (HIGHLIGHT_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            if (object != null) {
                ((ColoredBorder)this.highlighter).setColor((Color)object);
            }
        } else if (HIGHLIGHT_THICKNESS.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            if (this.highlighter instanceof ColoredBorder) {
                ((ColoredBorder)this.highlighter).setThickness((Integer)object);
            }
        } else if (USE_LAUNCH_BUTTON.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.useLaunchButtonEdit = (Boolean)object;
            this.launchButton.setVisible(this.useLaunchButton);
        } else if (SUPPRESS_AUTO.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            if (Boolean.TRUE.equals(object)) {
                this.moveWithinFormat = "";
            }
        } else if (MOVE_WITHIN_FORMAT.equals(string)) {
            this.moveWithinFormat = (String)object;
        } else if (MOVE_TO_FORMAT.equals(string)) {
            this.moveToFormat = (String)object;
        } else if (CREATE_FORMAT.equals(string)) {
            this.createFormat = (String)object;
        } else if (CHANGE_FORMAT.equals(string)) {
            this.changeFormat = (String)object;
        } else if (MOVE_KEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.moveKey = (NamedKeyStroke)object;
        } else if (TOOLTIP.equals(string)) {
            this.tooltip = (String)object;
            this.launchButton.setAttribute(string, object);
        } else {
            this.launchButton.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("mapName".equals(string)) {
            return this.getMapName();
        }
        if (MARK_MOVED.equals(string)) {
            return this.markMovedOption;
        }
        if (MARK_UNMOVED_ICON.equals(string)) {
            return this.markUnmovedIcon;
        }
        if (MARK_UNMOVED_TEXT.equals(string)) {
            return this.markUnmovedText;
        }
        if (MARK_UNMOVED_TOOLTIP.equals(string)) {
            return this.markUnmovedTooltip;
        }
        if (EDGE_WIDTH.equals(string)) {
            return String.valueOf(this.edgeBuffer.width);
        }
        if (EDGE_HEIGHT.equals(string)) {
            return String.valueOf(this.edgeBuffer.height);
        }
        if (BACKGROUND_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        if (ALLOW_MULTIPLE.equals(string)) {
            return String.valueOf(this.picker.isAllowMultiple());
        }
        if (HIGHLIGHT_COLOR.equals(string)) {
            if (this.highlighter instanceof ColoredBorder) {
                return ColorConfigurer.colorToString(((ColoredBorder)this.highlighter).getColor());
            }
            return null;
        }
        if (HIGHLIGHT_THICKNESS.equals(string)) {
            if (this.highlighter instanceof ColoredBorder) {
                return String.valueOf(((ColoredBorder)this.highlighter).getThickness());
            }
            return null;
        }
        if (USE_LAUNCH_BUTTON.equals(string)) {
            return String.valueOf(this.useLaunchButtonEdit);
        }
        if (MOVE_WITHIN_FORMAT.equals(string)) {
            return this.getMoveWithinFormat();
        }
        if (MOVE_TO_FORMAT.equals(string)) {
            return this.getMoveToFormat();
        }
        if (CREATE_FORMAT.equals(string)) {
            return this.getCreateFormat();
        }
        if (CHANGE_FORMAT.equals(string)) {
            return this.getChangeFormat();
        }
        if (MOVE_KEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.moveKey);
        }
        if (TOOLTIP.equals(string)) {
            return this.tooltip == null || this.tooltip.length() == 0 ? this.launchButton.getAttributeValueString(this.name) : this.tooltip;
        }
        return this.launchButton.getAttributeValueString(string);
    }

    @Override
    public void build(Element element) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Map.this.mainWindowDock == null && Map.this.launchButton.isEnabled() && Map.this.theMap.getTopLevelAncestor() != null) {
                    Map.this.theMap.getTopLevelAncestor().setVisible(!Map.this.theMap.getTopLevelAncestor().isVisible());
                }
            }
        };
        this.launchButton = new LaunchButton(Resources.getString("Editor.Map.map"), TOOLTIP, BUTTON_NAME, HOTKEY, ICON, actionListener);
        this.launchButton.setEnabled(false);
        this.launchButton.setVisible(false);
        if (element != null) {
            super.build(element);
            this.getBoardPicker();
            this.getStackMetrics();
        } else {
            this.getBoardPicker();
            this.getStackMetrics();
            this.addChild(new ForwardToKeyBuffer());
            this.addChild(new Scroller());
            this.addChild(new ForwardToChatter());
            this.addChild(new MenuDisplayer());
            this.addChild(new MapCenterer());
            this.addChild(new StackExpander());
            this.addChild(new PieceMover());
            this.addChild(new KeyBufferer());
            this.addChild(new ImageSaver());
            this.addChild(new CounterDetailViewer());
            this.setMapName("Main Map");
        }
        if (this.getComponentsOf(GlobalProperties.class).isEmpty()) {
            this.addChild(new GlobalProperties());
        }
        if (this.getComponentsOf(SelectionHighlighters.class).isEmpty()) {
            this.addChild(new SelectionHighlighters());
        }
        if (this.getComponentsOf(HighlightLastMoved.class).isEmpty()) {
            this.addChild(new HighlightLastMoved());
        }
        this.setup(false);
    }

    private void addChild(Buildable buildable) {
        this.add(buildable);
        buildable.addTo(this);
    }

    public void setBoardPicker(BoardPicker boardPicker) {
        if (this.picker != null) {
            GameModule.getGameModule().removeCommandEncoder(boardPicker);
            GameModule.getGameModule().getGameState().addGameComponent(boardPicker);
        }
        this.picker = boardPicker;
        if (boardPicker != null) {
            boardPicker.setAllowMultiple(this.allowMultiple);
            GameModule.getGameModule().addCommandEncoder(boardPicker);
            GameModule.getGameModule().getGameState().addGameComponent(boardPicker);
        }
    }

    public BoardPicker getBoardPicker() {
        if (this.picker == null) {
            this.picker = new BoardPicker();
            this.picker.build(null);
            this.add(this.picker);
            this.picker.addTo(this);
        }
        return this.picker;
    }

    public void setZoomer(Zoomer zoomer) {
        this.zoom = zoomer;
    }

    public Zoomer getZoomer() {
        return this.zoom;
    }

    public void setStackMetrics(StackMetrics stackMetrics) {
        this.metrics = stackMetrics;
    }

    public StackMetrics getStackMetrics() {
        if (this.metrics == null) {
            this.metrics = new StackMetrics();
            this.metrics.build(null);
            this.add(this.metrics);
            this.metrics.addTo(this);
        }
        return this.metrics;
    }

    public double getZoom() {
        return this.zoom == null ? 1.0 : this.zoom.getZoomFactor();
    }

    @Override
    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void addDrawComponent(Drawable drawable) {
        this.drawComponents.add(drawable);
    }

    public void removeDrawComponent(Drawable drawable) {
        this.drawComponents.remove(drawable);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.useLaunchButton = this.useLaunchButtonEdit;
        idMgr.add(this);
        GameModule gameModule = GameModule.getGameModule();
        gameModule.addCommandEncoder(new ChangePropertyCommandEncoder(this));
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, BoardPicker.class), new MandatoryComponent(this, StackMetrics.class)).append(idMgr);
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                if (Map.this.mouseListenerStack.isEmpty() && Map.this.dragGestureListener != null) {
                    Map.this.dragGestureListener.dragGestureRecognized(dragGestureEvent);
                }
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.theMap, 2, dragGestureListener);
        this.theMap.setDropTarget(PieceMover.DragHandler.makeDropTarget(this.theMap, 2, this));
        gameModule.getGameState().addGameComponent(this);
        gameModule.getToolBar().add(this.launchButton);
        if (this.shouldDockIntoMainWindow()) {
            IntConfigurer intConfigurer = new IntConfigurer(MAIN_WINDOW_HEIGHT, null, (Integer)-1);
            Prefs.getGlobalPrefs().addOption(null, intConfigurer);
            ComponentSplitter componentSplitter = new ComponentSplitter();
            this.mainWindowDock = componentSplitter.splitBottom(componentSplitter.getSplitAncestor(gameModule.getControlPanel(), -1), this.layeredPane, true);
            gameModule.addKeyStrokeSource(new KeyStrokeSource(this.theMap, 0));
        } else {
            gameModule.addKeyStrokeSource(new KeyStrokeSource(this.theMap, 2));
        }
        this.toolBar.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Window window = SwingUtilities.getWindowAncestor(Map.this.toolBar);
                if (window != null) {
                    window.validate();
                }
                if (Map.this.toolBar.getSize().width > 0) {
                    Map.this.toolBar.removeHierarchyListener(this);
                }
            }
        });
        PlayerRoster.addSideChangeListener(this);
        gameModule.getPrefs().addOption(Resources.getString("Prefs.general_tab"), new IntConfigurer(PREFERRED_EDGE_DELAY, Resources.getString("Map.scroll_delay_preference"), (Integer)200));
        gameModule.getPrefs().addOption(Resources.getString("Prefs.general_tab"), new BooleanConfigurer(MOVING_STACKS_PICKUP_UNITS, Resources.getString("Map.moving_stacks_preference"), Boolean.FALSE));
    }

    public void setPieceMover(PieceMover pieceMover) {
        this.pieceMover = pieceMover;
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        Window window = SwingUtilities.getWindowAncestor(this.theMap);
        if (window != null) {
            window.dispose();
        }
        GameModule.getGameModule().getToolBar().remove(this.launchButton);
        idMgr.remove(this);
        if (this.picker != null) {
            GameModule.getGameModule().removeCommandEncoder(this.picker);
            GameModule.getGameModule().getGameState().addGameComponent(this.picker);
        }
        PlayerRoster.removeSideChangeListener(this);
    }

    @Override
    public void sideChanged(String string, String string2) {
        this.repaint();
    }

    public synchronized void setBoards(Collection<Board> collection) {
        this.boards.clear();
        for (Board board : collection) {
            board.setMap(this);
            this.boards.add(board);
        }
        this.setBoardBoundaries();
    }

    @Deprecated
    public synchronized void setBoards(Enumeration<Board> enumeration) {
        this.setBoards(Collections.list(enumeration));
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    public Board findBoard(Point point) {
        for (Board board : this.boards) {
            if (!board.bounds().contains(point)) continue;
            return board;
        }
        return null;
    }

    public Zone findZone(Point point) {
        MapGrid mapGrid;
        Board board = this.findBoard(point);
        if (board != null && (mapGrid = board.getGrid()) != null && mapGrid instanceof ZonedGrid) {
            Rectangle rectangle = board.bounds();
            point.translate(-rectangle.x, -rectangle.y);
            return ((ZonedGrid)mapGrid).findZone(point);
        }
        return null;
    }

    public Zone findZone(String string) {
        for (Board board : this.boards) {
            for (ZonedGrid zonedGrid : board.getAllDescendantComponentsOf(ZonedGrid.class)) {
                Zone zone = zonedGrid.findZone(string);
                if (zone == null) continue;
                return zone;
            }
        }
        return null;
    }

    public Region findRegion(String string) {
        for (Board board : this.boards) {
            for (RegionGrid regionGrid : board.getAllDescendantComponentsOf(RegionGrid.class)) {
                Region region = regionGrid.findRegion(string);
                if (region == null) continue;
                return region;
            }
        }
        return null;
    }

    public Board getBoardByName(String string) {
        if (string != null) {
            for (Board board : this.boards) {
                if (!string.equals(board.getName())) continue;
                return board;
            }
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.mapSize();
        dimension.width = (int)((double)dimension.width * this.getZoom());
        dimension.height = (int)((double)dimension.height * this.getZoom());
        return dimension;
    }

    public synchronized Dimension mapSize() {
        Rectangle rectangle = new Rectangle(0, 0);
        for (Board board : this.boards) {
            rectangle.add(board.bounds());
        }
        rectangle.width += this.edgeBuffer.width;
        rectangle.height += this.edgeBuffer.height;
        return rectangle.getSize();
    }

    public boolean isLocationRestricted(Point point) {
        Board board = this.findBoard(point);
        if (board != null) {
            Rectangle rectangle = board.bounds();
            Point point2 = new Point(point);
            point2.translate(-rectangle.x, -rectangle.y);
            return board.isLocationRestricted(point2);
        }
        return false;
    }

    public Point snapTo(Point point) {
        Point point2 = new Point(point);
        Board board = this.findBoard(point);
        if (board == null) {
            return point2;
        }
        Rectangle rectangle = board.bounds();
        point2.translate(-rectangle.x, -rectangle.y);
        point2 = board.snapTo(point2);
        point2.translate(rectangle.x, rectangle.y);
        if (this.findBoard(point2) == null) {
            point2.translate(-rectangle.x, -rectangle.y);
            if (point2.x == rectangle.width) {
                point2.x = rectangle.width - 1;
            } else if (point2.x == -1) {
                point2.x = 0;
            }
            if (point2.y == rectangle.height) {
                point2.y = rectangle.height - 1;
            } else if (point2.y == -1) {
                point2.y = 0;
            }
            point2.translate(rectangle.x, rectangle.y);
        }
        return point2;
    }

    public Dimension getEdgeBuffer() {
        return new Dimension(this.edgeBuffer);
    }

    public Point mapCoordinates(Point point) {
        point = new Point(point);
        point.x = (int)((double)point.x / this.getZoom());
        point.y = (int)((double)point.y / this.getZoom());
        return point;
    }

    public Rectangle mapRectangle(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        rectangle.x = (int)((double)rectangle.x / this.getZoom());
        rectangle.y = (int)((double)rectangle.y / this.getZoom());
        rectangle.width = (int)((double)rectangle.width / this.getZoom());
        rectangle.height = (int)((double)rectangle.height / this.getZoom());
        return rectangle;
    }

    public Point componentCoordinates(Point point) {
        point = new Point(point);
        point.x = (int)((double)point.x * this.getZoom());
        point.y = (int)((double)point.y * this.getZoom());
        return point;
    }

    public Rectangle componentRectangle(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        rectangle.x = (int)((double)rectangle.x * this.getZoom());
        rectangle.y = (int)((double)rectangle.y * this.getZoom());
        rectangle.width = (int)((double)rectangle.width * this.getZoom());
        rectangle.height = (int)((double)rectangle.height * this.getZoom());
        return rectangle;
    }

    public String locationName(Point point) {
        Board board;
        String string = this.getDeckNameAt(point);
        if (string == null && (board = this.findBoard(point)) != null) {
            string = board.locationName(new Point(point.x - board.bounds().x, point.y - board.bounds().y));
        }
        if (string == null) {
            string = Resources.getString("Map.offboard");
        }
        return string;
    }

    public String localizedLocationName(Point point) {
        Board board;
        String string = this.getLocalizedDeckNameAt(point);
        if (string == null && (board = this.findBoard(point)) != null) {
            string = board.localizedLocationName(new Point(point.x - board.bounds().x, point.y - board.bounds().y));
        }
        if (string == null) {
            string = Resources.getString("Map.offboard");
        }
        return string;
    }

    public boolean isVisibleToAll() {
        return !(this instanceof PrivateMap) || this.getAttributeValueString("visible").equals("true");
    }

    public String getDeckNameContaining(Point point) {
        String string = null;
        if (point != null) {
            for (DrawPile drawPile : this.getComponentsOf(DrawPile.class)) {
                Rectangle rectangle = drawPile.boundingBox();
                if (rectangle == null || !rectangle.contains(point)) continue;
                string = drawPile.getConfigureName();
                break;
            }
        }
        return string;
    }

    public String getDeckNameAt(Point point) {
        String string = null;
        if (point != null) {
            for (DrawPile drawPile : this.getComponentsOf(DrawPile.class)) {
                if (!drawPile.getPosition().equals(point)) continue;
                string = drawPile.getConfigureName();
                break;
            }
        }
        return string;
    }

    public String getLocalizedDeckNameAt(Point point) {
        String string = null;
        if (point != null) {
            for (DrawPile drawPile : this.getComponentsOf(DrawPile.class)) {
                if (!drawPile.getPosition().equals(point)) continue;
                string = drawPile.getLocalizedConfigureName();
                break;
            }
        }
        return string;
    }

    public void addLocalMouseListener(MouseListener mouseListener) {
        this.multicaster = AWTEventMulticaster.add(this.multicaster, mouseListener);
    }

    public void addLocalMouseListenerFirst(MouseListener mouseListener) {
        this.multicaster = AWTEventMulticaster.add(mouseListener, this.multicaster);
    }

    public void removeLocalMouseListener(MouseListener mouseListener) {
        this.multicaster = AWTEventMulticaster.remove(this.multicaster, mouseListener);
    }

    public void pushMouseListener(MouseListener mouseListener) {
        this.mouseListenerStack.add(mouseListener);
    }

    public void popMouseListener() {
        this.mouseListenerStack.remove(this.mouseListenerStack.size() - 1);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.mouseListenerStack.isEmpty()) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            this.mouseListenerStack.get(this.mouseListenerStack.size() - 1).mouseClicked(mouseEvent);
        } else if (this.multicaster != null) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            this.multicaster.mouseClicked(mouseEvent);
        }
    }

    public static void clearActiveMap() {
        if (activeMap != null) {
            activeMap.repaint();
            activeMap = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.equals(activeMap)) {
            boolean bl = false;
            ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
            Iterator<GamePiece> iterator = KeyBuffer.getBuffer().getPiecesIterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (GamePiece gamePiece : arrayList) {
                if (gamePiece.getMap() != activeMap) continue;
                KeyBuffer.getBuffer().remove(gamePiece);
                bl = true;
            }
            if (bl && activeMap != null) {
                activeMap.repaint();
            }
        }
        activeMap = this;
        if (!this.mouseListenerStack.isEmpty()) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            this.mouseListenerStack.get(this.mouseListenerStack.size() - 1).mousePressed(mouseEvent);
        } else if (this.multicaster != null) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            this.multicaster.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.translate(this.theMap.getX(), this.theMap.getY());
        if (this.theMap.getBounds().contains(point)) {
            if (!this.mouseListenerStack.isEmpty()) {
                point = this.mapCoordinates(mouseEvent.getPoint());
                mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
                this.mouseListenerStack.get(this.mouseListenerStack.size() - 1).mouseReleased(mouseEvent);
            } else if (this.multicaster != null) {
                point = this.mapCoordinates(mouseEvent.getPoint());
                mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
                this.multicaster.mouseReleased(mouseEvent);
            }
            this.theMap.requestFocus();
        }
        this.clearFirst = true;
        this.theMap.repaint();
        activeMap = this;
    }

    public void enableKeyListeners() {
        if (this.saveKeyListeners == null) {
            return;
        }
        for (KeyListener keyListener : this.saveKeyListeners) {
            this.theMap.addKeyListener(keyListener);
        }
        this.saveKeyListeners = null;
    }

    public void disableKeyListeners() {
        if (this.saveKeyListeners != null) {
            return;
        }
        for (KeyListener keyListener : this.saveKeyListeners = this.theMap.getKeyListeners()) {
            this.theMap.removeKeyListener(keyListener);
        }
    }

    public void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    public DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.scrollAtEdge(dropTargetDragEvent.getLocation(), 30);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.getDropTargetContext().getComponent() == this.theMap) {
            MouseEvent mouseEvent = new MouseEvent(this.theMap, 502, System.currentTimeMillis(), 0, dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y, 1, false);
            this.theMap.dispatchEvent(mouseEvent);
            dropTargetDropEvent.dropComplete(true);
        }
        if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            this.scrollAtEdge(mouseEvent.getPoint(), 30);
        } else if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
    }

    public void scrollAtEdge(Point point, int n) {
        Rectangle rectangle = this.scroll.getViewport().getViewRect();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        this.sx = 0;
        if (n2 < n && n2 >= 0) {
            this.sx = -1;
            this.dx = n - n2;
        } else if (n2 < rectangle.width && n2 >= rectangle.width - n) {
            this.sx = 1;
            this.dx = n - (rectangle.width - n2);
        }
        this.sy = 0;
        if (n3 < n && n3 >= 0) {
            this.sy = -1;
            this.dy = n - n3;
        } else if (n3 < rectangle.height && n3 >= rectangle.height - n) {
            this.sy = 1;
            this.dy = n - (rectangle.height - n3);
        }
        this.dx /= 2;
        this.dy /= 2;
        if (this.sx != 0 || this.sy != 0) {
            if (!this.scroller.isRunning()) {
                this.scroller.setStartDelay(((Integer)GameModule.getGameModule().getPrefs().getValue(PREFERRED_EDGE_DELAY)).intValue());
                this.scroller.start();
            }
        } else if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
    }

    public void repaint(boolean bl) {
        this.clearFirst = bl;
        this.theMap.repaint();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, 0, 0);
    }

    public void paintRegion(Graphics graphics, Rectangle rectangle) {
        this.paintRegion(graphics, rectangle, this.theMap);
    }

    public void paintRegion(Graphics graphics, Rectangle rectangle, Component component) {
        this.clearMapBorder(graphics);
        this.drawBoardsInRegion(graphics, rectangle, component);
        this.drawDrawable(graphics, false);
        this.drawPiecesInRegion(graphics, rectangle, component);
        this.drawDrawable(graphics, true);
    }

    public void drawBoardsInRegion(Graphics graphics, Rectangle rectangle, Component component) {
        for (Board board : this.boards) {
            board.drawRegion(graphics, this.getLocation(board, this.getZoom()), rectangle, this.getZoom(), component);
        }
    }

    public void drawBoardsInRegion(Graphics graphics, Rectangle rectangle) {
        this.drawBoardsInRegion(graphics, rectangle, this.theMap);
    }

    public void repaint() {
        this.theMap.repaint();
    }

    public void drawPiecesInRegion(Graphics graphics, Rectangle rectangle, Component component) {
        if (!this.hideCounters) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.pieceOpacity));
            GamePiece[] gamePieceArray = this.pieces.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                Point point = this.componentCoordinates(gamePieceArray[i].getPosition());
                if (gamePieceArray[i].getClass() == Stack.class) {
                    this.getStackMetrics().draw((Stack)gamePieceArray[i], point, graphics, this, this.getZoom(), rectangle);
                    continue;
                }
                gamePieceArray[i].draw(graphics, point.x, point.y, component, this.getZoom());
                if (!Boolean.TRUE.equals(gamePieceArray[i].getProperty("Selected"))) continue;
                this.highlighter.draw(gamePieceArray[i], graphics, point.x, point.y, component, this.getZoom());
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawPiecesInRegion(Graphics graphics, Rectangle rectangle) {
        this.drawPiecesInRegion(graphics, rectangle, this.theMap);
    }

    public void drawPieces(Graphics graphics, int n, int n2) {
        if (!this.hideCounters) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.pieceOpacity));
            GamePiece[] gamePieceArray = this.pieces.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                Point point = this.componentCoordinates(gamePieceArray[i].getPosition());
                gamePieceArray[i].draw(graphics, point.x + n, point.y + n2, this.theMap, this.getZoom());
                if (!Boolean.TRUE.equals(gamePieceArray[i].getProperty("Selected"))) continue;
                this.highlighter.draw(gamePieceArray[i], graphics, point.x - n, point.y - n2, this.theMap, this.getZoom());
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawDrawable(Graphics graphics, boolean bl) {
        for (Drawable drawable : this.drawComponents) {
            if (bl ^ drawable.drawAboveCounters()) continue;
            drawable.draw(graphics, this);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.drawBoards(graphics, n, n2, this.getZoom(), this.theMap);
        this.drawDrawable(graphics, false);
        this.drawPieces(graphics, n, n2);
        this.drawDrawable(graphics, true);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        this.highlighter = highlighter;
    }

    public void addHighlighter(Highlighter highlighter) {
        this.highlighters.add(highlighter);
    }

    public void removeHighlighter(Highlighter highlighter) {
        this.highlighters.remove(highlighter);
    }

    public Iterator<Highlighter> getHighlighters() {
        return this.highlighters.iterator();
    }

    public Collection<Board> getBoards() {
        return Collections.unmodifiableCollection(this.boards);
    }

    @Deprecated
    public Enumeration<Board> getAllBoards() {
        return Collections.enumeration(this.boards);
    }

    public int getBoardCount() {
        return this.boards.size();
    }

    public Rectangle boundingBoxOf(GamePiece gamePiece) {
        Rectangle rectangle = null;
        if (gamePiece.getMap() == this) {
            Object object;
            rectangle = gamePiece.boundingBox();
            Point point = gamePiece.getPosition();
            rectangle.translate(point.x, point.y);
            if (Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) {
                rectangle.add(this.highlighter.boundingBox(gamePiece));
                object = this.getHighlighters();
                while (object.hasNext()) {
                    rectangle.add(((Highlighter)object.next()).boundingBox(gamePiece));
                }
            }
            if (gamePiece.getParent() != null) {
                object = this.getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
                rectangle.translate(((Point)object).x, ((Point)object).y);
            }
        }
        return rectangle;
    }

    public Rectangle selectionBoundsOf(GamePiece gamePiece) {
        if (gamePiece.getMap() != this) {
            throw new IllegalArgumentException(Resources.getString("Map.piece_not_on_map"));
        }
        Rectangle rectangle = gamePiece.getShape().getBounds();
        rectangle.translate(gamePiece.getPosition().x, gamePiece.getPosition().y);
        if (gamePiece.getParent() != null) {
            Point point = this.getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
            rectangle.translate(point.x, point.y);
        }
        return rectangle;
    }

    public Point positionOf(GamePiece gamePiece) {
        if (gamePiece.getMap() != this) {
            throw new IllegalArgumentException(Resources.getString("Map.piece_not_on_map"));
        }
        Point point = gamePiece.getPosition();
        if (gamePiece.getParent() != null) {
            Point point2 = this.getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
            point.translate(point2.x, point2.y);
        }
        return point;
    }

    public GamePiece[] getPieces() {
        return this.pieces.getPieces();
    }

    public GamePiece[] getAllPieces() {
        return this.pieces.getAllPieces();
    }

    public void setPieceCollection(PieceCollection pieceCollection) {
        this.pieces = pieceCollection;
    }

    public PieceCollection getPieceCollection() {
        return this.pieces;
    }

    protected void clearMapBorder(Graphics graphics) {
        if (this.clearFirst || this.boards.isEmpty()) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, this.theMap.getWidth(), this.theMap.getHeight());
            this.clearFirst = false;
        } else {
            Dimension dimension = new Dimension((int)(this.getZoom() * (double)this.edgeBuffer.width), (int)(this.getZoom() * (double)this.edgeBuffer.height));
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, dimension.width, this.theMap.getHeight());
            graphics.fillRect(0, 0, this.theMap.getWidth(), dimension.height);
            graphics.fillRect(this.theMap.getWidth() - dimension.width, 0, dimension.width, this.theMap.getHeight());
            graphics.fillRect(0, this.theMap.getHeight() - dimension.height, this.theMap.getWidth(), dimension.height);
        }
    }

    protected void setBoardBoundaries() {
        int n = 0;
        int n2 = 0;
        for (Board object2 : this.boards) {
            Point point = object2.relativePosition();
            n = Math.max(n, point.x);
            n2 = Math.max(n2, point.y);
        }
        this.boardWidths = new int[n + 1][n2 + 1];
        this.boardHeights = new int[n + 1][n2 + 1];
        for (Board board : this.boards) {
            Point point = board.relativePosition();
            this.boardWidths[point.x][point.y] = board.bounds().width;
            this.boardHeights[point.x][point.y] = board.bounds().height;
        }
        Point point = new Point(this.edgeBuffer.width, this.edgeBuffer.height);
        for (Board board : this.boards) {
            Point point2 = board.relativePosition();
            Point point3 = this.getLocation(point2.x, point2.y, 1.0);
            board.setLocation(point3.x, point3.y);
            board.translate(point.x, point.y);
        }
        this.theMap.revalidate();
    }

    protected Point getLocation(Board board, double d) {
        Point point;
        if (d == 1.0) {
            point = board.bounds().getLocation();
        } else {
            Point point2 = board.relativePosition();
            point = this.getLocation(point2.x, point2.y, d);
            point.translate((int)(d * (double)this.edgeBuffer.width), (int)(d * (double)this.edgeBuffer.height));
        }
        return point;
    }

    protected Point getLocation(int n, int n2, double d) {
        int n3;
        Point point = new Point();
        for (n3 = 0; n3 < n; ++n3) {
            point.translate((int)Math.floor(d * (double)this.boardWidths[n3][n2]), 0);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            point.translate(0, (int)Math.floor(d * (double)this.boardHeights[n][n3]));
        }
        return point;
    }

    public void drawBoards(Graphics graphics, int n, int n2, double d, Component component) {
        for (Board board : this.boards) {
            Point point = this.getLocation(board, d);
            point.translate(n, n2);
            board.draw(graphics, point.x, point.y, d, component);
        }
    }

    public void repaint(Rectangle rectangle) {
        rectangle.setLocation(this.componentCoordinates(new Point(rectangle.x, rectangle.y)));
        rectangle.setSize((int)((double)rectangle.width * this.getZoom()), (int)((double)rectangle.height * this.getZoom()));
        this.theMap.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setPiecesVisible(boolean bl) {
        this.hideCounters = !bl;
    }

    public boolean isPiecesVisible() {
        return !this.hideCounters && this.pieceOpacity != 0.0f;
    }

    public float getPieceOpacity() {
        return this.pieceOpacity;
    }

    public void setPieceOpacity(float f) {
        this.pieceOpacity = f;
    }

    @Override
    public Object getProperty(Object object) {
        Object object2 = null;
        MutableProperty mutableProperty = this.propsContainer.getMutableProperty(String.valueOf(object));
        object2 = mutableProperty != null ? mutableProperty.getPropertyValue() : GameModule.getGameModule().getProperty(object);
        return object2;
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        Object object2 = null;
        MutableProperty mutableProperty = this.propsContainer.getMutableProperty(String.valueOf(object));
        if (mutableProperty != null) {
            object2 = mutableProperty.getPropertyValue();
        }
        if (object2 == null) {
            object2 = GameModule.getGameModule().getLocalizedProperty(object);
        }
        return object2;
    }

    public KeyStroke getMoveKey() {
        return this.moveKey == null ? null : this.moveKey.getKeyStroke();
    }

    protected Window createParentFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog jDialog = new JDialog(GameModule.getGameModule().getFrame());
            jDialog.setDefaultCloseOperation(0);
            jDialog.setTitle(this.getDefaultWindowTitle());
            return jDialog;
        }
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(0);
        jFrame.setTitle(this.getDefaultWindowTitle());
        jFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(jFrame));
        return jFrame;
    }

    public boolean shouldDockIntoMainWindow() {
        boolean bl = false;
        if (GlobalOptions.getInstance().isUseSingleWindow() && !this.useLaunchButton) {
            bl = true;
            for (Map map : GameModule.getGameModule().getComponentsOf(Map.class)) {
                if (map == this) break;
                if (!map.shouldDockIntoMainWindow()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            final GameModule gameModule = GameModule.getGameModule();
            if (this.shouldDockIntoMainWindow()) {
                this.mainWindowDock.showComponent();
                int n = (Integer)Prefs.getGlobalPrefs().getValue(MAIN_WINDOW_HEIGHT);
                if (n > 0) {
                    Container container = this.mainWindowDock.getTopLevelAncestor();
                    container.setSize(container.getWidth(), n);
                }
                if (this.toolBar.getParent() == null) {
                    gameModule.getToolBar().addSeparator();
                    gameModule.getToolBar().add(this.toolBar);
                }
                this.toolBar.setVisible(true);
            } else {
                if (SwingUtilities.getWindowAncestor(this.theMap) == null) {
                    final Window window = this.createParentFrame();
                    window.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            if (Map.this.useLaunchButton) {
                                window.setVisible(false);
                            } else {
                                gameModule.getGameState().setup(false);
                            }
                        }
                    });
                    ((RootPaneContainer)((Object)window)).getContentPane().add("North", this.getToolBar());
                    ((RootPaneContainer)((Object)window)).getContentPane().add("Center", this.layeredPane);
                    window.setSize(600, 400);
                    PositionOption positionOption = new PositionOption(PositionOption.key + this.getIdentifier(), window);
                    gameModule.getPrefs().addOption(positionOption);
                }
                this.theMap.getTopLevelAncestor().setVisible(!this.useLaunchButton);
                this.theMap.revalidate();
            }
        } else {
            this.pieces.clear();
            this.boards.clear();
            if (this.mainWindowDock != null) {
                if (this.mainWindowDock.getHideableComponent().isShowing()) {
                    Prefs.getGlobalPrefs().getOption(MAIN_WINDOW_HEIGHT).setValue(this.mainWindowDock.getTopLevelAncestor().getHeight());
                }
                this.mainWindowDock.hideComponent();
                this.toolBar.setVisible(false);
            } else if (this.theMap.getTopLevelAncestor() != null) {
                this.theMap.getTopLevelAncestor().setVisible(false);
            }
        }
        this.launchButton.setEnabled(bl);
        this.launchButton.setVisible(this.useLaunchButton);
    }

    public void appendToTitle(String string) {
        if (this.mainWindowDock == null) {
            Container container = this.theMap.getTopLevelAncestor();
            if (string == null) {
                if (container instanceof JFrame) {
                    ((JFrame)container).setTitle(this.getDefaultWindowTitle());
                }
                if (container instanceof JDialog) {
                    ((JDialog)container).setTitle(this.getDefaultWindowTitle());
                }
            } else {
                if (container instanceof JFrame) {
                    ((JFrame)container).setTitle(((JFrame)container).getTitle() + string);
                }
                if (container instanceof JDialog) {
                    ((JDialog)container).setTitle(((JDialog)container).getTitle() + string);
                }
            }
        }
    }

    protected String getDefaultWindowTitle() {
        return this.getLocalizedMapName().length() > 0 ? this.getLocalizedMapName() : Resources.getString("Map.window_title", GameModule.getGameModule().getLocalizedGameName());
    }

    public GamePiece findPiece(Point point, PieceFinder pieceFinder) {
        GamePiece[] gamePieceArray = this.pieces.getPieces();
        for (int i = gamePieceArray.length - 1; i >= 0; --i) {
            GamePiece gamePiece = pieceFinder.select(this, gamePieceArray[i], point);
            if (gamePiece == null) continue;
            return gamePiece;
        }
        return null;
    }

    public GamePiece findAnyPiece(Point point, PieceFinder pieceFinder) {
        GamePiece[] gamePieceArray = this.pieces.getAllPieces();
        for (int i = gamePieceArray.length - 1; i >= 0; --i) {
            GamePiece gamePiece = pieceFinder.select(this, gamePieceArray[i], point);
            if (gamePiece == null) continue;
            return gamePiece;
        }
        return null;
    }

    public Command placeAt(GamePiece gamePiece, Point point) {
        Command command = null;
        if (GameModule.getGameModule().getGameState().getPieceForId(gamePiece.getId()) == null) {
            gamePiece.setPosition(point);
            this.addPiece(gamePiece);
            GameModule.getGameModule().getGameState().addPiece(gamePiece);
            command = new AddPiece(gamePiece);
        } else {
            MoveTracker moveTracker = new MoveTracker(gamePiece);
            gamePiece.setPosition(point);
            this.addPiece(gamePiece);
            command = moveTracker.getMoveCommand();
        }
        return command;
    }

    public Command apply(PieceVisitorDispatcher pieceVisitorDispatcher) {
        GamePiece[] gamePieceArray = this.pieces.getPieces();
        Command command = null;
        for (int i = 0; i < gamePieceArray.length && command == null; ++i) {
            command = (Command)pieceVisitorDispatcher.accept(gamePieceArray[i]);
        }
        return command;
    }

    public Command placeOrMerge(GamePiece gamePiece, Point point) {
        Command command = this.apply(new DeckVisitorDispatcher(new Merger(this, point, gamePiece)));
        if (command == null || command.isNull()) {
            Stack stack;
            command = this.placeAt(gamePiece, point);
            if (!(gamePiece instanceof Stack) && !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && (stack = this.getStackMetrics().createStack(gamePiece)) != null) {
                command = command.append(this.placeAt(stack, point));
            }
        }
        return command;
    }

    public void addPiece(GamePiece gamePiece) {
        if (this.indexOf(gamePiece) < 0) {
            if (gamePiece.getParent() != null) {
                gamePiece.getParent().remove(gamePiece);
                gamePiece.setParent(null);
            }
            if (gamePiece.getMap() != null && gamePiece.getMap() != this) {
                gamePiece.getMap().removePiece(gamePiece);
            }
            this.pieces.add(gamePiece);
            gamePiece.setMap(this);
            this.theMap.repaint();
        }
    }

    @Deprecated
    public void reposition(GamePiece gamePiece, int n) {
    }

    public int indexOf(GamePiece gamePiece) {
        return this.pieces.indexOf(gamePiece);
    }

    public void removePiece(GamePiece gamePiece) {
        this.pieces.remove(gamePiece);
        this.theMap.repaint();
    }

    public void centerAt(Point point) {
        this.centerAt(point, 0, 0);
    }

    public void centerAt(Point point, int n, int n2) {
        if (this.scroll != null) {
            point = this.componentCoordinates(point);
            Rectangle rectangle = this.theMap.getVisibleRect();
            rectangle.x = point.x - rectangle.width / 2;
            rectangle.y = point.y - rectangle.height / 2;
            Dimension dimension = this.getPreferredSize();
            if (rectangle.x + rectangle.width > dimension.width) {
                rectangle.x = dimension.width - rectangle.width;
            }
            if (rectangle.y + rectangle.height > dimension.height) {
                rectangle.y = dimension.height - rectangle.height;
            }
            rectangle.width = n > rectangle.width ? 0 : rectangle.width - n;
            rectangle.height = n2 > rectangle.height ? 0 : rectangle.height - n2;
            this.theMap.scrollRectToVisible(rectangle);
        }
    }

    public void ensureVisible(Rectangle rectangle) {
        if (this.scroll != null) {
            Point point = this.componentCoordinates(rectangle.getLocation());
            rectangle = new Rectangle(point.x, point.y, (int)(this.getZoom() * (double)rectangle.width), (int)(this.getZoom() * (double)rectangle.height));
            this.theMap.scrollRectToVisible(rectangle);
        }
    }

    public void scroll(int n, int n2) {
        Rectangle rectangle = this.scroll.getViewport().getViewRect();
        rectangle.translate(n, n2);
        rectangle = rectangle.intersection(new Rectangle(this.getPreferredSize()));
        this.theMap.scrollRectToVisible(rectangle);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Map.component_type");
    }

    public String getMapName() {
        return this.getConfigureName();
    }

    public String getLocalizedMapName() {
        return this.getLocalizedConfigureName();
    }

    public void setMapName(String string) {
        this.mapName = string;
        this.setConfigureName(this.mapName);
        if (this.tooltip == null || this.tooltip.length() == 0) {
            this.launchButton.setToolTipText(string != null ? Resources.getString("Map.show_hide", string) : Resources.getString("Map.show_hide", Resources.getString("Map.map")));
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.Map.map_name"), Resources.getString("Editor.Map.mark_pieces_moved"), Resources.getString("Editor.Map.mark_unmoved_button_text"), Resources.getString("Editor.Map.mark_unmoved_tooltip_text"), Resources.getString("Editor.Map.mark_unmoved_button_icon"), Resources.getString("Editor.Map.horizontal"), Resources.getString("Editor.Map.vertical"), Resources.getString("Editor.Map.bkgdcolor"), Resources.getString("Editor.Map.multiboard"), Resources.getString("Editor.Map.bc_selected_counter"), Resources.getString("Editor.Map.bt_selected_counter"), Resources.getString("Editor.Map.show_hide"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.Map.report_move_within"), Resources.getString("Editor.Map.report_move_to"), Resources.getString("Editor.Map.report_created"), Resources.getString("Editor.Map.report_modified"), Resources.getString("Editor.Map.key_applied_all")};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"mapName", MARK_MOVED, MARK_UNMOVED_TEXT, MARK_UNMOVED_TOOLTIP, MARK_UNMOVED_ICON, EDGE_WIDTH, EDGE_HEIGHT, BACKGROUND_COLOR, ALLOW_MULTIPLE, HIGHLIGHT_COLOR, HIGHLIGHT_THICKNESS, USE_LAUNCH_BUTTON, BUTTON_NAME, TOOLTIP, ICON, HOTKEY, MOVE_WITHIN_FORMAT, MOVE_TO_FORMAT, CREATE_FORMAT, CHANGE_FORMAT, MOVE_KEY};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, GlobalOptions.Prompt.class, String.class, String.class, UnmovedIconConfig.class, Integer.class, Integer.class, Color.class, Boolean.class, Color.class, Integer.class, Boolean.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, MoveWithinFormatConfig.class, MoveToFormatConfig.class, CreateFormatConfig.class, ChangeFormatConfig.class, NamedKeyStroke.class};
    }

    public String getCreateFormat() {
        Board board;
        if (this.createFormat != null) {
            return this.createFormat;
        }
        String string = "$pieceName$ created in $location$";
        if (!(this.boards.isEmpty() || (board = this.boards.get(0)).getGrid() != null && board.getGrid().getGridNumbering() != null)) {
            string = "";
        }
        return string;
    }

    public String getChangeFormat() {
        return Map.isChangeReportingEnabled() ? this.changeFormat : "";
    }

    public String getMoveToFormat() {
        Board board;
        if (this.moveToFormat != null) {
            return this.moveToFormat;
        }
        String string = "$pieceName$ moves $previousLocation$ -> $location$ *";
        if (!(this.boards.isEmpty() || (board = this.boards.get(0)).getGrid() != null && board.getGrid().getGridNumbering() == null)) {
            string = "";
        }
        return string;
    }

    public String getMoveWithinFormat() {
        Board board;
        if (this.moveWithinFormat != null) {
            return this.moveWithinFormat;
        }
        String string = "$pieceName$ moves $previousLocation$ -> $location$ *";
        if (!this.boards.isEmpty() && (board = this.boards.get(0)).getGrid() == null) {
            string = "";
        }
        return string;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray = new Class[]{GlobalMap.class, LOS_Thread.class, ToolbarMenu.class, MultiActionButton.class, HidePiecesButton.class, Zoomer.class, CounterDetailViewer.class, HighlightLastMoved.class, LayeredPieceCollection.class, ImageSaver.class, TextSaver.class, DrawPile.class, SetupStack.class, MassKeyCommand.class, MapShader.class, PieceRecenterer.class};
        return classArray;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (this.visibilityCondition == null) {
            this.visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Map.this.useLaunchButton;
                }
            };
        }
        if (HOTKEY.equals(string) || BUTTON_NAME.equals(string) || TOOLTIP.equals(string) || ICON.equals(string)) {
            return this.visibilityCondition;
        }
        if (MARK_UNMOVED_TEXT.equals(string) || MARK_UNMOVED_ICON.equals(string) || MARK_UNMOVED_TOOLTIP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !"Never".equals(Map.this.markMovedOption);
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void setId(String string) {
        this.mapID = string;
    }

    public static Map getMapById(String string) {
        return (Map)idMgr.findInstance(string);
    }

    public static List<Map> getMapList() {
        GameModule gameModule = GameModule.getGameModule();
        List<Map> list = gameModule.getComponentsOf(Map.class);
        for (ChartWindow chartWindow : gameModule.getComponentsOf(ChartWindow.class)) {
            for (MapWidget mapWidget : chartWindow.getAllDescendantComponentsOf(MapWidget.class)) {
                list.add(mapWidget.getMap());
            }
        }
        return list;
    }

    @Deprecated
    public static Iterator<Map> getAllMaps() {
        return Map.getMapList().iterator();
    }

    @Override
    public MutableProperty getMutableProperty(String string) {
        return this.propsContainer.getMutableProperty(string);
    }

    @Override
    public void addMutableProperty(String string, MutableProperty mutableProperty) {
        this.propsContainer.addMutableProperty(string, mutableProperty);
        mutableProperty.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
    }

    @Override
    public MutableProperty removeMutableProperty(String string) {
        MutableProperty mutableProperty = this.propsContainer.removeMutableProperty(string);
        if (mutableProperty != null) {
            mutableProperty.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return mutableProperty;
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return this.getMapName();
    }

    @Override
    public String getId() {
        return this.mapID;
    }

    public String getIdentifier() {
        return UniqueIdManager.getIdentifier(this);
    }

    public JComponent getView() {
        if (this.theMap == null) {
            this.theMap = new View(this);
            this.scroll = new AdjustableSpeedScrollPane(this.theMap, 20, 30);
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
            this.scroll.setAlignmentX(0.0f);
            this.scroll.setAlignmentY(0.0f);
            this.layeredPane.setLayout(new InsetLayout(this.layeredPane, this.scroll));
            this.layeredPane.add((Component)this.scroll, JLayeredPane.DEFAULT_LAYER);
        }
        return this.theMap;
    }

    public JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }

    public static class View
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Map map;

        public View(Map map) {
            this.setFocusTraversalKeysEnabled(false);
            this.map = map;
        }

        public void paint(Graphics graphics) {
            if (GameModule.getGameModule().getGameState().isUpdating()) {
                return;
            }
            Rectangle rectangle = this.getVisibleRect();
            graphics.setColor(this.map.bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.map.paintRegion(graphics, rectangle);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return this.map.getPreferredSize();
        }

        public Map getMap() {
            return this.map;
        }
    }

    public static class Merger
    implements DeckVisitor {
        private Point pt;
        private Map map;
        private GamePiece p;

        public Merger(Map map, Point point, GamePiece gamePiece) {
            this.map = map;
            this.pt = point;
            this.p = gamePiece;
        }

        public Object visitDeck(Deck deck) {
            if (deck.getPosition().equals(this.pt)) {
                return this.map.getStackMetrics().merge(deck, this.p);
            }
            return null;
        }

        public Object visitStack(Stack stack) {
            if (stack.getPosition().equals(this.pt) && this.map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(this.p.getProperty("NoStack")) && stack.topPiece() != null && this.map.getPieceCollection().canMerge(stack, this.p)) {
                return this.map.getStackMetrics().merge(stack, this.p);
            }
            return null;
        }

        public Object visitDefault(GamePiece gamePiece) {
            if (gamePiece.getPosition().equals(this.pt) && this.map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(this.p.getProperty("NoStack")) && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && this.map.getPieceCollection().canMerge(gamePiece, this.p)) {
                return this.map.getStackMetrics().merge(gamePiece, this.p);
            }
            return null;
        }
    }

    public static class InsetLayout
    extends OverlayLayout {
        private static final long serialVersionUID = 1L;
        private final JScrollPane base;

        public InsetLayout(Container container, JScrollPane jScrollPane) {
            super(container);
            this.base = jScrollPane;
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            this.base.getLayout().layoutContainer(this.base);
            Dimension dimension = this.base.getViewport().getSize();
            Insets insets = this.base.getInsets();
            dimension.width += insets.left;
            dimension.height += insets.top;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (component == this.base || !component.isVisible()) continue;
                Rectangle rectangle = component.getBounds();
                rectangle.width = Math.min(rectangle.width, dimension.width);
                rectangle.height = Math.min(rectangle.height, dimension.height);
                component.setBounds(rectangle);
            }
        }
    }

    public static class ChangeFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.MESSAGE, "menuCommand", "oldPieceName", "newPieceName", "mapName", Map.LOCATION});
        }
    }

    public static class CreateFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.PIECE_NAME, "mapName", Map.LOCATION});
        }
    }

    public static class MoveToFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.PIECE_NAME, Map.LOCATION, Map.OLD_MAP, "mapName", Map.OLD_LOCATION});
        }
    }

    public static class MoveWithinFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.PIECE_NAME, Map.LOCATION, "mapName", Map.OLD_LOCATION});
        }
    }

    public static class UnmovedIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/unmoved.gif");
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/map.gif");
        }
    }
}

