/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.BoxWidget;
import VASSAL.build.widget.ListWidget;
import VASSAL.build.widget.PanelWidget;
import VASSAL.build.widget.PieceSlot;
import VASSAL.build.widget.TabWidget;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.menu.MenuManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceWindow
extends Widget
implements UniqueIdManager.Identifyable {
    protected String id;
    protected LaunchButton launch;
    protected boolean hidden;
    public static final String DEPRECATED_NAME = "entryName";
    public static final String NAME = "name";
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String HIDDEN = "hidden";
    protected static UniqueIdManager idMgr = new UniqueIdManager("PieceWindow");
    protected JComponent root = new JPanel(new BorderLayout());
    protected ComponentSplitter.SplitPane mainWindowDock;
    protected String tooltip = "";

    public PieceWindow() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PieceWindow.this.launchButtonPressed();
            }
        };
        this.launch = new LaunchButton(Resources.getString("Editor.PieceWindow.pieces"), TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.launch.setToolTipText(Resources.getString("Editor.PieceWindow.show_hide_pieces_window", Resources.getString("Editor.PieceWindow.pieces")));
    }

    private Window initFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            final JDialog jDialog = new JDialog(GameModule.getGameModule().getFrame());
            jDialog.add(this.root);
            jDialog.setDefaultCloseOperation(1);
            jDialog.setTitle(this.getConfigureName());
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (PieceWindow.NAME.equals(propertyChangeEvent.getPropertyName())) {
                        jDialog.setTitle((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
            return jDialog;
        }
        final JFrame jFrame = new JFrame();
        jFrame.add(this.root);
        jFrame.setDefaultCloseOperation(1);
        jFrame.setTitle(this.getConfigureName());
        jFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(jFrame));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PieceWindow.NAME.equals(propertyChangeEvent.getPropertyName())) {
                    jFrame.setTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        return jFrame;
    }

    public void launchButtonPressed() {
        if (this.mainWindowDock != null) {
            this.mainWindowDock.toggleVisibility();
        } else {
            this.root.getTopLevelAncestor().setVisible(!this.root.getTopLevelAncestor().isVisible());
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PieceWindow.htm");
    }

    @Override
    public void build(Element element) {
        super.build(element);
        this.rebuild();
    }

    public boolean shouldDockIntoMainWindow() {
        return "PieceWindow0".equals(this.id);
    }

    @Override
    public Component getComponent() {
        return this.root;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PieceWindow.component_type");
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{TabWidget.class, PanelWidget.class, BoxWidget.class, ListWidget.class, PieceSlot.class};
    }

    @Override
    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.root.add(((Widget)buildable).getComponent());
        }
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.root.remove(((Widget)buildable).getComponent());
        }
        super.remove(buildable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void addTo(Buildable buildable) {
        idMgr.add(this);
        if (!this.hidden) {
            String string = PositionOption.key + this.getConfigureName();
            if ("PieceWindow0".equals(this.id) && GlobalOptions.getInstance().isUseSingleWindow()) {
                this.mainWindowDock = new ComponentSplitter().splitLeft(GameModule.getGameModule().getControlPanel(), this.root, false);
            } else {
                Window window = this.initFrame();
                VisibilityOption visibilityOption = new VisibilityOption(string, window);
                GameModule.getGameModule().getPrefs().addOption(visibilityOption);
            }
            GameModule.getGameModule().getToolBar().add(this.launch);
        }
        this.setAttributeTranslatable(NAME, false);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        if (this.mainWindowDock == null && this.root != null && this.root.getTopLevelAncestor() != null) {
            this.root.getTopLevelAncestor().setVisible(false);
        }
        GameModule.getGameModule().getToolBar().remove(this.launch);
        idMgr.remove(this);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.PieceWindow.hidden"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.PieceWindow.show_hide")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, HIDDEN, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute(NAME, object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if (NAME.equals(string)) {
            String string2 = (String)object;
            this.setConfigureName(string2);
            if (this.tooltip.length() == 0) {
                this.launch.setToolTipText(Resources.getString("Editor.PieceWindow.show_hide_pieces_window", string2));
            }
        } else if (HIDDEN.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.hidden = (Boolean)object;
        } else if (TOOLTIP.equals(string)) {
            this.tooltip = (String)object;
            this.launch.setAttribute(string, object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (HIDDEN.equals(string)) {
            return String.valueOf(this.hidden);
        }
        if (TOOLTIP.equals(string)) {
            return this.tooltip.length() == 0 ? this.launch.getAttributeValueString(string) : this.tooltip;
        }
        return this.launch.getAttributeValueString(string);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/counter.gif");
        }
    }
}

