/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextItemInstance
extends ItemInstance {
    protected static final String VALUE = "value";
    protected static final String OUTLINE_COLOR = "outlineColor";
    protected String val = "";
    protected ColorSwatch outlineColor = ColorSwatch.getRed();
    private VisibilityCondition valueCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !((TextItem)TextItemInstance.this.getItem()).isFixed();
        }
    };

    public TextItemInstance() {
        this.val = "Xx";
        this.outlineColor = ColorSwatch.getRed();
    }

    public TextItemInstance(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        if (string4 == null) {
            switch (string.length()) {
                case 0: {
                    this.setValue("Xx");
                    break;
                }
                case 1: {
                    this.setValue(string);
                    break;
                }
                default: {
                    this.setValue(string.substring(0, 2));
                    break;
                }
            }
        } else {
            this.setValue(string4);
        }
    }

    public TextItemInstance(String string, GamePieceImage gamePieceImage) {
        super(gamePieceImage);
        this.decode(string);
    }

    public void setValue(String string) {
        this.val = string;
    }

    public String getValue() {
        return this.val;
    }

    public boolean isOutline() {
        TextItem textItem = (TextItem)this.getItem();
        return textItem == null ? false : textItem.isOutline();
    }

    public ColorSwatch getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(ColorSwatch colorSwatch) {
        this.outlineColor = colorSwatch;
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getType());
        sequenceEncoder.append(this.getName());
        sequenceEncoder.append(this.getLocation());
        sequenceEncoder.append(this.getFgColor().encode());
        sequenceEncoder.append(this.getBgColor().encode());
        sequenceEncoder.append(this.getValue());
        sequenceEncoder.append(this.getOutlineColor().encode());
        return sequenceEncoder.getValue();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.setType(decoder.nextToken(""));
        this.setName(decoder.nextToken(""));
        this.setLocation(decoder.nextToken(""));
        this.setFgColor(new ColorSwatch(decoder.nextToken("")));
        this.setBgColor(new ColorSwatch(decoder.nextToken("")));
        this.setValue(decoder.nextToken(""));
        this.setOutlineColor(new ColorSwatch(decoder.nextToken("")));
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Value:  ", "Foreground Color:  ", "Background Color:  ", "Outline Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, FgColorSwatchConfig.class, BgColorSwatchConfig.class, OutlineColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{VALUE, "fgColor", "bgColor", OUTLINE_COLOR};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (VALUE.equals(string)) {
            this.val = (String)object;
        } else if ("fgColor".equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.fgColor = (ColorSwatch)object;
        } else if ("bgColor".equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.bgColor = (ColorSwatch)object;
        } else if (OUTLINE_COLOR.equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.outlineColor = (ColorSwatch)object;
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (VALUE.equals(string)) {
            return this.val;
        }
        if ("fgColor".equals(string)) {
            return this.fgColor.encode();
        }
        if ("bgColor".equals(string)) {
            return this.bgColor.encode();
        }
        if (OUTLINE_COLOR.equals(string)) {
            return this.outlineColor.encode();
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (VALUE.equals(string)) {
            return this.valueCond;
        }
        if (OUTLINE_COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return TextItemInstance.this.isOutline();
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public static class OutlineColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((TextItemInstance)autoConfigurable).getOutlineColor());
        }
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((ItemInstance)autoConfigurable).getFgColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((ItemInstance)autoConfigurable).getBgColor());
        }
    }
}

