/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.messageboard.MessageBoardControls;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.chat.ui.ServerStatusView;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MenuManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class ShowServerStatusAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static Window frame;

    public ShowServerStatusAction(ServerStatus serverStatus, URL uRL) {
        this(serverStatus, uRL, true);
    }

    public ShowServerStatusAction(ServerStatus serverStatus, URL uRL, boolean bl) {
        if (frame == null) {
            frame = new Window(serverStatus, bl);
        }
        if (uRL == null) {
            this.putValue("Name", Resources.getString("Chat.server_status"));
        } else {
            this.putValue("SmallIcon", new ImageIcon(uRL));
        }
        this.putValue("ShortDescription", Resources.getString("Chat.display_connections"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        frame.refresh();
    }

    private static class Window
    extends JFrame
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private ServerStatusView view;
        private MessageBoardControls messageMgr;

        public Window(ServerStatus serverStatus, boolean bl) {
            super(Resources.getString("Chat.server_status"));
            Serializable serializable;
            this.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this));
            this.view = new ServerStatusView(serverStatus);
            this.view.addPropertyChangeListener("ServerStatusView.selection", this);
            this.add(this.view);
            if (bl) {
                this.messageMgr = new MessageBoardControls();
                serializable = new JToolBar();
                ((JToolBar)serializable).setFloatable(false);
                ((JToolBar)serializable).add(this.messageMgr.getCheckMessagesAction());
                ((JToolBar)serializable).add(this.messageMgr.getPostMessageAction());
                this.add((Component)serializable, "North");
            }
            this.pack();
            this.setSize(Math.max(this.getSize().width, 400), Math.max(this.getSize().height, 300));
            serializable = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(((Dimension)serializable).width / 2 - this.getSize().width / 2, ((Dimension)serializable).height / 2 - this.getSize().height / 2);
        }

        public void refresh() {
            if (!this.isVisible()) {
                this.setVisible(true);
            } else {
                this.toFront();
            }
            this.view.refresh();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HttpMessageServer httpMessageServer = null;
            String string = null;
            if (propertyChangeEvent.getNewValue() instanceof ServerStatus.ModuleSummary) {
                final String string2 = ((ServerStatus.ModuleSummary)propertyChangeEvent.getNewValue()).getModuleName();
                httpMessageServer = new HttpMessageServer(new PeerPoolInfo(){

                    public String getModuleName() {
                        return string2;
                    }

                    public String getUserName() {
                        return ((ChatServerConnection)GameModule.getGameModule().getServer()).getUserInfo().getName();
                    }
                });
            }
            if (this.messageMgr != null) {
                this.messageMgr.setServer(httpMessageServer, string);
            }
        }
    }
}

