/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyNameExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embellishment
extends Decorator
implements TranslatablePiece {
    public static final String OLD_ID = "emb;";
    public static final String ID = "emb2;";
    public static final String IMAGE = "_Image";
    public static final String NAME = "_Name";
    public static final String LEVEL = "_Level";
    public static final String ACTIVE = "_Active";
    protected String activateKey = "";
    protected String upKey;
    protected String downKey;
    protected int activateModifiers;
    protected int upModifiers;
    protected int downModifiers;
    protected String upCommand;
    protected String downCommand;
    protected String activateCommand;
    protected String resetCommand;
    protected FormattedString resetLevel = new FormattedString("1");
    protected boolean loopLevels;
    protected NamedKeyStroke resetKey;
    protected boolean followProperty;
    protected String propertyName = "";
    protected Expression followPropertyExpression;
    protected int firstLevelValue;
    protected NamedKeyStroke rndKey;
    private String rndText = "";
    protected int value = -1;
    protected int nValues;
    protected int xOff;
    protected int yOff;
    protected String[] imageName;
    protected String[] commonName;
    protected Rectangle[] size;
    protected ScaledImagePainter[] imagePainter;
    protected boolean drawUnderneathWhenSelected = false;
    protected String name = "";
    protected KeyCommand[] commands;
    protected KeyCommand up = null;
    protected KeyCommand down = null;
    protected Rectangle lastBounds = null;
    protected Area lastShape = null;
    public static final int BASE_VERSION = 0;
    public static final int CURRENT_VERSION = 1;
    protected int version;
    protected boolean alwaysActive;
    protected NamedKeyStroke activateKeyStroke;
    protected NamedKeyStroke increaseKeyStroke;
    protected NamedKeyStroke decreaseKeyStroke;

    public Embellishment() {
        this("emb2;Activate", null);
    }

    public Embellishment(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public boolean isActive() {
        return this.value > 0;
    }

    public void setActive(boolean bl) {
        this.value = bl ? Math.abs(this.value) : -Math.abs(this.value);
    }

    public int getValue() {
        return Math.abs(this.value) - 1;
    }

    public void setValue(int n) {
        int n2 = n;
        if (n >= this.nValues) {
            Embellishment.reportDataError(this, Resources.getString("Error.bad_layer"), "Layer=" + n);
            n2 = this.nValues;
        }
        this.value = this.value > 0 ? n2 + 1 : -n2 - 1;
    }

    @Override
    public void mySetType(String string) {
        if (!string.startsWith(ID)) {
            this.originalSetType(string);
        } else {
            string = string.substring(ID.length());
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
            this.activateCommand = decoder.nextToken("");
            this.activateModifiers = decoder.nextInt(2);
            this.activateKey = decoder.nextToken("A");
            this.upCommand = decoder.nextToken("");
            this.upModifiers = decoder.nextInt(2);
            this.upKey = decoder.nextToken("");
            this.downCommand = decoder.nextToken("");
            this.downModifiers = decoder.nextInt(2);
            this.downKey = decoder.nextToken("");
            this.resetCommand = decoder.nextToken("");
            this.resetKey = decoder.nextNamedKeyStroke();
            this.resetLevel = new FormattedString(decoder.nextToken("1"));
            this.drawUnderneathWhenSelected = decoder.nextBoolean(false);
            this.xOff = decoder.nextInt(0);
            this.yOff = decoder.nextInt(0);
            this.imageName = decoder.nextStringArray(0);
            this.commonName = decoder.nextStringArray(this.imageName.length);
            this.loopLevels = decoder.nextBoolean(true);
            this.name = decoder.nextToken("");
            this.rndKey = decoder.nextNamedKeyStroke(null);
            this.rndText = decoder.nextToken("");
            this.followProperty = decoder.nextBoolean(false);
            this.propertyName = decoder.nextToken("");
            this.firstLevelValue = decoder.nextInt(1);
            this.version = decoder.nextInt(0);
            this.alwaysActive = decoder.nextBoolean(false);
            this.activateKeyStroke = decoder.nextNamedKeyStroke();
            this.increaseKeyStroke = decoder.nextNamedKeyStroke();
            this.decreaseKeyStroke = decoder.nextNamedKeyStroke();
            if (this.version == 0) {
                boolean bl = this.alwaysActive = this.activateKey.length() == 0;
                if (this.activateKey.length() <= 1 && this.upKey.length() <= 1 && this.downKey.length() <= 1) {
                    this.activateKeyStroke = this.activateKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.activateKey.charAt(0), this.activateModifiers);
                    this.increaseKeyStroke = this.upKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.upKey.charAt(0), this.upModifiers);
                    this.decreaseKeyStroke = this.downKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.downKey.charAt(0), this.downModifiers);
                    this.version = 1;
                }
            }
            this.value = this.activateKey.length() > 0 ? -1 : 1;
            this.nValues = this.imageName.length;
            this.size = new Rectangle[this.imageName.length];
            this.imagePainter = new ScaledImagePainter[this.imageName.length];
            for (int i = 0; i < this.imageName.length; ++i) {
                this.imagePainter[i] = new ScaledImagePainter();
                this.imagePainter[i].setImageName(this.imageName[i]);
            }
        }
        this.commands = null;
    }

    private void originalSetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ';');
        this.activateKey = decoder2.nextToken().toUpperCase();
        if (this.activateKey != null && this.activateKey.length() > 0) {
            this.activateKeyStroke = new NamedKeyStroke(KeyStroke.getKeyStroke(this.activateKey));
        }
        this.activateModifiers = 2;
        if (decoder2.hasMoreTokens()) {
            this.resetCommand = decoder2.nextToken();
            this.resetKey = decoder2.nextNamedKeyStroke(null);
            this.resetLevel.setFormat(decoder2.nextToken("0"));
        } else {
            this.resetKey = null;
            this.resetCommand = "";
            this.resetLevel.setFormat("0");
        }
        this.activateCommand = decoder.nextToken();
        this.drawUnderneathWhenSelected = this.activateCommand.startsWith("_");
        if (this.drawUnderneathWhenSelected) {
            this.activateCommand = this.activateCommand.substring(1);
        }
        this.value = this.activateKey.length() > 0 ? -1 : 1;
        this.upKey = decoder.nextToken().toUpperCase();
        this.upCommand = decoder.nextToken();
        this.upModifiers = 2;
        this.downKey = decoder.nextToken().toUpperCase();
        this.downCommand = decoder.nextToken();
        this.downModifiers = 2;
        this.xOff = decoder.nextInt(0);
        this.yOff = decoder.nextInt(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (decoder.hasMoreTokens()) {
            arrayList.add(decoder.nextToken());
        }
        this.nValues = arrayList.size();
        this.imageName = new String[arrayList.size()];
        this.commonName = new String[arrayList.size()];
        this.size = new Rectangle[this.imageName.length];
        this.imagePainter = new ScaledImagePainter[this.imageName.length];
        for (int i = 0; i < this.imageName.length; ++i) {
            String string2 = (String)arrayList.get(i);
            SequenceEncoder.Decoder decoder3 = new SequenceEncoder.Decoder(string2, ',');
            this.imageName[i] = decoder3.nextToken();
            this.imagePainter[i] = new ScaledImagePainter();
            this.imagePainter[i].setImageName(this.imageName[i]);
            if (!decoder3.hasMoreTokens()) continue;
            this.commonName[i] = decoder3.nextToken();
        }
        this.loopLevels = true;
        this.alwaysActive = this.activateKey.length() == 0;
        this.activateKeyStroke = this.activateKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.activateKey.charAt(0), this.activateModifiers);
        this.increaseKeyStroke = this.upKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.upKey.charAt(0), this.upModifiers);
        this.decreaseKeyStroke = this.downKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.downKey.charAt(0), this.downModifiers);
        this.version = 1;
    }

    @Override
    public String getLocalizedName() {
        return this.getName(true);
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        String string;
        this.checkPropertyLevel();
        String string2 = null;
        String string3 = string = 0 < this.value && this.value - 1 < this.commonName.length ? this.getCommonName(bl, this.value - 1) : null;
        if (string != null && string.length() > 0) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '+');
            String string4 = decoder.nextToken();
            if (decoder.hasMoreTokens()) {
                String string5 = decoder.nextToken();
                string2 = string4.length() == 0 ? (bl ? this.piece.getLocalizedName() : this.piece.getName()) + string5 : string4 + (bl ? this.piece.getLocalizedName() : this.piece.getName());
            } else {
                string2 = string4;
            }
        } else {
            string2 = bl ? this.piece.getLocalizedName() : this.piece.getName();
        }
        return string2;
    }

    public String getLayerName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.value = decoder.nextInt(-1);
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.activateCommand).append(this.activateModifiers).append(this.activateKey).append(this.upCommand).append(this.upModifiers).append(this.upKey).append(this.downCommand).append(this.downModifiers).append(this.downKey).append(this.resetCommand).append(this.resetKey).append(this.resetLevel.getFormat()).append(this.drawUnderneathWhenSelected).append(this.xOff).append(this.yOff).append(this.imageName).append(this.commonName).append(this.loopLevels).append(this.name).append(this.rndKey).append(this.rndText).append(this.followProperty).append(this.propertyName).append(this.firstLevelValue).append(this.version).append(this.alwaysActive).append(this.activateKeyStroke).append(this.increaseKeyStroke).append(this.decreaseKeyStroke);
        return ID + sequenceEncoder.getValue();
    }

    @Deprecated
    public String oldGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(this.activateKey, ';');
        sequenceEncoder2.append(this.resetCommand).append(this.resetKey).append(String.valueOf(this.resetLevel));
        sequenceEncoder.append(sequenceEncoder2.getValue()).append(this.drawUnderneathWhenSelected ? "_" + this.activateCommand : this.activateCommand).append(this.upKey).append(this.upCommand).append(this.downKey).append(this.downCommand).append(this.xOff).append(this.yOff);
        for (int i = 0; i < this.nValues; ++i) {
            if (this.commonName[i] != null) {
                SequenceEncoder sequenceEncoder3 = new SequenceEncoder(this.imageName[i], ',');
                sequenceEncoder.append(sequenceEncoder3.append(this.commonName[i]).getValue());
                continue;
            }
            sequenceEncoder.append(this.imageName[i]);
        }
        return ID + sequenceEncoder.getValue();
    }

    @Override
    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        return sequenceEncoder.append(String.valueOf(this.value)).getValue();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        boolean bl;
        boolean bl2 = bl = this.drawUnderneathWhenSelected && Boolean.TRUE.equals(this.getProperty("Selected"));
        if (!bl) {
            this.piece.draw(graphics, n, n2, component, d);
        }
        this.checkPropertyLevel();
        if (!this.isActive()) {
            if (bl) {
                this.piece.draw(graphics, n, n2, component, d);
            }
            return;
        }
        int n3 = this.value - 1;
        if (n3 < this.imagePainter.length && this.imagePainter[n3] != null) {
            Rectangle rectangle = this.getCurrentImageBounds();
            this.imagePainter[n3].draw(graphics, n + (int)(d * (double)rectangle.x), n2 + (int)(d * (double)rectangle.y), d, component);
        }
        if (bl) {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    protected void checkPropertyLevel() {
        if (!this.followProperty || this.propertyName.length() == 0) {
            return;
        }
        if (this.followPropertyExpression == null) {
            this.followPropertyExpression = Expression.createSimplePropertyExpression(this.propertyName);
        }
        String string = "";
        try {
            int n;
            string = this.followPropertyExpression.evaluate(Decorator.getOutermost(this));
            if (string == null || string.length() == 0) {
                string = String.valueOf(this.firstLevelValue);
            }
            if ((n = Integer.parseInt(string) - this.firstLevelValue + 1) <= 0) {
                n = 1;
            }
            if (n > this.nValues) {
                n = this.nValues;
            }
            this.value = this.isActive() ? n : -n;
        }
        catch (NumberFormatException numberFormatException) {
            Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), "followProperty[" + this.propertyName + "]=" + string, numberFormatException);
        }
        catch (ExpressionException expressionException) {
            Embellishment.reportDataError(this, Resources.getString("Error.expression_error"), "followProperty[" + this.propertyName + "]", expressionException);
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
            GamePiece gamePiece = Decorator.getOutermost(this);
            if (this.activateCommand != null && this.activateCommand.length() > 0 && !this.alwaysActive) {
                KeyCommand keyCommand = new KeyCommand(this.activateCommand, this.activateKeyStroke, gamePiece, (TranslatablePiece)this);
                keyCommand.setEnabled(this.nValues > 0);
                arrayList.add(keyCommand);
            }
            if (!this.followProperty) {
                if (this.nValues > 1) {
                    if (this.upCommand != null && this.upCommand.length() > 0 && this.increaseKeyStroke != null && !this.increaseKeyStroke.isNull()) {
                        this.up = new KeyCommand(this.upCommand, this.increaseKeyStroke, gamePiece, (TranslatablePiece)this);
                        arrayList.add(this.up);
                    }
                    if (this.downCommand != null && this.downCommand.length() > 0 && this.decreaseKeyStroke != null && !this.decreaseKeyStroke.isNull()) {
                        this.down = new KeyCommand(this.downCommand, this.decreaseKeyStroke, gamePiece, (TranslatablePiece)this);
                        arrayList.add(this.down);
                    }
                }
                if (this.resetKey != null && !this.resetKey.isNull() && this.resetCommand.length() > 0) {
                    arrayList.add(new KeyCommand(this.resetCommand, this.resetKey, gamePiece, (TranslatablePiece)this));
                }
                if (this.rndKey != null && !this.rndKey.isNull() && this.rndText.length() > 0) {
                    arrayList.add(new KeyCommand(this.rndText, this.rndKey, gamePiece, (TranslatablePiece)this));
                }
            }
            this.commands = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        if (this.up != null) {
            this.up.setEnabled(this.loopLevels || Math.abs(this.value) < this.imageName.length);
        }
        if (this.down != null) {
            this.down.setEnabled(this.loopLevels || Math.abs(this.value) > 1);
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        ChangeTracker changeTracker = new ChangeTracker(this);
        if (this.activateKeyStroke.equals(keyStroke) && this.nValues > 0 && !this.alwaysActive) {
            this.value = -this.value;
        }
        if (!this.followProperty) {
            if (this.increaseKeyStroke.equals(keyStroke)) {
                this.doIncrease();
            }
            if (this.decreaseKeyStroke.equals(keyStroke)) {
                this.doDecrease();
            }
            if (this.resetKey != null && this.resetKey.equals(keyStroke)) {
                GamePiece gamePiece = Decorator.getOutermost(this);
                String string = this.resetLevel.getText(gamePiece);
                try {
                    int n = Integer.parseInt(string);
                    this.setValue(Math.abs(n) - 1);
                    this.setActive(n > 0);
                }
                catch (NumberFormatException numberFormatException) {
                    Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), this.resetLevel.debugInfo(string, "resetLevel"), numberFormatException);
                }
            }
            if (this.rndKey != null && this.rndKey.equals(keyStroke)) {
                int n = 0;
                n = GameModule.getGameModule().getRNG().nextInt(this.nValues) + 1;
                this.value = this.value > 0 ? n : -n;
            }
        }
        return changeTracker.isChanged() ? changeTracker.getChangeCommand() : null;
    }

    protected void doIncrease() {
        int n = Math.abs(this.value);
        if (++n > this.nValues) {
            n = this.loopLevels ? 1 : this.nValues;
        }
        this.value = this.value > 0 ? n : -n;
    }

    protected void doDecrease() {
        int n = Math.abs(this.value);
        if (--n < 1) {
            n = this.loopLevels ? this.nValues : 1;
        }
        this.value = this.value > 0 ? n : -n;
    }

    @Deprecated
    protected Image getCurrentImage() throws IOException {
        if (this.value <= 0 || this.imageName[this.value - 1] == null || this.imageName[this.value - 1].length() == 0 || this.imagePainter[this.value - 1] == null || this.imagePainter[this.value - 1].getSource() == null) {
            return null;
        }
        return this.imagePainter[this.value - 1].getSource().getImage();
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle rectangle = this.piece.boundingBox();
        if (this.value > 0) {
            rectangle.add(this.getCurrentImageBounds());
        }
        return rectangle;
    }

    public Rectangle getCurrentImageBounds() {
        if (this.value > 0) {
            int n = this.value - 1;
            if (n >= this.size.length) {
                return new Rectangle();
            }
            if (this.size[n] == null) {
                if (this.imagePainter[n] != null) {
                    this.size[n] = ImageUtils.getBounds(this.imagePainter[n].getImageSize());
                    this.size[n].translate(this.xOff, this.yOff);
                } else {
                    this.size[n] = new Rectangle();
                }
            }
            return this.size[n];
        }
        return new Rectangle();
    }

    @Override
    public Shape getShape() {
        Shape shape = this.piece.getShape();
        if (this.value > 0 && !this.drawUnderneathWhenSelected) {
            Rectangle rectangle = this.getCurrentImageBounds();
            if (shape.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return shape;
            }
            Area area = new Area(shape);
            if (!rectangle.equals(this.lastBounds)) {
                this.lastShape = new Area(rectangle);
                this.lastBounds = new Rectangle(rectangle);
            }
            area.add(this.lastShape);
            return area;
        }
        return shape;
    }

    @Override
    public String getDescription() {
        String string = this.name;
        if ((this.name == null || this.name.length() == 0) && this.imageName.length > 0 && this.imageName[0] != null && this.imageName[0].length() > 0) {
            string = this.imageName[0];
        }
        if (string == null || string.length() == 0) {
            return "Layer";
        }
        return "Layer - " + string;
    }

    @Override
    public Object getProperty(Object object) {
        if (object.equals(this.name + IMAGE)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.imageName[Math.abs(this.value) - 1];
            }
            return "";
        }
        if (object.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.commonName[Math.abs(this.value) - 1]);
            }
            return "";
        }
        if (object.equals(this.name + LEVEL)) {
            this.checkPropertyLevel();
            return String.valueOf(this.value);
        }
        if (object.equals(this.name + ACTIVE)) {
            return String.valueOf(this.isActive());
        }
        if (object.equals("visibleState")) {
            this.checkPropertyLevel();
            String string = String.valueOf(super.getProperty(object));
            string = string + this.value;
            if (this.drawUnderneathWhenSelected) {
                string = string + this.getProperty("Selected");
            }
            return string;
        }
        return super.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if (object.equals(this.name + IMAGE) || object.equals(this.name + LEVEL) || object.equals(this.name + ACTIVE) || object.equals("visibleState")) {
            return this.getProperty(object);
        }
        if (object.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.getLocalizedCommonName(Math.abs(this.value) - 1));
            }
            return "";
        }
        return super.getLocalizedProperty(object);
    }

    protected String strip(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("+")) {
            return string.substring(1);
        }
        if (string.endsWith("+")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected String getCommonName(boolean bl, int n) {
        return bl ? this.getLocalizedCommonName(n) : this.commonName[n];
    }

    protected String getLocalizedCommonName(int n) {
        String string = this.commonName[n];
        if (string == null) {
            return null;
        }
        String string2 = this.getTranslation(this.strip(string));
        if (string.startsWith("+")) {
            return "+" + string2;
        }
        if (string.endsWith("+")) {
            return string2 + "+";
        }
        return string2;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Layer.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public int getVersion() {
        return this.version;
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece gamePiece, KeyStroke keyStroke, boolean bl) {
        Embellishment embellishment = (Embellishment)Decorator.getDecorator(gamePiece, Embellishment.class);
        while (embellishment != null) {
            for (int i = 0; i < embellishment.activateKey.length(); ++i) {
                if (!keyStroke.equals(KeyStroke.getKeyStroke((int)embellishment.activateKey.charAt(i), embellishment.activateModifiers))) continue;
                if (bl && embellishment.isActive()) {
                    return embellishment;
                }
                if (bl || embellishment.isActive()) break;
                return embellishment;
            }
            embellishment = (Embellishment)Decorator.getDecorator(embellishment.piece, Embellishment.class);
        }
        return null;
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece gamePiece, NamedKeyStroke namedKeyStroke, boolean bl) {
        return Embellishment.getLayerWithMatchingActivateCommand(gamePiece, namedKeyStroke.getKeyStroke(), bl);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name + IMAGE);
        arrayList.add(this.name + LEVEL);
        arrayList.add(this.name + ACTIVE);
        arrayList.add(this.name + NAME);
        return arrayList;
    }

    @Override
    public PieceI18nData getI18nData() {
        String string;
        PieceI18nData pieceI18nData = new PieceI18nData(this);
        String string2 = string = this.name.length() > 0 ? this.name + ": " : "";
        if (this.activateKey.length() > 0) {
            pieceI18nData.add(this.activateCommand, string + "Activate command");
        }
        if (!this.followProperty) {
            pieceI18nData.add(this.upCommand, string + "Increase command");
            pieceI18nData.add(this.downCommand, string + "Decrease command");
            pieceI18nData.add(this.resetCommand, string + "Reset command");
            pieceI18nData.add(this.rndText, string + "Random command");
        }
        for (int i = 0; i < this.commonName.length; ++i) {
            pieceI18nData.add(this.strip(this.commonName[i]), string + "Level " + (i + 1) + " name");
        }
        return pieceI18nData;
    }

    protected static class Ed
    implements PieceEditor {
        private MultiImagePicker images;
        private StringConfigurer activateCommand;
        private StringConfigurer upCommand;
        private StringConfigurer downCommand;
        private StringConfigurer rndCommand;
        private JTextField xOffInput = new JTextField(2);
        private JTextField yOffInput = new JTextField(2);
        private JTextField levelNameInput = new JTextField(10);
        private JRadioButton prefix = new JRadioButton("is prefix");
        private JRadioButton suffix = new JRadioButton("is suffix");
        private JCheckBox drawUnderneath = new JCheckBox("Underneath when highlighted?");
        private FormattedExpressionConfigurer resetLevel = new FormattedExpressionConfigurer(null, "Reset to level:  ");
        private StringConfigurer resetCommand;
        private JCheckBox loop = new JCheckBox("Loop through levels?");
        private JPanel controls;
        private List<String> names;
        private List<Integer> isPrefix;
        private static final Integer NEITHER = 0;
        private static final Integer PREFIX = 1;
        private static final Integer SUFFIX = 2;
        private BooleanConfigurer followConfig;
        private PropertyNameExpressionConfigurer propertyConfig;
        private IntConfigurer firstLevelConfig;
        private StringConfigurer nameConfig;
        private JButton up;
        private JButton down;
        private int version;
        private BooleanConfigurer alwaysActiveConfig;
        private NamedHotKeyConfigurer activateConfig;
        private NamedHotKeyConfigurer increaseConfig;
        private NamedHotKeyConfigurer decreaseConfig;
        private NamedHotKeyConfigurer resetConfig;
        private NamedHotKeyConfigurer rndKeyConfig;
        private JLabel activateLabel;
        private JLabel increaseLabel;
        private JLabel decreaseLabel;
        private JLabel resetLabel;
        private JLabel rndLabel;
        private JLabel actionLabel;
        private JLabel menuLabel;
        private JLabel keyLabel;
        private JLabel optionLabel;

        public Ed(Embellishment embellishment) {
            this.version = embellishment.version;
            this.controls = new JPanel();
            this.controls.setLayout(new MigLayout("hidemode 2,fillx", "[]rel[]rel[]rel[]"));
            this.nameConfig = new StringConfigurer(null, "Name: ", embellishment.getName());
            this.controls.add(this.nameConfig.getControls(), "span 4,wrap,growx");
            this.alwaysActiveConfig = new BooleanConfigurer(null, "Always active?", embellishment.alwaysActive);
            this.alwaysActiveConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.showHideFields();
                }
            });
            this.controls.add(this.alwaysActiveConfig.getControls(), "span 2");
            this.controls.add((Component)this.drawUnderneath, "span 2,wrap");
            this.controls.add((Component)this.loop, "span 2");
            Box box = Box.createHorizontalBox();
            this.xOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.xOffInput.setText("0");
            this.yOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.yOffInput.setText("0");
            box.add(new JLabel("Offset: "));
            box.add(this.xOffInput);
            box.add(new JLabel(","));
            box.add(this.yOffInput);
            this.controls.add((Component)box, "span 2,wrap");
            this.followConfig = new BooleanConfigurer(null, "Levels follow expression value?");
            this.controls.add(this.followConfig.getControls(), "span 2");
            Box box2 = Box.createHorizontalBox();
            this.propertyConfig = new PropertyNameExpressionConfigurer(null, "Follow Expression:  ");
            box2.add(this.propertyConfig.getControls());
            this.firstLevelConfig = new IntConfigurer(null, " Level 1 = ", (Integer)embellishment.firstLevelValue);
            box2.add(this.firstLevelConfig.getControls());
            this.controls.add((Component)box2, "span 2,wrap");
            this.followConfig.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.showHideFields();
                }
            });
            this.actionLabel = new JLabel("Action");
            Font font = this.actionLabel.getFont();
            Font font2 = new Font(font.getFamily(), 1, font.getSize());
            this.actionLabel.setFont(font2);
            this.controls.add(this.actionLabel);
            this.menuLabel = new JLabel("Menu Command");
            this.menuLabel.setFont(font2);
            this.controls.add((Component)this.menuLabel, "align center");
            this.keyLabel = new JLabel("Key");
            this.keyLabel.setFont(font2);
            this.controls.add((Component)this.keyLabel, "align center");
            this.optionLabel = new JLabel("Option");
            this.optionLabel.setFont(font2);
            this.controls.add((Component)this.optionLabel, "align center,wrap");
            this.activateConfig = new NamedHotKeyConfigurer(null, "", embellishment.activateKeyStroke);
            this.increaseConfig = new NamedHotKeyConfigurer(null, "", embellishment.increaseKeyStroke);
            this.decreaseConfig = new NamedHotKeyConfigurer(null, "", embellishment.decreaseKeyStroke);
            this.resetConfig = new NamedHotKeyConfigurer(null, "", embellishment.resetKey);
            this.rndKeyConfig = new NamedHotKeyConfigurer(null, "", embellishment.rndKey);
            this.activateLabel = new JLabel("Activate Layer");
            this.controls.add(this.activateLabel);
            this.activateCommand = new StringConfigurer(null, "", embellishment.activateCommand);
            this.controls.add(this.activateCommand.getControls(), "align center");
            this.controls.add(this.activateConfig.getControls(), "wrap");
            this.increaseLabel = new JLabel("Increase Level");
            this.controls.add(this.increaseLabel);
            this.upCommand = new StringConfigurer(null, "", embellishment.upCommand);
            this.controls.add(this.upCommand.getControls(), "align center");
            this.controls.add(this.increaseConfig.getControls(), "wrap");
            this.decreaseLabel = new JLabel("Decrease Level");
            this.controls.add(this.decreaseLabel);
            this.downCommand = new StringConfigurer(null, "", embellishment.downCommand);
            this.controls.add(this.downCommand.getControls(), "align center");
            this.controls.add(this.decreaseConfig.getControls(), "wrap");
            this.resetLabel = new JLabel("Reset to Level");
            this.controls.add(this.resetLabel);
            this.resetCommand = new StringConfigurer(null, "", embellishment.resetCommand);
            this.controls.add(this.resetCommand.getControls(), "align center");
            this.controls.add(this.resetConfig.getControls());
            this.controls.add(this.resetLevel.getControls(), "wrap");
            this.rndLabel = new JLabel("Randomize");
            this.controls.add(this.rndLabel);
            this.rndCommand = new StringConfigurer(null, "", embellishment.rndText);
            this.controls.add(this.rndCommand.getControls(), "align center");
            this.controls.add(this.rndKeyConfig.getControls(), "wrap");
            this.images = this.getImagePicker();
            this.images.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Ed.this.setUpDownEnabled();
                }
            });
            this.controls.add((Component)this.images, "span 4,split,grow");
            this.up = new JButton(IconFactory.getIcon("go-up", 0));
            this.up.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.moveSelectedUp();
                }
            });
            this.down = new JButton(IconFactory.getIcon("go-down", 0));
            this.down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.moveSelectedDown();
                }
            });
            Box box3 = Box.createVerticalBox();
            box3.add(Box.createVerticalGlue());
            box3.add(this.up);
            box3.add(this.down);
            box3.add(Box.createVerticalGlue());
            this.controls.add((Component)box3, "wrap");
            Box box4 = Box.createHorizontalBox();
            box4.add(new JLabel("Level Name:  "));
            this.levelNameInput.setMaximumSize(this.levelNameInput.getPreferredSize());
            this.levelNameInput.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    Ed.this.changeLevelName();
                }
            });
            box4.add(this.levelNameInput);
            this.controls.add((Component)box4, "span 2,growx");
            box4 = Box.createHorizontalBox();
            this.prefix.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Ed.this.prefix.isSelected()) {
                        Ed.this.suffix.setSelected(false);
                    }
                    Ed.this.changeLevelName();
                }
            });
            this.suffix.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Ed.this.suffix.isSelected()) {
                        Ed.this.prefix.setSelected(false);
                    }
                    Ed.this.changeLevelName();
                }
            });
            box4.add(this.prefix);
            box4.add(this.suffix);
            this.controls.add((Component)box4, "span 2,center,wrap");
            JPanel jPanel = new JPanel(new MigLayout("ins 0", "[grow 1]rel[grow 1]"));
            JButton jButton = new JButton("Add Level");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.names.add(null);
                    Ed.this.isPrefix.add(null);
                    Ed.this.images.addEntry();
                }
            });
            jPanel.add((Component)jButton, "growx");
            jButton = new JButton("Remove Level");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Ed.this.images.getList().getSelectedIndex();
                    if (n >= 0) {
                        Ed.this.names.remove(n);
                        Ed.this.isPrefix.remove(n);
                        Ed.this.images.removeEntryAt(n);
                    }
                }
            });
            jPanel.add((Component)jButton, "growx");
            this.controls.add((Component)jPanel, "span 4,center,growx,wrap");
            this.images.getList().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Ed.this.updateLevelName();
                }
            });
            this.showHideFields();
            this.reset(embellishment);
        }

        protected void moveSelectedUp() {
            int n = this.images.getList().getSelectedIndex();
            int n2 = this.images.getList().getModel().getSize();
            if (n2 > 1 && n > 0) {
                this.swap(n, n - 1);
            }
        }

        protected void moveSelectedDown() {
            int n = this.images.getList().getSelectedIndex();
            int n2 = this.images.getList().getModel().getSize();
            if (n2 > 1 && n < n2 - 1) {
                this.swap(n, n + 1);
            }
        }

        protected void swap(int n, int n2) {
            String string = this.names.get(n);
            this.names.set(n, this.names.get(n2));
            this.names.set(n2, string);
            Integer n3 = this.isPrefix.get(n);
            this.isPrefix.set(n, this.isPrefix.get(n2));
            this.isPrefix.set(n2, n3);
            this.images.swap(n, n2);
        }

        protected void setUpDownEnabled() {
            int n = this.images.getList().getSelectedIndex();
            int n2 = this.images.getList().getModel().getSize();
            this.up.setEnabled(n2 > 1 && n > 0);
            this.down.setEnabled(n2 > 1 && n < n2 - 1);
        }

        protected void showHideFields() {
            boolean bl = this.alwaysActiveConfig.getValueBoolean();
            if (bl) {
                this.activateLabel.setVisible(false);
                this.activateCommand.getControls().setVisible(false);
                this.activateConfig.getControls().setVisible(false);
            } else {
                this.activateLabel.setVisible(true);
                this.activateCommand.getControls().setVisible(true);
                this.activateConfig.getControls().setVisible(true);
            }
            boolean bl2 = this.followConfig.booleanValue() == false;
            this.loop.setEnabled(bl2);
            this.propertyConfig.getControls().setVisible(!bl2);
            this.firstLevelConfig.getControls().setVisible(!bl2);
            this.increaseLabel.setVisible(bl2);
            this.upCommand.getControls().setVisible(bl2);
            this.increaseConfig.getControls().setVisible(bl2);
            this.decreaseLabel.setVisible(bl2);
            this.downCommand.getControls().setVisible(bl2);
            this.decreaseConfig.getControls().setVisible(bl2);
            this.resetLabel.setVisible(bl2);
            this.resetCommand.getControls().setVisible(bl2);
            this.resetConfig.getControls().setVisible(bl2);
            this.resetLevel.getControls().setVisible(bl2);
            this.rndLabel.setVisible(bl2);
            this.rndCommand.getControls().setVisible(bl2);
            this.rndKeyConfig.getControls().setVisible(bl2);
            boolean bl3 = !bl || bl2;
            this.actionLabel.setVisible(bl3);
            this.menuLabel.setVisible(bl3);
            this.keyLabel.setVisible(bl3);
            this.optionLabel.setVisible(bl3);
            Decorator.repack(this.controls);
        }

        private void updateLevelName() {
            int n = this.images.getList().getSelectedIndex();
            if (n < 0) {
                this.levelNameInput.setText(null);
            } else {
                this.levelNameInput.setText(this.names.get(n));
                this.prefix.setSelected(PREFIX.equals(this.isPrefix.get(n)));
                this.suffix.setSelected(SUFFIX.equals(this.isPrefix.get(n)));
            }
        }

        private void changeLevelName() {
            int n = this.images.getList().getSelectedIndex();
            if (n >= 0) {
                String string = this.levelNameInput.getText();
                this.names.set(n, string);
                if (this.prefix.isSelected()) {
                    this.isPrefix.set(n, PREFIX);
                } else if (this.suffix.isSelected()) {
                    this.isPrefix.set(n, SUFFIX);
                } else {
                    this.isPrefix.set(n, NEITHER);
                }
            } else if (n == 0) {
                this.names.set(n, null);
                this.isPrefix.set(n, NEITHER);
            }
        }

        protected MultiImagePicker getImagePicker() {
            return new MultiImagePicker();
        }

        public String getState() {
            return this.alwaysActiveConfig.getValueBoolean() ? "1" : "-1";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            for (String string : this.images.getImageNameList()) {
                arrayList.add(string);
                String string2 = this.names.get(n);
                if (string2 != null && string2.length() > 0) {
                    string2 = PREFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder(string2, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(n)) ? new SequenceEncoder("", '+').append(string2).getValue() : new SequenceEncoder(string2, '+').getValue());
                }
                arrayList2.add(string2);
                ++n;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.yOffInput.setText("0");
            }
            sequenceEncoder.append(this.activateCommand.getValueString()).append("").append("").append(this.upCommand.getValueString()).append("").append("").append(this.downCommand.getValueString()).append("").append("").append(this.resetCommand.getValueString()).append(this.resetConfig.getValueString()).append(this.resetLevel.getValueString()).append(this.drawUnderneath.isSelected()).append(this.xOffInput.getText()).append(this.yOffInput.getText()).append(arrayList.toArray(new String[arrayList.size()])).append(arrayList2.toArray(new String[arrayList2.size()])).append(this.loop.isSelected()).append(this.nameConfig.getValueString()).append(this.rndKeyConfig.getValueString()).append(this.rndCommand.getValueString() == null ? "" : this.rndCommand.getValueString().trim()).append(this.followConfig.getValueString()).append(this.propertyConfig.getValueString()).append(this.firstLevelConfig.getValueString()).append(this.version).append(this.alwaysActiveConfig.getValueString()).append(this.activateConfig.getValueString()).append(this.increaseConfig.getValueString()).append(this.decreaseConfig.getValueString());
            return Embellishment.ID + sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }

        public void reset(Embellishment embellishment) {
            this.nameConfig.setValue(embellishment.name);
            this.names = new ArrayList<String>();
            this.isPrefix = new ArrayList<Integer>();
            for (int i = 0; i < embellishment.commonName.length; ++i) {
                String string = embellishment.commonName[i];
                Integer n = NEITHER;
                if (string != null && string.length() > 0) {
                    SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '+');
                    String string2 = decoder.nextToken();
                    if (decoder.hasMoreTokens()) {
                        String string3 = decoder.nextToken();
                        if (string2.length() == 0) {
                            string = string3;
                            n = SUFFIX;
                        } else {
                            string = string2;
                            n = PREFIX;
                        }
                    } else {
                        string = string2;
                    }
                }
                this.names.add(string);
                this.isPrefix.add(n);
            }
            this.alwaysActiveConfig.setValue(embellishment.alwaysActive);
            this.drawUnderneath.setSelected(embellishment.drawUnderneathWhenSelected);
            this.loop.setSelected(embellishment.loopLevels);
            this.images.clear();
            this.activateCommand.setValue(embellishment.activateCommand);
            this.upCommand.setValue(embellishment.upCommand);
            this.downCommand.setValue(embellishment.downCommand);
            this.resetConfig.setValue(embellishment.resetKey);
            this.resetCommand.setValue(embellishment.resetCommand);
            this.resetLevel.setValue(embellishment.resetLevel.getFormat());
            this.xOffInput.setText(String.valueOf(embellishment.xOff));
            this.yOffInput.setText(String.valueOf(embellishment.yOff));
            this.images.setImageList(embellishment.imageName);
            this.followConfig.setValue(embellishment.followProperty);
            this.propertyConfig.setValue(embellishment.propertyName);
            if (this.images.getImageNameList().isEmpty()) {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            }
            this.updateLevelName();
            this.showHideFields();
        }
    }
}

