/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Properties;
import javax.swing.KeyStroke;

public class UsePrototype
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "prototype;";
    private String prototypeName;
    private String lastCachedPrototype;
    private GamePiece prototype;
    private PropertySource properties;
    private String type;

    public UsePrototype() {
        this(ID, null);
    }

    public UsePrototype(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String getDescription() {
        return this.prototypeName != null && this.prototypeName.length() > 0 ? "Prototype - " + this.prototypeName : "Prototype";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("UsePrototype.htm");
    }

    public void mySetType(String string) {
        this.type = string;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(ID.length()), ';');
        this.prototypeName = decoder.nextToken("");
        if (decoder.hasMoreTokens()) {
            final Properties properties = new Properties();
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ',');
            while (decoder2.hasMoreTokens()) {
                SequenceEncoder.Decoder decoder3 = new SequenceEncoder.Decoder(decoder2.nextToken(), '=');
                if (!decoder3.hasMoreTokens()) continue;
                String string2 = decoder3.nextToken();
                if (!decoder3.hasMoreTokens()) continue;
                String string3 = decoder3.nextToken();
                properties.setProperty(string2, string3);
            }
            this.properties = new PropertySource(){

                public Object getProperty(Object object) {
                    return properties.getProperty(String.valueOf(object));
                }

                public Object getLocalizedProperty(Object object) {
                    return this.getProperty(object);
                }
            };
        }
        this.lastCachedPrototype = null;
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    protected KeyCommand[] getKeyCommands() {
        return (KeyCommand[])this.getExpandedInner().getProperty("KeyCommands");
    }

    public void setInner(GamePiece gamePiece) {
        super.setInner(gamePiece);
        this.lastCachedPrototype = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPrototype() {
        PrototypeDefinition prototypeDefinition = PrototypesContainer.getPrototype(this.prototypeName);
        if (prototypeDefinition != null) {
            GamePiece gamePiece = prototypeDefinition.getPiece(this.properties);
            String string = gamePiece.getType();
            if (!string.equals(this.lastCachedPrototype)) {
                this.lastCachedPrototype = string;
                try {
                    RecursionLimiter.startExecution(this);
                    this.prototype = PieceCloner.getInstance().clonePiece(gamePiece);
                    Decorator decorator = (Decorator)Decorator.getInnermost(this.prototype).getProperty("Outer");
                    if (decorator != null) {
                        decorator.setInner(this.piece);
                        this.prototype.setProperty("Outer", this);
                    }
                    this.prototype = null;
                }
                catch (RecursionLimitException recursionLimitException) {
                    RecursionLimiter.infiniteLoop(recursionLimitException);
                    this.prototype = null;
                }
                finally {
                    RecursionLimiter.endExecution();
                }
            }
        } else {
            this.prototype = null;
        }
    }

    public GamePiece getExpandedInner() {
        this.buildPrototype();
        return this.prototype != null ? this.prototype : this.piece;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        return this.type;
    }

    public Command keyEvent(KeyStroke keyStroke) {
        return this.getExpandedInner().keyEvent(keyStroke);
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.getExpandedInner().boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.getExpandedInner().draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.getExpandedInner().getName();
    }

    public Shape getShape() {
        return this.getExpandedInner().getShape();
    }

    public String getPrototypeName() {
        return this.prototypeName;
    }

    public PieceEditor getEditor() {
        return new Editor(this);
    }

    public String getComponentName() {
        return this.piece.getName();
    }

    public String getComponentTypeName() {
        return this.getDescription();
    }

    public static class Editor
    implements PieceEditor {
        private StringConfigurer nameConfig;

        public Editor(UsePrototype usePrototype) {
            this.nameConfig = new StringConfigurer(null, "Prototype name:  ", usePrototype.type.substring(UsePrototype.ID.length()));
        }

        public Component getControls() {
            return this.nameConfig.getControls();
        }

        public String getState() {
            return "";
        }

        public String getType() {
            return UsePrototype.ID + this.nameConfig.getValueString();
        }
    }
}

