/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.WriteErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class UsernameAndPasswordDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public UsernameAndPasswordDialog(Frame frame) {
        super(frame, "Set Your Username and Password", true);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        final StringConfigurer stringConfigurer = new StringConfigurer(null, Resources.getString("WizardSupport.RealName"));
        final PasswordConfigurer passwordConfigurer = new PasswordConfigurer(null, Resources.getString("WizardSupport.Password"));
        final PasswordConfigurer passwordConfigurer2 = new PasswordConfigurer(null, Resources.getString("WizardSupport.ConfirmPassword"));
        Component component = stringConfigurer.getControls();
        Component component2 = passwordConfigurer.getControls();
        Component component3 = passwordConfigurer2.getControls();
        JLabel jLabel = new JLabel(Resources.getString("WizardSupport.NameAndPasswordDetails"));
        final JLabel jLabel2 = new JLabel(Resources.getString("WizardSupport.EnterNameAndPassword"));
        final JButton jButton = new JButton(Resources.getString("General.ok"));
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Prefs prefs = GameModule.getGameModule().getPrefs();
                prefs.getOption("RealName").setValue(stringConfigurer.getValueString());
                prefs.getOption("SecretName").setValue(passwordConfigurer.getValueString());
                try {
                    prefs.write();
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, prefs.getFile());
                }
                UsernameAndPasswordDialog.this.dispose();
            }
        });
        JButton jButton2 = new JButton(Resources.getString("General.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UsernameAndPasswordDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutocreateGaps(true);
        groupLayout.setAutocreateContainerGaps(true);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1, true).add(component).add(component2).add(component3).add((Component)jLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, Integer.MAX_VALUE).add((Component)jLabel2).add(0, 0, Integer.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, Integer.MAX_VALUE).add((Component)jButton).add((Component)jButton2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add(component).add(component2).add(component3).add((Component)jLabel).add((Component)jLabel2).addPreferredGap(1, -1, Integer.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3, false).add((Component)jButton).add((Component)jButton2)));
        groupLayout.linkSize(new Component[]{jButton, jButton2});
        this.add(jPanel);
        this.pack();
        this.setMinimumSize(this.getSize());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (stringConfigurer.getValue() == null || "".equals(stringConfigurer.getValue())) {
                    if (passwordConfigurer.getValue() == null || "".equals(passwordConfigurer.getValue())) {
                        jLabel2.setText(Resources.getString("WizardSupport.EnterNameAndPassword"));
                    } else {
                        jLabel2.setText(Resources.getString("WizardSupport.EnterYourName"));
                    }
                    jLabel2.setForeground(Color.black);
                    jButton.setEnabled(false);
                } else if (passwordConfigurer.getValue() == null || "".equals(passwordConfigurer.getValue())) {
                    jLabel2.setText(Resources.getString("WizardSupport.EnterYourPassword"));
                    jLabel2.setForeground(Color.black);
                    jButton.setEnabled(false);
                } else if (passwordConfigurer2.getValue() == null || "".equals(passwordConfigurer2.getValue())) {
                    jLabel2.setText("Please confirm your password");
                    jLabel2.setForeground(Color.black);
                    jButton.setEnabled(false);
                } else if (!passwordConfigurer.getValue().equals(passwordConfigurer2.getValue())) {
                    jLabel2.setText(Resources.getString("WizardSupport.PasswordsDontMatch"));
                    jLabel2.setForeground(Color.red);
                    jButton.setEnabled(false);
                } else {
                    jLabel2.setText("");
                    jLabel2.setForeground(Color.black);
                    jButton.setEnabled(true);
                }
            }
        };
        stringConfigurer.addPropertyChangeListener(propertyChangeListener);
        passwordConfigurer.addPropertyChangeListener(propertyChangeListener);
        passwordConfigurer2.addPropertyChangeListener(propertyChangeListener);
    }
}

