/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.image.PNGDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PNGChunkSkipInputStream
extends InputStream {
    protected final Set<Integer> skip;
    protected final DataInputStream in;
    protected ByteArrayInputStream bin;
    protected final ByteArrayOutputStream bout;
    protected final DataOutputStream out;
    protected boolean seenIEND = false;

    public PNGChunkSkipInputStream(Set<Integer> set, InputStream inputStream) throws IOException {
        this.skip = set;
        this.in = new DataInputStream(inputStream);
        if (!PNGDecoder.decodeSignature(this.in)) {
            throw new IOException();
        }
        this.bout = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.bout);
        this.out.writeLong(-8552249625308161526L);
        this.flipBuffer();
    }

    @Override
    public int available() throws IOException {
        return this.bin.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        return this.read(byArray) == -1 ? -1 : byArray[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bin.read(byArray, n, n2);
        if (n3 == -1 && !this.seenIEND) {
            PNGDecoder.Chunk chunk;
            do {
                chunk = PNGDecoder.decodeChunk(this.in);
                if (chunk.type != 1229278788) continue;
                this.seenIEND = true;
            } while (this.skip.contains(chunk.type));
            this.encodeChunk(chunk);
            this.flipBuffer();
            n3 = this.bin.read(byArray, n, n2);
        }
        return n3;
    }

    protected void encodeChunk(PNGDecoder.Chunk chunk) throws IOException {
        this.out.writeInt(chunk.data.length);
        this.out.writeInt(chunk.type);
        this.out.write(chunk.data);
        this.out.writeInt((int)chunk.crc);
    }

    protected void flipBuffer() throws IOException {
        this.out.flush();
        this.bin = new ByteArrayInputStream(this.bout.toByteArray());
        this.bout.reset();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public long skip(long l) throws IOException {
        throw new IOException();
    }
}

