/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.AutoCompleteFocusAdapter;
import org.jdesktop.swingx.autocomplete.AutoCompleteKeyAdapter;
import org.jdesktop.swingx.autocomplete.AutoCompletePropertyChangeListener;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ListAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.autocomplete.TextComponentAdaptor;
import org.jdesktop.swingx.autocomplete.workarounds.MacOSXPopupLocationFix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteDecorator {
    static Object errorFeedbackAction = new TextAction("provide-error-feedback"){

        public void actionPerformed(ActionEvent e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(e));
        }
    };

    private static void removeFocusListener(Component c) {
        FocusListener[] listeners;
        for (FocusListener l : listeners = c.getFocusListeners()) {
            if (!(l instanceof AutoCompleteFocusAdapter)) continue;
            c.removeFocusListener(l);
        }
    }

    private static void removeKeyListener(Component c) {
        KeyListener[] listeners;
        for (KeyListener l : listeners = c.getKeyListeners()) {
            if (!(l instanceof AutoCompleteKeyAdapter)) continue;
            c.removeKeyListener(l);
        }
    }

    private static void removePropertyChangeListener(Component c) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = c.getPropertyChangeListeners("editor")) {
            if (!(l instanceof AutoCompletePropertyChangeListener)) continue;
            c.removePropertyChangeListener("editor", l);
        }
    }

    public static void decorate(JTextComponent textComponent, List<?> items, boolean strictMatching) {
        AutoCompleteDecorator.decorate(textComponent, items, strictMatching, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JTextComponent textComponent, List<?> items, boolean strictMatching, ObjectToStringConverter stringConverter) {
        TextComponentAdaptor adaptor = new TextComponentAdaptor(textComponent, items);
        AutoCompleteDocument document = new AutoCompleteDocument(adaptor, strictMatching, stringConverter, textComponent.getDocument());
        AutoCompleteDecorator.decorate(textComponent, document, adaptor);
    }

    public static void decorate(JList list, JTextComponent textComponent) {
        AutoCompleteDecorator.decorate(list, textComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JList list, JTextComponent textComponent, ObjectToStringConverter stringConverter) {
        ListAdaptor adaptor = new ListAdaptor(list, textComponent, stringConverter);
        AutoCompleteDocument document = new AutoCompleteDocument(adaptor, true, stringConverter, textComponent.getDocument());
        AutoCompleteDecorator.decorate(textComponent, document, adaptor);
    }

    public static void decorate(JComboBox comboBox) {
        AutoCompleteDecorator.decorate(comboBox, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(final JComboBox comboBox, final ObjectToStringConverter stringConverter) {
        boolean strictMatching = !comboBox.isEditable();
        comboBox.setEditable(true);
        MacOSXPopupLocationFix.install(comboBox);
        JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
        final ComboBoxAdaptor adaptor = new ComboBoxAdaptor(comboBox);
        final AutoCompleteDocument document = new AutoCompleteDocument(adaptor, strictMatching, stringConverter, editorComponent.getDocument());
        AutoCompleteDecorator.decorate(editorComponent, document, adaptor);
        AutoCompleteDecorator.removeKeyListener(editorComponent);
        final AutoCompleteKeyAdapter keyListener = new AutoCompleteKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isActionKey()) {
                    return;
                }
                if (comboBox.isDisplayable() && !comboBox.isPopupVisible()) {
                    int keyCode = keyEvent.getKeyCode();
                    if (keyCode == 16 || keyCode == 17 || keyCode == 18) {
                        return;
                    }
                    if (keyCode == 27) {
                        return;
                    }
                    comboBox.setPopupVisible(true);
                }
            }
        };
        editorComponent.addKeyListener(keyListener);
        if (stringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
            comboBox.setEditor(new AutoCompleteComboBoxEditor(comboBox.getEditor(), stringConverter));
        }
        AutoCompleteDecorator.removePropertyChangeListener(comboBox);
        comboBox.addPropertyChangeListener("editor", new AutoCompletePropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ComboBoxEditor editor = (ComboBoxEditor)e.getOldValue();
                if (editor != null && editor.getEditorComponent() != null) {
                    AutoCompleteDecorator.removeKeyListener(editor.getEditorComponent());
                }
                if ((editor = (ComboBoxEditor)e.getNewValue()) != null && editor.getEditorComponent() != null) {
                    if (!(editor instanceof AutoCompleteComboBoxEditor) && stringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
                        comboBox.setEditor(new AutoCompleteComboBoxEditor(editor, stringConverter));
                    } else {
                        AutoCompleteDecorator.decorate((JTextComponent)editor.getEditorComponent(), document, adaptor);
                        editor.getEditorComponent().addKeyListener(keyListener);
                    }
                }
            }
        });
    }

    public static void decorate(JTextComponent textComponent, AutoCompleteDocument document, final AbstractAutoCompleteAdaptor adaptor) {
        textComponent.setDocument(document);
        AutoCompleteDecorator.removeFocusListener(textComponent);
        textComponent.addFocusListener(new AutoCompleteFocusAdapter(){

            public void focusGained(FocusEvent e) {
                adaptor.markEntireText();
            }
        });
        InputMap editorInputMap = textComponent.getInputMap();
        if (document.isStrictMatching()) {
            editorInputMap.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            editorInputMap.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            editorInputMap.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            ActionMap editorActionMap = textComponent.getActionMap();
            editorInputMap.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
            editorActionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(editorActionMap.get("delete-previous"), editorActionMap.get("selection-backward"), adaptor));
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        Action backspace;
        Action selectionBackward;
        AbstractAutoCompleteAdaptor adaptor;

        public NonStrictBackspaceAction(Action backspace, Action selectionBackward, AbstractAutoCompleteAdaptor adaptor) {
            super("nonstrict-backspace");
            this.backspace = backspace;
            this.selectionBackward = selectionBackward;
            this.adaptor = adaptor;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(e);
            } else {
                this.backspace.actionPerformed(e);
            }
        }
    }
}

