/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import edu.stanford.ejalbert.BrowserLauncherRunner;
import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherDefaultErrorHandler;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import edu.stanford.ejalbert.launching.BrowserLaunchingFactory;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import java.util.List;
import net.sf.wraplog.AbstractLogger;
import net.sf.wraplog.NoneLogger;

public class BrowserLauncher {
    public static final String BROWSER_SYSTEM_PROPERTY = "edu.stanford.ejalbert.preferred.browser";
    public static final String WINDOWS_BROWSER_DISC_POLICY_PROPERTY = "win.browser.disc.policy";
    public static final String WINDOWS_BROWSER_DISC_POLICY_DISK = "disk";
    public static final String WINDOWS_BROWSER_DISC_POLICY_REGISTRY = "registry";
    private final IBrowserLaunching launching;
    private AbstractLogger logger;
    private BrowserLauncherErrorHandler errorHandler;

    public BrowserLauncher() throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        this(null, null);
    }

    public BrowserLauncher(AbstractLogger logger) throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        this(logger, null);
    }

    public BrowserLauncher(AbstractLogger logger, BrowserLauncherErrorHandler errorHandler) throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        if (logger == null) {
            logger = new NoneLogger();
        }
        this.logger = logger;
        if (errorHandler == null) {
            errorHandler = new BrowserLauncherDefaultErrorHandler();
        }
        this.errorHandler = errorHandler;
        this.launching = this.initBrowserLauncher();
    }

    private IBrowserLaunching initBrowserLauncher() throws UnsupportedOperatingSystemException, BrowserLaunchingInitializingException {
        if (this.logger == null) {
            throw new IllegalArgumentException("the logger cannot be null at this point.");
        }
        IBrowserLaunching launching = BrowserLaunchingFactory.createSystemBrowserLaunching(this.logger);
        launching.initialize();
        return launching;
    }

    public static void openURL(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        BrowserLauncher launcher = new BrowserLauncher(null);
        launcher.openURLinBrowser(urlString);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java -jar BrowserLauncher.jar url_value");
        } else {
            try {
                BrowserLauncher launcher = new BrowserLauncher(null);
                launcher.openURLinBrowser(args[0]);
            }
            catch (BrowserLaunchingInitializingException ex) {
                ex.printStackTrace();
            }
            catch (UnsupportedOperatingSystemException ex) {
                ex.printStackTrace();
            }
        }
    }

    public AbstractLogger getLogger() {
        return this.logger;
    }

    public List getBrowserList() {
        return this.launching.getBrowserList();
    }

    public void openURLinBrowser(String urlString) {
        BrowserLauncherRunner runner = new BrowserLauncherRunner(this.launching, urlString, this.logger, this.errorHandler);
        Thread launcherThread = new Thread(runner);
        launcherThread.start();
    }

    public void openURLinBrowser(String browser, String urlString) {
        BrowserLauncherRunner runner = new BrowserLauncherRunner(this.launching, browser, urlString, this.logger, this.errorHandler);
        Thread launcherThread = new Thread(runner);
        launcherThread.start();
    }

    public void openURLinBrowser(List browsers, String urlString) {
        BrowserLauncherRunner runner = new BrowserLauncherRunner(this.launching, browsers, urlString, this.logger, this.errorHandler);
        Thread launcherThread = new Thread(runner);
        launcherThread.start();
    }

    public boolean getNewWindowPolicy() {
        return this.launching.getNewWindowPolicy();
    }

    public void setNewWindowPolicy(boolean forceNewWindow) {
        this.launching.setNewWindowPolicy(forceNewWindow);
    }
}

