/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.AboutScreen;
import VASSAL.build.module.documentation.BrowserHelpFile;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.Tutorial;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.MenuManager;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Documentation
extends AbstractConfigurable {
    public JMenu getHelpMenu() {
        JMenuBar jMenuBar = MenuManager.getInstance().getMenuBarFor(GameModule.getGameModule().getFrame());
        return jMenuBar.getMenu(jMenuBar.getMenuCount() - 1);
    }

    @Override
    public void build(Element element) {
        if (element == null) {
            AboutScreen aboutScreen = new AboutScreen();
            aboutScreen.setAttribute("title", Resources.getString("Documentation.about_module"));
            aboutScreen.setAttribute("fileName", "/images/Splash.png");
            aboutScreen.addTo(this);
            this.add(aboutScreen);
            HelpFile helpFile = new HelpFile();
            helpFile.setAttribute("title", Resources.getString("Documentation.quick_start"));
            helpFile.setAttribute("fileName", "/help/Intro.html");
            helpFile.setAttribute("fileType", "resource");
            helpFile.addTo(this);
            this.add(helpFile);
        } else {
            super.build(element);
        }
    }

    public static File getDocumentationBaseDir() {
        return Info.getDocDir();
    }

    @Override
    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{BrowserHelpFile.class, AboutScreen.class, Tutorial.class, HelpFile.class};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Documentation.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        File file = Documentation.getDocumentationBaseDir();
        file = new File(file, "ReferenceManual");
        try {
            return new HelpFile(null, new File(file, "HelpMenu.htm"));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
            return null;
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public String getAttributeValueString(String string) {
        return null;
    }
}

