/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.LayoutConfigurer;
import VASSAL.build.module.gamepieceimage.Visualizable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.StringEnum;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePieceLayout
extends AbstractConfigurable
implements Visualizable {
    protected static final String NAME = "name";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String BORDER = "border";
    protected static final String ITEMS = "layout";
    protected static final String N = "Top";
    protected static final String S = "Bottom";
    protected static final String E = "Right";
    protected static final String W = "Left";
    protected static final String NE = "Top Right";
    protected static final String NW = "Top Left";
    protected static final String SE = "Bottom Right";
    protected static final String SW = "Bottom Left";
    protected static final String CENTER = "Center";
    protected static final int POS_L = 15;
    protected static final int POS_R = 85;
    protected static final int POS_T = 15;
    protected static final int POS_B = 85;
    protected static final int POS_C = 50;
    protected static final String BORDER_PLAIN = "Plain";
    protected static final String BORDER_FANCY = "Fancy";
    protected static final String BORDER_3D = "3D";
    protected static final String BORDER_NONE = "None";
    public static final String[] LOCATIONS = new String[]{"Center", "Top", "Bottom", "Right", "Left", "Top Right", "Top Left", "Bottom Right", "Bottom Left"};
    public static final int[] X_POS = new int[]{50, 50, 50, 85, 15, 85, 15, 85, 15};
    public static final int[] Y_POS = new int[]{50, 15, 85, 50, 50, 15, 15, 85, 85};
    protected static Map<String, String> compass = new HashMap<String, String>();
    protected int width = 54;
    protected int height = 54;
    protected String border = "3D";
    protected GamePieceImage imageDefn;
    protected Image visImage;
    protected List<Item> items = new ArrayList<Item>();

    public static String getCompassPoint(String string) {
        return compass.get(string);
    }

    public Point getPosition(Item item) {
        int n;
        int n2;
        String string = GamePieceLayout.getCompassPoint(item.getLocation());
        Dimension dimension = item.getSize();
        switch (string.charAt(string.length() - 1)) {
            case 'E': {
                n2 = this.getLayoutWidth() - dimension.width;
                break;
            }
            case 'W': {
                n2 = 0;
                break;
            }
            default: {
                n2 = this.getLayoutWidth() / 2 - dimension.width / 2;
            }
        }
        switch (string.charAt(0)) {
            case 'N': {
                n = 0;
                break;
            }
            case 'S': {
                n = this.getLayoutHeight() - dimension.height;
                break;
            }
            default: {
                n = this.getLayoutHeight() / 2 - dimension.height / 2;
            }
        }
        return new Point(n2 + item.getXoffset(), n + item.getYoffset());
    }

    public GamePieceLayout() {
        this.name = "";
        this.imageDefn = new GamePieceImage(this);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Counter Width:  ", "Counter Height:  ", "Border Style:  ", ""};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, Integer.class, BorderConfig.class, LayoutConfig.class};
    }

    public boolean isColoredBorder() {
        return this.border.equals(BORDER_PLAIN) || this.border.equals(BORDER_FANCY);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, WIDTH, HEIGHT, BORDER, ITEMS};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.setWidth((Integer)object);
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.setHeight((Integer)object);
        } else if (BORDER.equals(string)) {
            this.border = (String)object;
        } else if (ITEMS.equals(string)) {
            this.decodeItemList((String)object);
        }
        this.invalidate();
        LayoutConfig.refresh();
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (WIDTH.equals(string)) {
            return this.getLayoutWidth() + "";
        }
        if (HEIGHT.equals(string)) {
            return this.getLayoutHeight() + "";
        }
        if (BORDER.equals(string)) {
            return this.border + "";
        }
        if (ITEMS.equals(string)) {
            return this.encodeItemList();
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayouts.htm");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{GamePieceImage.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        this.setAllAttributesUntranslatable();
    }

    public static String getConfigureTypeName() {
        return "Game Piece Layout";
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getLayoutWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getLayoutHeight() {
        return this.height;
    }

    public String getBorder() {
        return this.border;
    }

    public List<Item> getItems() {
        return this.items;
    }

    protected int getItemCount() {
        return this.items.size();
    }

    protected Item getItem(int n) {
        return this.items.get(n);
    }

    protected Item getItem(String string) {
        for (Item item : this.items) {
            if (!item.getConfigureName().equals(string)) continue;
            return item;
        }
        return null;
    }

    protected void removeItem(int n) {
        this.items.remove(n);
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void moveItem(int n, int n2) {
        Item item = this.items.get(n2);
        this.items.set(n2, this.items.get(n));
        this.items.set(n, item);
    }

    @Override
    public void add(Buildable buildable) {
        super.add(buildable);
    }

    @Override
    public void remove(Buildable buildable) {
        super.remove(buildable);
    }

    @Override
    public Image getVisualizerImage() {
        if (this.visImage == null) {
            this.rebuildVisualizerImage();
        }
        return this.visImage;
    }

    public Image buildImage(GamePieceImage gamePieceImage) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(Math.max(this.width, 1), Math.max(this.height, 1));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = gamePieceImage.getBgColor().getColor();
        graphics2D.setColor(color);
        if (this.getBorder().equals(BORDER_3D)) {
            if (color != null) {
                graphics2D.fill3DRect(0, 0, this.width, this.height, true);
            }
        } else {
            if (color != null) {
                graphics2D.fillRect(0, 0, this.width, this.height);
            }
            if (this.getBorder().equals(BORDER_PLAIN) || this.getBorder().equals(BORDER_FANCY)) {
                Color color2 = color == null ? Color.WHITE : color;
                graphics2D.setColor(gamePieceImage.getBorderColor().getColor());
                graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
                graphics2D.drawRect(0, 0, this.width - 1, this.height - 1);
                if (this.getBorder().equals(BORDER_FANCY)) {
                    Color object = new Color(color2.getRed() / 2, color2.getGreen() / 2, color2.getBlue() / 2);
                    Color color3 = new Color(color2.getRed() + (255 - color2.getRed()) / 2, color2.getGreen() + (255 - color2.getGreen()) / 2, color2.getBlue() + (255 - color2.getBlue()) / 2);
                    graphics2D.setColor(color3);
                    graphics2D.drawLine(1, 1, this.width - 3, 1);
                    graphics2D.drawLine(1, 2, 1, this.height - 3);
                    graphics2D.setColor(object);
                    graphics2D.drawLine(this.width - 2, 2, this.width - 2, this.height - 2);
                    graphics2D.drawLine(2, this.height - 2, this.width - 3, this.height - 2);
                }
            }
        }
        for (Item item : this.items) {
            if (item == null) continue;
            item.draw(graphics2D, gamePieceImage);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public void refresh() {
        this.invalidate();
        LayoutConfig.refresh();
    }

    protected void invalidate() {
        for (GamePieceImage gamePieceImage : this.getComponentsOf(GamePieceImage.class)) {
            gamePieceImage.rebuildVisualizerImage();
        }
    }

    protected void decodeItemList(String string) {
        this.items.clear();
        if (string.length() > 0) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
            while (decoder.hasMoreTokens()) {
                Item item = Item.decode(this, decoder.nextToken());
                this.addItem(item);
            }
        }
    }

    protected String encodeItemList() {
        String[] stringArray = new String[this.getItemCount()];
        int n = 0;
        for (Item item : this.items) {
            stringArray[n++] = item.encode();
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder('#');
        sequenceEncoder.append(stringArray);
        return sequenceEncoder.getValue();
    }

    @Override
    public int getVisualizerHeight() {
        return this.getLayoutHeight();
    }

    @Override
    public int getVisualizerWidth() {
        return this.getLayoutWidth();
    }

    @Override
    public void rebuildVisualizerImage() {
        this.visImage = this.buildImage(this.imageDefn);
    }

    public void setImageDefn(GamePieceImage gamePieceImage) {
        this.imageDefn = gamePieceImage;
    }

    public GamePieceImage getGenericDefn(String string) {
        for (Buildable buildable : this.getBuildables()) {
            GamePieceImage gamePieceImage;
            if (!(buildable instanceof GamePieceImage) || !(gamePieceImage = (GamePieceImage)buildable).getConfigureName().equals(string)) continue;
            return gamePieceImage;
        }
        return null;
    }

    static {
        compass.put(N, "N");
        compass.put(S, "S");
        compass.put(E, "E");
        compass.put(W, "W");
        compass.put(NE, "NE");
        compass.put(NW, "NW");
        compass.put(SE, "SE");
        compass.put(SW, "SW");
        compass.put(CENTER, "CENTER");
    }

    public static class BorderConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{GamePieceLayout.BORDER_PLAIN, GamePieceLayout.BORDER_FANCY, GamePieceLayout.BORDER_3D, GamePieceLayout.BORDER_NONE};
        }
    }

    public static class LayoutConfig
    implements ConfigurerFactory {
        protected static LayoutConfigurer configurer;

        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            configurer = new LayoutConfigurer(string, string2, (GamePieceLayout)autoConfigurable);
            return configurer;
        }

        public static void refresh() {
            if (configurer != null) {
                configurer.repack();
            }
        }
    }
}

