/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class PolygonEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Polygon polygon;
    private int selected = -1;
    protected JScrollPane myScroll;

    public PolygonEditor(Polygon polygon) {
        this.polygon = polygon;
        this.reset();
    }

    protected void reset() {
        if (this.polygon == null || this.polygon.npoints == 0) {
            this.setupForCreate();
        } else {
            this.setupForEdit();
        }
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public Polygon clonePolygon() {
        return new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public void setScroll(JScrollPane jScrollPane) {
        this.myScroll = jScrollPane;
    }

    private void setupForCreate() {
        DefineRectangle defineRectangle = new DefineRectangle();
        this.addMouseListener(defineRectangle);
    }

    private void setupForEdit() {
        ModifyPolygon modifyPolygon = new ModifyPolygon();
        this.addMouseListener(modifyPolygon);
        this.addMouseMotionListener(modifyPolygon);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PolygonEditor.this.selected >= 0) {
                    for (int i = PolygonEditor.this.selected; i < ((PolygonEditor)PolygonEditor.this).polygon.npoints - 1; ++i) {
                        ((PolygonEditor)PolygonEditor.this).polygon.xpoints[i] = ((PolygonEditor)PolygonEditor.this).polygon.xpoints[i + 1];
                        ((PolygonEditor)PolygonEditor.this).polygon.ypoints[i] = ((PolygonEditor)PolygonEditor.this).polygon.ypoints[i + 1];
                    }
                    --((PolygonEditor)PolygonEditor.this).polygon.npoints;
                    PolygonEditor.this.selected = -1;
                    PolygonEditor.this.repaint();
                }
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(127, 0), 2);
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(8, 0), 2);
        this.requestFocus();
        this.selected = 2;
        this.repaint();
    }

    public void center(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle.width == 0) {
            rectangle.width = 600;
            rectangle.height = 600;
        }
        int n = point.x - rectangle.width / 2;
        int n2 = point.y - rectangle.height / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.scrollRectToVisible(new Rectangle(n, n2, rectangle.width, rectangle.height));
    }

    public static void reset(Polygon polygon, String string) {
        polygon.reset();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        while (decoder.hasMoreTokens()) {
            String string2 = decoder.nextToken();
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string2, ',');
            if (!decoder2.hasMoreTokens()) continue;
            try {
                int n = Integer.parseInt(decoder2.nextToken().trim());
                if (!decoder2.hasMoreTokens()) continue;
                int n2 = Integer.parseInt(decoder2.nextToken().trim());
                polygon.addPoint(n, n2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static String polygonToString(Polygon polygon) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < polygon.npoints; ++i) {
            stringBuilder.append(Math.round(polygon.xpoints[i])).append(',').append(Math.round(polygon.ypoints[i]));
            if (i >= polygon.npoints - 1) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        if (this.polygon != null && this.polygon.npoints > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.white);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.fill(this.polygon);
            if (this.selected >= 0 && this.selected < this.polygon.xpoints.length) {
                graphics2D.setColor(Color.red);
                int n = this.polygon.xpoints[this.selected];
                int n2 = this.polygon.ypoints[this.selected];
                graphics2D.fillOval(n - 10, n2 - 10, 20, 20);
            }
            graphics2D.setComposite(AlphaComposite.SrcAtop);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawPolygon(this.polygon);
        }
    }

    protected void paintBackground(Graphics graphics) {
        super.paint(graphics);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.add(new PolygonEditor(null));
        jFrame.setSize(500, 500);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    private class DefineRectangle
    extends MouseInputAdapter {
        private DefineRectangle() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            PolygonEditor.this.polygon = new Polygon();
            PolygonEditor.this.polygon.addPoint(mouseEvent.getX(), mouseEvent.getY());
            PolygonEditor.this.polygon.addPoint(mouseEvent.getX(), mouseEvent.getY());
            PolygonEditor.this.polygon.addPoint(mouseEvent.getX(), mouseEvent.getY());
            PolygonEditor.this.polygon.addPoint(mouseEvent.getX(), mouseEvent.getY());
            PolygonEditor.this.addMouseMotionListener(this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ((PolygonEditor)PolygonEditor.this).polygon.xpoints[1] = mouseEvent.getX();
            ((PolygonEditor)PolygonEditor.this).polygon.xpoints[2] = mouseEvent.getX();
            ((PolygonEditor)PolygonEditor.this).polygon.ypoints[2] = mouseEvent.getY();
            ((PolygonEditor)PolygonEditor.this).polygon.ypoints[3] = mouseEvent.getY();
            PolygonEditor.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            PolygonEditor.this.removeMouseListener(this);
            PolygonEditor.this.removeMouseMotionListener(this);
            PolygonEditor.this.setupForEdit();
        }
    }

    private class ModifyPolygon
    extends MouseInputAdapter {
        private ModifyPolygon() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.moveSelectedPoint(mouseEvent);
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.scrollAtEdge(mouseEvent.getPoint(), 15);
            }
            PolygonEditor.this.repaint();
        }

        private void moveSelectedPoint(MouseEvent mouseEvent) {
            if (PolygonEditor.this.selected >= 0 && PolygonEditor.this.selected < ((PolygonEditor)PolygonEditor.this).polygon.xpoints.length) {
                ((PolygonEditor)PolygonEditor.this).polygon.xpoints[((PolygonEditor)PolygonEditor.this).selected] = mouseEvent.getX();
                ((PolygonEditor)PolygonEditor.this).polygon.ypoints[((PolygonEditor)PolygonEditor.this).selected] = mouseEvent.getY();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.moveSelectedPoint(mouseEvent);
            PolygonEditor.this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            PolygonEditor.this.selected = -1;
            double d = 3.4028234663852886E38;
            for (n = 0; n < ((PolygonEditor)PolygonEditor.this).polygon.npoints; ++n) {
                double d2 = Point2D.distance(((PolygonEditor)PolygonEditor.this).polygon.xpoints[n], ((PolygonEditor)PolygonEditor.this).polygon.ypoints[n], mouseEvent.getX(), mouseEvent.getY());
                if (!(d2 < d)) continue;
                d = d2;
                PolygonEditor.this.selected = n;
            }
            if (mouseEvent.isMetaDown()) {
                PolygonEditor.this.polygon.addPoint(mouseEvent.getX(), mouseEvent.getY());
                if (PolygonEditor.this.selected >= 0) {
                    for (n = ((PolygonEditor)PolygonEditor.this).polygon.npoints - 1; n > PolygonEditor.this.selected; --n) {
                        ((PolygonEditor)PolygonEditor.this).polygon.xpoints[n] = ((PolygonEditor)PolygonEditor.this).polygon.xpoints[n - 1];
                        ((PolygonEditor)PolygonEditor.this).polygon.ypoints[n] = ((PolygonEditor)PolygonEditor.this).polygon.ypoints[n - 1];
                    }
                    ((PolygonEditor)PolygonEditor.this).polygon.xpoints[((PolygonEditor)PolygonEditor.this).selected] = mouseEvent.getX();
                    ((PolygonEditor)PolygonEditor.this).polygon.ypoints[((PolygonEditor)PolygonEditor.this).selected] = mouseEvent.getY();
                }
            }
        }

        public void scrollAtEdge(Point point, int n) {
            Point point2 = new Point(point.x - PolygonEditor.this.myScroll.getViewport().getViewPosition().x, point.y - PolygonEditor.this.myScroll.getViewport().getViewPosition().y);
            int n2 = 0;
            int n3 = 0;
            if (point2.x < n && point2.x >= 0) {
                n2 = -1;
            }
            if (point2.x >= PolygonEditor.this.myScroll.getViewport().getSize().width - n && point2.x < PolygonEditor.this.myScroll.getViewport().getSize().width) {
                n2 = 1;
            }
            if (point2.y < n && point2.y >= 0) {
                n3 = -1;
            }
            if (point2.y >= PolygonEditor.this.myScroll.getViewport().getSize().height - n && point2.y < PolygonEditor.this.myScroll.getViewport().getSize().height) {
                n3 = 1;
            }
            if (n2 != 0 || n3 != 0) {
                Rectangle rectangle = new Rectangle(PolygonEditor.this.myScroll.getViewport().getViewRect());
                rectangle.translate(2 * n * n2, 2 * n * n3);
                rectangle = rectangle.intersection(new Rectangle(new Point(0, 0), PolygonEditor.this.getPreferredSize()));
                PolygonEditor.this.scrollRectToVisible(rectangle);
            }
        }
    }
}

