/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.BufferedSocketHandler;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import java.io.IOException;
import java.net.Socket;

public class LockWatcher
extends Thread {
    private long delay;
    private long timeout;
    private int port;

    public LockWatcher(long l, long l2, int n) {
        this.delay = l;
        this.timeout = l2;
        this.port = n;
    }

    public void run() {
        try {
            while (true) {
                LockWatcher.sleep(this.delay);
                this.pingServer();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void pingServer() {
        try {
            Socket socket = new Socket("localhost", this.port);
            final Thread thread = new Thread(new Timeout());
            SocketWatcher socketWatcher = new SocketWatcher(){

                public void handleMessage(String string) {
                    thread.interrupt();
                }

                public void socketClosed(SocketHandler socketHandler) {
                    System.err.println("Server closed socket");
                }
            };
            BufferedSocketHandler bufferedSocketHandler = new BufferedSocketHandler(socket, socketWatcher);
            bufferedSocketHandler.start();
            thread.start();
            bufferedSocketHandler.writeLine(Protocol.encodeRegisterCommand("pinger", "ping/Main", ""));
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bufferedSocketHandler.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class Timeout
    implements Runnable {
        private Timeout() {
        }

        public void run() {
            try {
                Thread.sleep(LockWatcher.this.timeout);
                System.err.println("No response from server in " + (double)LockWatcher.this.timeout / 1000.0 + " seconds.  Terminating process");
                System.exit(0);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Ping");
            }
        }
    }
}

