/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListConfigurer
extends Configurer
implements PropertyChangeListener {
    protected Box controls;
    protected Box configControls;
    protected JPanel panel;
    protected Dimension fixedSize;
    protected List<Configurer> configurers = new ArrayList<Configurer>();

    public ListConfigurer(String string, String string2) {
        super(string, string2, new ArrayList());
    }

    public ListConfigurer(String string, String string2, List<?> list) {
        super(string, string2, list);
    }

    @Override
    public String getValueString() {
        if (this.getListValue().isEmpty()) {
            return "";
        }
        Configurer configurer = this.buildChildConfigurer();
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (Object object : this.getListValue()) {
            configurer.setValue(object);
            sequenceEncoder.append(configurer.getValueString());
        }
        return sequenceEncoder.getValue();
    }

    @Override
    public void setValue(String string) {
        this.getListValue().clear();
        if (string.length() > 0) {
            Configurer configurer = this.buildChildConfigurer();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
            while (decoder.hasMoreTokens()) {
                configurer.setValue(decoder.nextToken());
                this.getListValue().add(configurer.getValue());
            }
        }
        this.updateControls();
    }

    protected void updateValue() {
        this.noUpdate = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Configurer configurer : this.configurers) {
            arrayList.add(configurer.getValue());
        }
        this.setValue(arrayList);
        this.noUpdate = false;
    }

    @Override
    public void setValue(Object arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        super.setValue(arrayList);
        if (!this.noUpdate) {
            this.updateControls();
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.controls = Box.createVerticalBox();
            JScrollPane jScrollPane = new JScrollPane(this.controls);
            this.controls.setBorder(BorderFactory.createTitledBorder(this.getName()));
            this.configControls = Box.createVerticalBox();
            JButton jButton = new JButton("New");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Configurer configurer = ListConfigurer.this.buildChildConfigurer();
                    ListConfigurer.this.getListValue().add(configurer.getValue());
                    ListConfigurer.this.updateControls();
                }
            });
            this.controls.add(jButton);
            this.controls.add(this.configControls);
            this.panel.add((Component)jScrollPane, "Center");
            this.updateControls();
        }
        return this.panel;
    }

    public List<Object> getListValue() {
        return (List)this.getValue();
    }

    protected abstract Configurer buildChildConfigurer();

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateValue();
    }

    protected void updateControls() {
        if (this.controls != null) {
            for (Configurer object : this.configurers) {
                object.removePropertyChangeListener(this);
            }
            this.configurers.clear();
            this.configControls.removeAll();
            for (Object object : this.getListValue()) {
                final Configurer configurer = this.buildChildConfigurer();
                configurer.setValue(object);
                configurer.addPropertyChangeListener(this);
                this.configurers.add(configurer);
                Box box = Box.createHorizontalBox();
                JButton jButton = new JButton("Remove");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ListConfigurer.this.getListValue().remove(configurer.getValue());
                        ListConfigurer.this.updateControls();
                        ListConfigurer.this.repack();
                    }
                });
                box.add(jButton);
                box.add(configurer.getControls());
                this.configControls.add(box);
                if (this.configurers.size() > 5) {
                    if (this.fixedSize == null) {
                        this.fixedSize = new Dimension(this.panel.getPreferredSize().width + 20, 210);
                    }
                    this.panel.setPreferredSize(this.fixedSize);
                    continue;
                }
                this.panel.setPreferredSize(null);
            }
            this.repack();
        }
    }

    public void repack() {
        Window window = SwingUtilities.getWindowAncestor(this.controls);
        if (window != null) {
            window.pack();
        }
    }

    public int hashCode() {
        String string = this.getValueString();
        int n = 1;
        n = 31 * n + (string == null ? 0 : string.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ListConfigurer listConfigurer = (ListConfigurer)object;
        String string = this.getValueString();
        String string2 = listConfigurer.getValueString();
        return !(string == null ? string2 != null : !string.equals(string2));
    }
}

