/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class RestrictCommands
extends Decorator
implements EditablePiece {
    public static final String ID = "hideCmd;";
    protected static final String HIDE = "Hide";
    protected static final String DISABLE = "Disable";
    protected String name = "";
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected String action = "Hide";
    protected NamedKeyStroke[] watchKeys = new NamedKeyStroke[0];

    public RestrictCommands() {
        this(ID, null);
    }

    public RestrictCommands(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.name).append(this.action).append(this.propertyMatch.getExpression()).append(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys));
        return ID + sequenceEncoder.getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    public Command keyEvent(KeyStroke keyStroke) {
        if (!this.matchesFilter()) {
            return super.keyEvent(keyStroke);
        }
        for (int i = 0; i < this.watchKeys.length; ++i) {
            if (!this.watchKeys[i].equals(keyStroke)) continue;
            return null;
        }
        return super.keyEvent(keyStroke);
    }

    protected KeyCommand[] getKeyCommands() {
        KeyCommand[] keyCommandArray = super.getKeyCommands();
        ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>(keyCommandArray.length);
        if (this.matchesFilter()) {
            for (int i = 0; i < keyCommandArray.length; ++i) {
                boolean bl = false;
                for (int j = 0; j < this.watchKeys.length && !bl; ++j) {
                    bl = this.watchKeys[j].equals(keyCommandArray[i].getKeyStroke());
                }
                if (bl) {
                    if (!this.action.equals(DISABLE)) continue;
                    KeyCommand keyCommand = new KeyCommand(keyCommandArray[i]);
                    keyCommand.setEnabled(false);
                    arrayList.add(keyCommand);
                    continue;
                }
                arrayList.add(keyCommandArray[i]);
            }
            keyCommandArray = arrayList.toArray(new KeyCommand[arrayList.size()]);
        }
        return keyCommandArray;
    }

    protected boolean matchesFilter() {
        GamePiece gamePiece = Decorator.getOutermost(this);
        return this.propertyMatch.isNull() || this.propertyMatch.accept(gamePiece);
    }

    public void mySetState(String string) {
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = "Restrict Commands";
        if (this.name.length() > 0) {
            string = string + " - " + this.name;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RestrictCommands.htm");
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.name = decoder.nextToken("");
        this.action = decoder.nextToken(HIDE);
        this.propertyMatch.setExpression(decoder.nextToken(""));
        String string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.watchKeys = NamedKeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.watchKeys = new NamedKeyStroke[string2.length()];
            for (int i = 0; i < this.watchKeys.length; ++i) {
                this.watchKeys[i] = new NamedKeyStroke(string2.charAt(i), 2);
            }
        }
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer name;
        protected PropertyExpressionConfigurer propertyMatch;
        protected NamedKeyStrokeArrayConfigurer watchKeys;
        protected JComboBox actionOption;
        protected JPanel box = new JPanel();

        public Ed(RestrictCommands restrictCommands) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.name = new StringConfigurer(null, "Description:  ", restrictCommands.name);
            this.box.add(this.name.getControls());
            this.actionOption = new JComboBox();
            this.actionOption.addItem(RestrictCommands.HIDE);
            this.actionOption.addItem(RestrictCommands.DISABLE);
            this.actionOption.setSelectedIndex(restrictCommands.action.equals(RestrictCommands.HIDE) ? 0 : 1);
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Restriction:  "));
            box.add(this.actionOption);
            this.box.add(box);
            this.propertyMatch = new PropertyExpressionConfigurer(null, "Restrict when properties match:  ", restrictCommands.propertyMatch, Decorator.getOutermost(restrictCommands));
            this.box.add(this.propertyMatch.getControls());
            this.watchKeys = new NamedKeyStrokeArrayConfigurer(null, "Restrict these Key Commands  ", restrictCommands.watchKeys);
            this.box.add(this.watchKeys.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.name.getValueString()).append(this.actionOption.getSelectedIndex() == 0 ? RestrictCommands.HIDE : RestrictCommands.DISABLE).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString());
            return RestrictCommands.ID + sequenceEncoder.getValue();
        }
    }
}

