/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class TableInfo
extends Decorator
implements TranslatablePiece {
    public static final String ID = "table;";
    protected String values;
    protected String oldState;
    protected int nRows;
    protected int nCols;
    protected String command;
    protected NamedKeyStroke launchKey;
    protected KeyCommand launch;
    protected JTable table;
    protected JDialog frame;

    public TableInfo() {
        this("table;2;2;Show Data;S", null);
    }

    public TableInfo(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public int getRowCount() {
        return this.nRows;
    }

    public int getColumnCount() {
        return this.nCols;
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.nRows = decoder.nextInt(2);
        this.nCols = decoder.nextInt(2);
        this.command = decoder.nextToken();
        this.launchKey = decoder.nextNamedKeyStroke(null);
        this.frame = null;
        this.table = null;
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String myGetState() {
        if (this.table == null) {
            return this.values;
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                String string = (String)this.table.getValueAt(i, j);
                sequenceEncoder.append(string == null ? "" : string);
            }
        }
        return sequenceEncoder.getValue();
    }

    public void mySetState(String string) {
        if (this.table == null) {
            this.values = string;
        } else {
            this.setValues(string);
        }
    }

    private void setValues(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                this.table.setValueAt(decoder.nextToken(), i, j);
            }
        }
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.nRows).append(this.nCols).append(this.command).append(this.launchKey);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.launch == null) {
            this.launch = new KeyCommand(this.command, this.launchKey, Decorator.getOutermost(this), (TranslatablePiece)this);
        }
        return new KeyCommand[]{this.launch};
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.launch.matches(keyStroke)) {
            if (this.frame == null) {
                this.frame = new JDialog((Frame)null, false);
                this.table = new JTable(this.nRows, this.nCols);
                this.setValues(this.values);
                this.table.setTableHeader(null);
                ScrollPane scrollPane = new ScrollPane(this.table);
                scrollPane.getViewport().setPreferredSize(this.table.getPreferredSize());
                this.frame.add(scrollPane);
                Point point = GameModule.getGameModule().getFrame().getLocation();
                if (this.getMap() != null) {
                    point = this.getMap().getView().getLocationOnScreen();
                    Point point2 = this.getMap().componentCoordinates(this.getPosition());
                    point.translate(point2.x, point2.y);
                }
                this.frame.setLocation(point.x, point.y);
                this.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        TableInfo.this.table.editingStopped(null);
                        GamePiece gamePiece = Decorator.getOutermost(TableInfo.this);
                        if (gamePiece.getId() != null) {
                            GameModule.getGameModule().sendAndLog(new ChangePiece(gamePiece.getId(), TableInfo.this.oldState, gamePiece.getState()));
                        }
                    }
                });
                this.frame.pack();
            }
            this.frame.setTitle(this.getName());
            this.oldState = Decorator.getOutermost(this).getState();
            this.frame.setVisible(true);
            return null;
        }
        return null;
    }

    public String getDescription() {
        return "Spreadsheet";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Spreadsheet.htm");
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, "Table Info command");
    }

    private static class Ed
    implements PieceEditor {
        private IntConfigurer rowConfig = new IntConfigurer(null, "Number of rows:  ");
        private IntConfigurer colConfig = new IntConfigurer(null, "Number of columns:  ");
        private StringConfigurer commandConfig = new StringConfigurer(null, "Menu Command:  ");
        private NamedHotKeyConfigurer keyConfig;
        private JPanel panel;

        public Ed(TableInfo tableInfo) {
            this.rowConfig.setValue(tableInfo.nRows);
            this.colConfig.setValue(tableInfo.nCols);
            this.commandConfig.setValue(tableInfo.command);
            this.keyConfig = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", tableInfo.launchKey);
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.commandConfig.getControls());
            this.panel.add(this.keyConfig.getControls());
            this.panel.add(this.rowConfig.getControls());
            this.panel.add(this.colConfig.getControls());
        }

        public Component getControls() {
            return this.panel;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.rowConfig.getValueString()).append(this.colConfig.getValueString()).append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString());
            return TableInfo.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = (Integer)this.rowConfig.getValue() * (Integer)this.colConfig.getValue();
            while (--n > 0) {
                stringBuilder.append(',');
            }
            return stringBuilder.toString();
        }
    }
}

