/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.MacOSXStartUp;
import VASSAL.launch.StartUp;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.ipc.IPCMessenger;
import VASSAL.tools.ipc.SimpleIPCMessage;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MenuManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);
    protected IPCMessenger ipc = null;
    protected final LaunchRequest lr;
    private static Launcher instance = null;

    public static Launcher getInstance() {
        return instance;
    }

    protected Launcher(String[] stringArray) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        LaunchRequest launchRequest = null;
        try {
            launchRequest = LaunchRequest.parseArgs(stringArray);
        }
        catch (LaunchRequestException launchRequestException) {
            System.err.println("VASSAL: " + launchRequestException.getMessage());
            System.exit(1);
        }
        this.lr = launchRequest;
        boolean bl = this.lr.standalone;
        StartUp startUp = SystemUtils.IS_OS_MAC_OSX ? new MacOSXStartUp() : new StartUp();
        startUp.startErrorLog();
        System.setErr(new PrintStream(new LoggedOutputStream(), true));
        logger.info(this.getClass().getSimpleName());
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        startUp.initSystemProperties();
        if (!bl) {
            try {
                int n = Integer.parseInt(System.getProperty("VASSAL.port"));
                InetAddress inetAddress = InetAddress.getByName(null);
                Socket socket = new Socket(inetAddress, n);
                this.ipc = new IPCMessenger(socket);
                this.ipc.addEventListener(CloseRequest.class, new CloseRequestListener());
                this.ipc.start();
                this.ipc.send(new StartedNotice(Info.getInstanceID()));
            }
            catch (IOException iOException) {
                ErrorDialog.show(iOException, "Error.communication_error", Resources.getString(this.getClass().getSimpleName() + ".app_name"));
                System.exit(1);
            }
        }
        this.createMenuManager();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Launcher.this.launch();
                }
                catch (ExtensionsLoader.LoadExtensionException loadExtensionException) {
                    this.warn(loadExtensionException);
                }
                catch (IOException iOException) {
                    this.warn(iOException);
                }
            }

            private void warn(Exception exception) {
                if (Launcher.this.ipc == null) {
                    ErrorDialog.showDetails(exception, ThrowableUtils.getStackTrace(exception), "Error.module_load_failed", exception.getMessage());
                } else {
                    try {
                        Launcher.this.ipc.send(new AbstractLaunchAction.NotifyOpenModuleFailed(Launcher.this.lr, exception));
                    }
                    catch (IOException iOException) {
                        ErrorDialog.showDetails(exception, ThrowableUtils.getStackTrace(exception), "Error.module_load_failed", exception.getMessage());
                        ErrorDialog.show(iOException, "Error.communication_error", Resources.getString(this.getClass().getSimpleName() + ".app_name"));
                    }
                }
                System.exit(1);
            }
        });
    }

    protected abstract void launch() throws IOException;

    protected abstract MenuManager createMenuManager();

    public void sendSaveCmd(File file) {
        if (this.ipc != null) {
            try {
                this.ipc.send(new AbstractLaunchAction.NotifySaveFileOk(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CloseRequestListener
    implements EventListener<CloseRequest> {
        private boolean shutdown;

        protected CloseRequestListener() {
        }

        @Override
        public void receive(Object object, CloseRequest closeRequest) {
            final GameModule gameModule = GameModule.getGameModule();
            if (gameModule != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            gameModule.getFrame().toFront();
                            CloseRequestListener.this.shutdown = gameModule.shutDown();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    logger.error("", (Throwable)interruptedException);
                    this.shutdown = false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorDialog.bug(invocationTargetException);
                    this.shutdown = false;
                }
            }
            if (this.shutdown) {
                if (Launcher.this.ipc != null) {
                    try {
                        Launcher.this.ipc.send(new CloseAccept(-closeRequest.getId()));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                System.exit(0);
            } else if (Launcher.this.ipc != null) {
                try {
                    Launcher.this.ipc.send(new CloseReject(-closeRequest.getId()));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static class StartedNotice
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final long pid;

        public StartedNotice(long l) {
            this.pid = l;
        }
    }

    public static class CloseReject
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final long pid;

        public CloseReject(long l) {
            this.pid = l;
        }
    }

    public static class CloseAccept
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final long pid;

        public CloseAccept(long l) {
            this.pid = l;
        }
    }

    public static class CloseRequest
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
    }
}

