/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.properties.PropertySource;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.tools.SequenceEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattedStringExpression
extends Expression {
    public FormattedStringExpression(String string) {
        this.setExpression(string);
    }

    @Override
    public String evaluate(PropertySource propertySource, Map<String, String> map, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.getExpression(), '$');
        boolean bl2 = true;
        while (decoder.hasMoreTokens()) {
            Object object;
            String string = decoder.nextToken();
            boolean bl3 = bl2 = !bl2;
            if (string.length() <= 0) continue;
            if (!bl2 || !decoder.hasMoreTokens()) {
                stringBuilder.append(string);
                continue;
            }
            if (map != null && map.containsKey(string)) {
                object = map.get(string);
                if (object == null) continue;
                stringBuilder.append((String)object);
                continue;
            }
            if (propertySource != null) {
                Object object2 = object = bl ? propertySource.getLocalizedProperty(string) : propertySource.getProperty(string);
                if (object != null) {
                    stringBuilder.append(object.toString());
                    continue;
                }
                if (bl) continue;
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toBeanShellString() {
        String string = this.getExpression();
        try {
            Integer.parseInt(string);
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '$');
            boolean bl = true;
            boolean bl2 = true;
            while (decoder.hasMoreTokens()) {
                String string2 = decoder.nextToken();
                boolean bl3 = bl = !bl;
                if (string2.length() <= 0) continue;
                if (!bl2) {
                    stringBuilder.append("+");
                }
                if (bl && decoder.hasMoreTokens()) {
                    stringBuilder.append(BeanShellExpression.convertProperty(string2));
                } else {
                    stringBuilder.append("\"");
                    stringBuilder.append(string2);
                    stringBuilder.append("\"");
                }
                bl2 = false;
            }
            return stringBuilder.toString();
        }
    }
}

