/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.opcache.Op;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateScaleOpSVGImpl
extends AbstractTileOpImpl
implements RotateScaleOp,
SVGOp {
    private final SVGOp sop;
    private final double scale;
    private final double angle;
    private final RenderingHints hints;
    private final int hash;

    public RotateScaleOpSVGImpl(SVGOp sVGOp, double d, double d2) {
        this(sVGOp, d, d2, ImageUtils.getDefaultHints());
    }

    public RotateScaleOpSVGImpl(SVGOp sVGOp, double d, double d2, RenderingHints renderingHints) {
        if (sVGOp == null) {
            throw new IllegalArgumentException();
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("scale = " + d2);
        }
        this.sop = sVGOp;
        this.angle = d;
        this.scale = d2;
        this.hints = renderingHints;
        this.hash = new HashCodeBuilder().append((Object)sVGOp).append(d2).append(d).append((Object)renderingHints).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws Exception {
        DataArchive dataArchive = GameModule.getGameModule().getDataArchive();
        String string = this.getName();
        try {
            SVGRenderer sVGRenderer = new SVGRenderer(dataArchive.getURL(string), (InputStream)new BufferedInputStream(dataArchive.getInputStream(string)));
            if (this.size == null) {
                this.fixSize();
            }
            return sVGRenderer.render(this.angle, this.scale);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImageNotFoundException(string, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ImageIOException(string, (Throwable)iOException);
        }
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = ImageUtils.transform(new Rectangle(this.sop.getSize()), this.scale, this.angle).getSize();
        }
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public String getName() {
        return this.sop.getName();
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RotateScaleOpSVGImpl rotateScaleOpSVGImpl = (RotateScaleOpSVGImpl)object;
        return this.scale == rotateScaleOpSVGImpl.getScale() && this.angle == rotateScaleOpSVGImpl.getAngle() && this.hints.equals(rotateScaleOpSVGImpl.getHints()) && this.sop.equals(rotateScaleOpSVGImpl.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

