/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    private byte[] buffer;
    private int length;
    private String encoding = null;

    public ByteBuffer(int n) {
        this.buffer = new byte[n];
        this.length = 0;
    }

    public ByteBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.length = byArray.length;
    }

    public ByteBuffer(byte[] byArray, int n) {
        if (n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Valid length exceeds the buffer length.");
        }
        this.buffer = byArray;
        this.length = n;
    }

    public ByteBuffer(InputStream inputStream) throws IOException {
        int n;
        int n2 = 16384;
        this.length = 0;
        this.buffer = new byte[n2];
        while ((n = inputStream.read(this.buffer, this.length, n2)) > 0) {
            this.length += n;
            if (n != n2) break;
            this.ensureCapacity(this.length + n2);
        }
    }

    public ByteBuffer(byte[] byArray, int n, int n2) {
        if (n2 > byArray.length - n) {
            throw new ArrayIndexOutOfBoundsException("Valid length exceeds the buffer length.");
        }
        this.buffer = new byte[n2];
        System.arraycopy(byArray, n, this.buffer, 0, n2);
        this.length = n2;
    }

    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.buffer, 0, this.length);
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int n) {
        if (n < this.length) {
            return this.buffer[n];
        }
        throw new IndexOutOfBoundsException("The index exceeds the valid buffer area");
    }

    public int charAt(int n) {
        if (n < this.length) {
            return this.buffer[n] & 0xFF;
        }
        throw new IndexOutOfBoundsException("The index exceeds the valid buffer area");
    }

    public void append(byte by) {
        this.ensureCapacity(this.length + 1);
        this.buffer[this.length++] = by;
    }

    public void append(byte[] byArray, int n, int n2) {
        this.ensureCapacity(this.length + n2);
        System.arraycopy(byArray, n, this.buffer, this.length, n2);
        this.length += n2;
    }

    public void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    public void append(ByteBuffer byteBuffer) {
        this.append(byteBuffer.buffer, 0, byteBuffer.length);
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.length < 2 ? "UTF-8" : (this.buffer[0] == 0 ? (this.length < 4 || this.buffer[1] != 0 ? "UTF-16BE" : ((this.buffer[2] & 0xFF) == 254 && (this.buffer[3] & 0xFF) == 255 ? "UTF-32BE" : "UTF-32")) : ((this.buffer[0] & 0xFF) < 128 ? (this.buffer[1] != 0 ? "UTF-8" : (this.length < 4 || this.buffer[2] != 0 ? "UTF-16LE" : "UTF-32LE")) : ((this.buffer[0] & 0xFF) == 239 ? "UTF-8" : ((this.buffer[0] & 0xFF) == 254 ? "UTF-16" : (this.length < 4 || this.buffer[2] != 0 ? "UTF-16" : "UTF-32")))));
        }
        return this.encoding;
    }

    private void ensureCapacity(int n) {
        if (n > this.buffer.length) {
            byte[] byArray = this.buffer;
            this.buffer = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
        }
    }
}

