/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.grouping.AllGroupHeadsCollector;
import org.apache.lucene.search.grouping.GroupFacetCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermGroupFacetCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SpatialHeatmapFacets;
import org.apache.solr.request.DocValuesFacets;
import org.apache.solr.request.IntervalFacets;
import org.apache.solr.request.NumericFacets;
import org.apache.solr.request.PerSegmentSingleValuedFaceting;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SubstringBytesRefFilter;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.search.Insanity;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.util.BoundedTreeSet;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.RTimer;

public class SimpleFacets {
    protected DocSet docsOrig;
    protected final SolrParams global;
    protected final SolrIndexSearcher searcher;
    protected final SolrQueryRequest req;
    protected final ResponseBuilder rb;
    protected FacetDebugInfo fdebugParent;
    protected FacetDebugInfo fdebug;
    static final Executor directExecutor = new Executor(){

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    };
    static final Executor facetExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("facetExecutor"));

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this(req, docs, params, null);
    }

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docsOrig = docs;
        this.global = params;
        this.rb = rb;
    }

    public void setFacetDebugInfo(FacetDebugInfo fdebugParent) {
        this.fdebugParent = fdebugParent;
    }

    protected ParsedParams parseParams(String type, String param) throws SyntaxError, IOException {
        String excludeStr;
        SolrParams localParams = QueryParsing.getLocalParams(param, this.req.getParams());
        DocSet docs = this.docsOrig;
        String facetValue = param;
        String key = param;
        List<String> tags = Collections.emptyList();
        int threads = -1;
        if (localParams == null) {
            SolrParams params = this.global;
            RequiredSolrParams required = new RequiredSolrParams(params);
            return new ParsedParams(localParams, params, (SolrParams)required, facetValue, docs, key, tags, threads);
        }
        SolrParams params = SolrParams.wrapDefaults((SolrParams)localParams, (SolrParams)this.global);
        RequiredSolrParams required = new RequiredSolrParams(params);
        if (type != "facet.query") {
            facetValue = localParams.get("v");
        }
        key = facetValue;
        key = localParams.get("key", key);
        String tagStr = localParams.get("tag");
        tags = tagStr == null ? Collections.emptyList() : StrUtils.splitSmart((String)tagStr, (char)',');
        String threadStr = localParams.get("threads");
        if (threadStr != null) {
            threads = Integer.parseInt(threadStr);
        }
        if ((excludeStr = localParams.get("ex")) == null) {
            return new ParsedParams(localParams, params, (SolrParams)required, facetValue, docs, key, tags, threads);
        }
        List excludeTagList = StrUtils.splitSmart((String)excludeStr, (char)',');
        docs = this.computeDocSet(docs, excludeTagList);
        return new ParsedParams(localParams, params, (SolrParams)required, facetValue, docs, key, tags, threads);
    }

    protected DocSet computeDocSet(DocSet baseDocSet, List<String> excludeTagList) throws SyntaxError, IOException {
        Map tagMap = (Map)this.req.getContext().get("tags");
        if (tagMap == null || this.rb == null) {
            return baseDocSet;
        }
        IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
        for (String string : excludeTagList) {
            Object olst = tagMap.get(string);
            if (!(olst instanceof Collection)) continue;
            for (Object o : (Collection)olst) {
                if (!(o instanceof QParser)) continue;
                QParser qp = (QParser)o;
                excludeSet.put(qp.getQuery(), Boolean.TRUE);
            }
        }
        if (excludeSet.size() == 0) {
            return baseDocSet;
        }
        ArrayList<Query> qlist = new ArrayList<Query>();
        if (!excludeSet.containsKey(this.rb.getQuery())) {
            qlist.add(this.rb.getQuery());
        }
        if (this.rb.getFilters() != null) {
            for (Query q : this.rb.getFilters()) {
                if (excludeSet.containsKey(q)) continue;
                qlist.add(q);
            }
        }
        DocSet docSet = this.searcher.getDocSet(qlist);
        if (this.rb.grouping() && this.rb.getGroupingSpec().isTruncateGroups()) {
            Grouping grouping = new Grouping(this.searcher, null, this.rb.getQueryCommand(), false, 0, false);
            grouping.setWithinGroupSort(this.rb.getGroupingSpec().getSortWithinGroup());
            if (this.rb.getGroupingSpec().getFields().length > 0) {
                grouping.addFieldCommand(this.rb.getGroupingSpec().getFields()[0], this.req);
            } else if (this.rb.getGroupingSpec().getFunctions().length > 0) {
                grouping.addFunctionCommand(this.rb.getGroupingSpec().getFunctions()[0], this.req);
            } else {
                return docSet;
            }
            AllGroupHeadsCollector<?> allGroupHeadsCollector = grouping.getCommands().get(0).createAllGroupCollector();
            this.searcher.search(docSet.getTopFilter(), (Collector)allGroupHeadsCollector);
            return new BitDocSet(allGroupHeadsCollector.retrieveGroupHeads(this.searcher.maxDoc()));
        }
        return docSet;
    }

    public NamedList<Integer> getFacetQueryCounts() throws IOException, SyntaxError {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetQs = this.global.getParams("facet.query");
        if (null != facetQs && 0 != facetQs.length) {
            for (String q : facetQs) {
                ParsedParams parsed = this.parseParams("facet.query", q);
                this.getFacetQueryCount(parsed, (NamedList<Integer>)res);
            }
        }
        return res;
    }

    public void getFacetQueryCount(ParsedParams parsed, NamedList<Integer> res) throws SyntaxError, IOException {
        Query qobj = QParser.getParser(parsed.facetValue, this.req).getQuery();
        if (qobj == null) {
            res.add(parsed.key, (Object)0);
        } else if (parsed.params.getBool("group.facet", false)) {
            res.add(parsed.key, (Object)this.getGroupedFacetQueryCount(qobj, parsed.docs));
        } else {
            res.add(parsed.key, (Object)this.searcher.numDocs(qobj, parsed.docs));
        }
    }

    public int getGroupedFacetQueryCount(Query facetQuery, DocSet docSet) throws IOException {
        String groupField = this.global.get("group.field");
        if (groupField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify the group.field as parameter or local parameter");
        }
        TermAllGroupsCollector collector = new TermAllGroupsCollector(groupField);
        Filter mainQueryFilter = docSet.getTopFilter();
        BooleanQuery filteredFacetQuery = new BooleanQuery.Builder().add(facetQuery, BooleanClause.Occur.MUST).add((Query)mainQueryFilter, BooleanClause.Occur.FILTER).build();
        this.searcher.search((Query)filteredFacetQuery, (Collector)collector);
        return collector.getGroupCount();
    }

    protected Predicate<BytesRef> newExcludeBytesRefFilter(String field, SolrParams params) {
        String exclude = params.getFieldParam(field, "facet.excludeTerms");
        if (exclude == null) {
            return null;
        }
        final HashSet excludeTerms = new HashSet(StrUtils.splitSmart((String)exclude, (String)",", (boolean)true));
        return new Predicate<BytesRef>(){

            @Override
            public boolean test(BytesRef bytesRef) {
                return !excludeTerms.contains(bytesRef.utf8ToString());
            }
        };
    }

    protected Predicate<BytesRef> newBytesRefFilter(String field, SolrParams params) {
        SubstringBytesRefFilter containsFilter;
        String contains = params.getFieldParam(field, "facet.contains");
        if (contains != null) {
            boolean containsIgnoreCase = params.getFieldBool(field, "facet.contains.ignoreCase", false);
            containsFilter = new SubstringBytesRefFilter(contains, containsIgnoreCase);
        } else {
            containsFilter = null;
        }
        Predicate<BytesRef> excludeFilter = this.newExcludeBytesRefFilter(field, params);
        if (containsFilter == null && excludeFilter == null) {
            return null;
        }
        if (containsFilter != null && excludeFilter == null) {
            return containsFilter;
        }
        if (containsFilter == null && excludeFilter != null) {
            return excludeFilter;
        }
        return containsFilter.and(excludeFilter);
    }

    public NamedList<Integer> getTermCountsForPivots(String field, ParsedParams parsed) throws IOException {
        Integer mincount = parsed.params.getFieldInt(field, "facet.pivot.mincount", 1);
        return this.getTermCounts(field, mincount, parsed);
    }

    public NamedList<Integer> getTermCounts(String field, ParsedParams parsed) throws IOException {
        Integer mincount = parsed.params.getFieldInt(field, "facet.mincount");
        return this.getTermCounts(field, mincount, parsed);
    }

    private NamedList<Integer> getTermCounts(String field, Integer mincount, ParsedParams parsed) throws IOException {
        NamedList counts;
        SolrParams params = parsed.params;
        DocSet docs = parsed.docs;
        int threads = parsed.threads;
        int offset = params.getFieldInt(field, "facet.offset", 0);
        int limit = params.getFieldInt(field, "facet.limit", 100);
        if (limit == 0) {
            return new NamedList();
        }
        if (mincount == null) {
            Boolean zeros = params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        boolean missing = params.getFieldBool(field, "facet.missing", false);
        String sort = params.getFieldParam(field, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = params.getFieldParam(field, "facet.prefix");
        Predicate<BytesRef> termFilter = this.newBytesRefFilter(field, params);
        boolean exists = params.getFieldBool(field, "facet.exists", false);
        SchemaField sf = this.searcher.getSchema().getField(field);
        if (sf.getType().isPointField() && !sf.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't facet on a PointField without docValues");
        }
        FieldType ft = sf.getType();
        String methodStr = params.getFieldParam(field, "facet.method");
        FacetMethod requestedMethod = "enum".equals(methodStr) ? FacetMethod.ENUM : ("fcs".equals(methodStr) ? FacetMethod.FCS : ("fc".equals(methodStr) ? FacetMethod.FC : ("uif".equals(methodStr) ? FacetMethod.UIF : null)));
        boolean multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        FacetMethod appliedFacetMethod = SimpleFacets.selectFacetMethod(field, sf, requestedMethod, mincount, exists);
        RTimer timer = null;
        if (this.fdebug != null) {
            this.fdebug.putInfoItem("requestedMethod", requestedMethod == null ? "not specified" : requestedMethod.name());
            this.fdebug.putInfoItem("appliedMethod", appliedFacetMethod.name());
            this.fdebug.putInfoItem("inputDocSetSize", docs.size());
            this.fdebug.putInfoItem("field", field);
            timer = new RTimer();
        }
        if (params.getFieldBool(field, "group.facet", false)) {
            counts = this.getGroupedCounts(this.searcher, docs, field, multiToken, offset, limit, mincount, missing, sort, prefix, termFilter);
        } else {
            assert (appliedFacetMethod != null);
            switch (appliedFacetMethod) {
                case ENUM: {
                    assert (TrieField.getMainValuePrefix(ft) == null);
                    counts = this.getFacetTermEnumCounts(this.searcher, docs, field, offset, limit, mincount, missing, sort, prefix, termFilter, exists);
                    break;
                }
                case FCS: {
                    assert (ft.isPointField() || !multiToken);
                    if (ft.isPointField() || ft.getNumberType() != null && !sf.multiValued()) {
                        if (prefix != null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.prefix is not supported on numeric types");
                        }
                        if (termFilter != null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "BytesRef term filters (facet.contains, facet.excludeTerms) are not supported on numeric types");
                        }
                        counts = NumericFacets.getCounts(this.searcher, docs, field, offset, limit, mincount, missing, sort);
                        break;
                    }
                    PerSegmentSingleValuedFaceting ps = new PerSegmentSingleValuedFaceting(this.searcher, docs, field, offset, limit, mincount, missing, sort, prefix, termFilter);
                    Executor executor = threads == 0 ? directExecutor : facetExecutor;
                    ps.setNumThreads(threads);
                    counts = ps.getFacetCounts(executor);
                    break;
                }
                case UIF: {
                    String sortVal;
                    HashMap<String, Object> jsonFacet = new HashMap<String, Object>(13);
                    jsonFacet.put("type", "terms");
                    jsonFacet.put("field", field);
                    jsonFacet.put("offset", offset);
                    jsonFacet.put("limit", limit);
                    jsonFacet.put("mincount", mincount);
                    jsonFacet.put("missing", missing);
                    jsonFacet.put("prefix", prefix);
                    jsonFacet.put("numBuckets", params.getFieldBool(field, "numBuckets", false));
                    jsonFacet.put("allBuckets", params.getFieldBool(field, "allBuckets", false));
                    jsonFacet.put("method", "uif");
                    jsonFacet.put("cacheDf", 0);
                    jsonFacet.put("perSeg", false);
                    switch (sort) {
                        case "true": {
                            sortVal = "count";
                            break;
                        }
                        case "false": {
                            sortVal = "index";
                            break;
                        }
                        default: {
                            sortVal = sort;
                        }
                    }
                    jsonFacet.put("sort", sortVal);
                    HashMap<String, Object> topLevel = new HashMap<String, Object>();
                    topLevel.put(field, jsonFacet);
                    topLevel.put("processEmpty", true);
                    FacetProcessor<?> fproc = FacetProcessor.createProcessor(this.rb.req, topLevel, docs);
                    fproc.process();
                    Object res = fproc.getResponse();
                    counts = new NamedList();
                    if (res == null) break;
                    SimpleOrderedMap som = (SimpleOrderedMap)res;
                    SimpleOrderedMap asdf = (SimpleOrderedMap)som.get(field);
                    List buckets = (List)asdf.get("buckets");
                    for (SimpleOrderedMap b : buckets) {
                        counts.add(b.get("val").toString(), (Object)((Integer)b.get("count")));
                    }
                    if (!missing) break;
                    SimpleOrderedMap missingCounts = (SimpleOrderedMap)asdf.get("missing");
                    counts.add(null, (Object)((Integer)missingCounts.get("count")));
                    break;
                }
                case FC: {
                    counts = DocValuesFacets.getCounts(this.searcher, docs, field, offset, limit, mincount, missing, sort, prefix, termFilter, this.fdebug);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.fdebug != null) {
            long timeElapsed = (long)timer.getTime();
            this.fdebug.setElapse(timeElapsed);
        }
        return counts;
    }

    static FacetMethod selectFacetMethod(String fieldName, SchemaField field, FacetMethod method, Integer mincount, boolean existsRequested) {
        if (existsRequested) {
            SimpleFacets.checkMincountOnExists(fieldName, mincount);
            if (method == null) {
                method = FacetMethod.ENUM;
            }
        }
        FacetMethod facetMethod = SimpleFacets.selectFacetMethod(field, method, mincount);
        if (existsRequested && facetMethod != FacetMethod.ENUM) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.exists=true is requested, but facet.method=enum can't be used with " + fieldName);
        }
        return facetMethod;
    }

    static FacetMethod selectFacetMethod(SchemaField field, FacetMethod method, Integer mincount) {
        boolean multiToken;
        FieldType type = field.getType();
        if (type.isPointField()) {
            return FacetMethod.FCS;
        }
        if (method == null) {
            method = type instanceof BoolField && (field.indexed() || !field.hasDocValues()) ? FacetMethod.ENUM : (type.getNumberType() != null && !field.multiValued() ? FacetMethod.FCS : FacetMethod.FC);
        }
        if (method == FacetMethod.FC && type.getNumberType() != null && !field.multiValued()) {
            method = FacetMethod.FCS;
        }
        if (method == FacetMethod.UIF && !field.hasDocValues() && mincount == 0) {
            FacetMethod facetMethod = method = field.multiValued() ? FacetMethod.FC : FacetMethod.FCS;
        }
        if (method == FacetMethod.ENUM && TrieField.getMainValuePrefix(type) != null) {
            method = field.multiValued() ? FacetMethod.FC : FacetMethod.FCS;
        }
        boolean bl = multiToken = field.multiValued() || type.multiValuedFieldCache();
        if (method == FacetMethod.FCS && multiToken) {
            method = FacetMethod.FC;
        }
        return method;
    }

    public NamedList<Integer> getGroupedCounts(SolrIndexSearcher searcher, DocSet base, String field, boolean multiToken, int offset, int limit, int mincount, boolean missing, String sort, String prefix, Predicate<BytesRef> termFilter) throws IOException {
        String groupField;
        GroupingSpecification groupingSpecification = this.rb.getGroupingSpec();
        String string = groupField = groupingSpecification != null ? groupingSpecification.getFields()[0] : null;
        if (groupField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify the group.field as parameter or local parameter");
        }
        BytesRef prefixBytesRef = prefix != null ? new BytesRef((CharSequence)prefix) : null;
        TermGroupFacetCollector collector = TermGroupFacetCollector.createTermGroupFacetCollector((String)groupField, (String)field, (boolean)multiToken, (BytesRef)prefixBytesRef, (int)128);
        Collector groupWrapper = this.getInsanityWrapper(groupField, (Collector)collector);
        Collector fieldWrapper = this.getInsanityWrapper(field, groupWrapper);
        searcher.search(base.getTopFilter(), fieldWrapper);
        boolean orderByCount = sort.equals("count") || sort.equals("true");
        GroupFacetCollector.GroupedFacetResult result = collector.mergeSegmentResults(limit < 0 ? Integer.MAX_VALUE : offset + limit, mincount, orderByCount);
        CharsRefBuilder charsRef = new CharsRefBuilder();
        FieldType facetFieldType = searcher.getSchema().getFieldType(field);
        NamedList facetCounts = new NamedList();
        List scopedEntries = result.getFacetEntries(offset, limit < 0 ? Integer.MAX_VALUE : limit);
        for (GroupFacetCollector.FacetEntry facetEntry : scopedEntries) {
            if (termFilter != null && !termFilter.test(facetEntry.getValue())) continue;
            facetFieldType.indexedToReadable(facetEntry.getValue(), charsRef);
            facetCounts.add(charsRef.toString(), (Object)facetEntry.getCount());
        }
        if (missing) {
            facetCounts.add(null, (Object)result.getTotalMissingCount());
        }
        return facetCounts;
    }

    private Collector getInsanityWrapper(final String field, Collector collector) {
        SchemaField sf = this.searcher.getSchema().getFieldOrNull(field);
        if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumberType() != null) {
            return new FilterCollector(collector){

                public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                    LeafReader insane = Insanity.wrapInsanity(context.reader(), field);
                    return this.in.getLeafCollector(insane.getContext());
                }
            };
        }
        return collector;
    }

    public NamedList<Object> getFacetFieldCounts() throws IOException, SyntaxError {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetFs = this.global.getParams("facet.field");
        if (null == facetFs) {
            return res;
        }
        int maxThreads = this.req.getParams().getInt("facet.threads", 0);
        Executor executor = maxThreads == 0 ? directExecutor : facetExecutor;
        Semaphore semaphore = new Semaphore(maxThreads <= 0 ? Integer.MAX_VALUE : maxThreads);
        ArrayList<FutureTask<NamedList>> futures = new ArrayList<FutureTask<NamedList>>(facetFs.length);
        if (this.fdebugParent != null) {
            this.fdebugParent.putInfoItem("maxThreads", maxThreads);
        }
        try {
            for (String f : facetFs) {
                if (this.fdebugParent != null) {
                    this.fdebug = new FacetDebugInfo();
                    this.fdebugParent.addChild(this.fdebug);
                }
                ParsedParams parsed = this.parseParams("facet.field", f);
                SolrParams localParams = parsed.localParams;
                String termList = localParams == null ? null : localParams.get("terms");
                String key = parsed.key;
                String facetValue = parsed.facetValue;
                Callable<NamedList> callable = () -> {
                    try {
                        SimpleOrderedMap result = new SimpleOrderedMap();
                        if (termList != null) {
                            List terms = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
                            result.add(key, this.getListedTermCounts(facetValue, parsed, terms));
                        } else {
                            result.add(key, this.getTermCounts(facetValue, parsed));
                        }
                        SimpleOrderedMap simpleOrderedMap = result;
                        return simpleOrderedMap;
                    }
                    catch (SolrException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception during facet.field: " + facetValue, (Throwable)e);
                    }
                    finally {
                        semaphore.release();
                    }
                };
                FutureTask<NamedList> runnableFuture = new FutureTask<NamedList>(callable);
                semaphore.acquire();
                executor.execute(runnableFuture);
                futures.add(runnableFuture);
            }
            for (Future future : futures) {
                res.addAll((NamedList)future.get());
            }
            assert (semaphore.availablePermits() >= maxThreads);
        }
        catch (InterruptedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while processing facet fields: InterruptedException", (Throwable)e);
        }
        catch (ExecutionException ee) {
            Throwable throwable = ee.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while processing facet fields: " + throwable.toString(), throwable);
        }
        return res;
    }

    protected NamedList<Integer> getListedTermCounts(String field, ParsedParams parsed, List<String> terms) throws IOException {
        SchemaField sf = this.searcher.getSchema().getField(field);
        FieldType ft = sf.getType();
        NamedList res = new NamedList();
        for (String term : terms) {
            int count = this.searcher.numDocs(ft.getFieldQuery(null, sf, term), parsed.docs);
            res.add(term, (Object)count);
        }
        return res;
    }

    public static int getFieldMissingCount(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        DocSet hasVal = searcher.getDocSet(sf.getType().getRangeQuery(null, sf, null, null, false, false));
        return docs.andNotSize(hasVal);
    }

    public NamedList<Integer> getFacetTermEnumCounts(SolrIndexSearcher searcher, DocSet docs, String field, int offset, int limit, int mincount, boolean missing, String sort, String prefix, String contains, boolean ignoreCase, boolean intersectsCheck) throws IOException {
        SubstringBytesRefFilter termFilter = new SubstringBytesRefFilter(contains, ignoreCase);
        return this.getFacetTermEnumCounts(searcher, docs, field, offset, limit, mincount, missing, sort, prefix, termFilter, intersectsCheck);
    }

    public NamedList<Integer> getFacetTermEnumCounts(SolrIndexSearcher searcher, DocSet docs, String field, int offset, int limit, int mincount, boolean missing, String sort, String prefix, Predicate<BytesRef> termFilter, boolean intersectsCheck) throws IOException {
        Fields fields;
        int minDfFilterCache = this.global.getFieldInt(field, "facet.enum.cache.minDf", 0);
        DocSet fastForRandomSet = docs;
        if (minDfFilterCache > 0 && docs instanceof SortedIntDocSet) {
            SortedIntDocSet sset = (SortedIntDocSet)docs;
            fastForRandomSet = new HashDocSet(sset.getDocs(), 0, sset.size());
        }
        IndexSchema schema = searcher.getSchema();
        FieldType ft = schema.getFieldType(field);
        assert (!ft.isPointField()) : "Point Fields don't support enum method";
        LeafReader r = searcher.getSlowAtomicReader();
        boolean sortByCount = sort.equals("count") || sort.equals("true");
        int maxsize = limit >= 0 ? offset + limit : 0x7FFFFFFE;
        BoundedTreeSet<CountPair<BytesRef, Integer>> queue = sortByCount ? new BoundedTreeSet<CountPair<BytesRef, Integer>>(maxsize) : null;
        NamedList res = new NamedList();
        int min = mincount - 1;
        int off = offset;
        int lim = limit >= 0 ? limit : Integer.MAX_VALUE;
        BytesRef prefixTermBytes = null;
        if (prefix != null) {
            String indexedPrefix = ft.toInternal(prefix);
            prefixTermBytes = new BytesRef((CharSequence)indexedPrefix);
        }
        Terms terms = (fields = r.fields()) == null ? null : fields.terms(field);
        TermsEnum termsEnum = null;
        SolrIndexSearcher.DocsEnumState deState = null;
        BytesRef term = null;
        if (terms != null) {
            termsEnum = terms.iterator();
            if (prefixTermBytes != null) {
                if (termsEnum.seekCeil(prefixTermBytes) == TermsEnum.SeekStatus.END) {
                    termsEnum = null;
                } else {
                    term = termsEnum.term();
                }
            } else {
                term = termsEnum.next();
            }
        }
        PostingsEnum postingsEnum = null;
        CharsRefBuilder charsRef = new CharsRefBuilder();
        if (docs.size() >= mincount) {
            while (term != null && (prefixTermBytes == null || StringHelper.startsWith((BytesRef)term, (BytesRef)prefixTermBytes))) {
                int df;
                if ((termFilter == null || termFilter.test(term)) && (df = termsEnum.docFreq()) > 0 && df > min) {
                    int n;
                    block29: {
                        if (df >= minDfFilterCache) {
                            if (deState == null) {
                                deState = new SolrIndexSearcher.DocsEnumState();
                                deState.fieldName = field;
                                deState.liveDocs = r.getLiveDocs();
                                deState.termsEnum = termsEnum;
                                deState.postingsEnum = postingsEnum;
                            }
                            n = intersectsCheck ? (searcher.intersects(docs, deState) ? 1 : 0) : searcher.numDocs(docs, deState);
                            postingsEnum = deState.postingsEnum;
                        } else {
                            postingsEnum = termsEnum.postings(postingsEnum, 0);
                            n = 0;
                            if (postingsEnum instanceof MultiPostingsEnum) {
                                MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)postingsEnum).getSubs();
                                int numSubs = ((MultiPostingsEnum)postingsEnum).getNumSubs();
                                for (int subindex = 0; subindex < numSubs; ++subindex) {
                                    int docid;
                                    MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                                    if (sub.postingsEnum == null) continue;
                                    int base = sub.slice.start;
                                    while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                        if (!fastForRandomSet.exists(docid + base)) continue;
                                        ++n;
                                        if (!intersectsCheck) continue;
                                        assert (n == 1);
                                        break block29;
                                    }
                                }
                            } else {
                                int docid;
                                while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    if (!fastForRandomSet.exists(docid)) continue;
                                    ++n;
                                    if (!intersectsCheck) continue;
                                    assert (n == 1);
                                    break;
                                }
                            }
                        }
                    }
                    if (sortByCount) {
                        if (n > min) {
                            BytesRef termCopy = BytesRef.deepCopyOf((BytesRef)term);
                            queue.add(new CountPair<BytesRef, Integer>(termCopy, n));
                            if (queue.size() >= maxsize) {
                                min = (Integer)((CountPair)queue.last()).val;
                            }
                        }
                    } else if (n >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        ft.indexedToReadable(term, charsRef);
                        res.add(charsRef.toString(), (Object)n);
                    }
                }
                term = termsEnum.next();
            }
        }
        if (sortByCount) {
            for (CountPair countPair : queue) {
                if (--off >= 0) continue;
                if (--lim < 0) break;
                ft.indexedToReadable((BytesRef)countPair.key, charsRef);
                res.add(charsRef.toString(), countPair.val);
            }
        }
        if (missing) {
            res.add(null, (Object)SimpleFacets.getFieldMissingCount(searcher, docs, field));
        }
        return res;
    }

    public static void checkMincountOnExists(String fieldName, int mincount) {
        if (mincount > 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.mincount=" + mincount + " exceed 1 that's not supported with " + "facet.exists" + "=true for " + fieldName);
        }
    }

    public NamedList<Object> getFacetIntervalCounts() throws IOException, SyntaxError {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] fields = this.global.getParams("facet.interval");
        if (fields == null || fields.length == 0) {
            return res;
        }
        for (String field : fields) {
            ParsedParams parsed = this.parseParams("facet.interval", field);
            String[] intervalStrs = parsed.required.getFieldParams(parsed.facetValue, "facet.interval.set");
            SchemaField schemaField = this.searcher.getCore().getLatestSchema().getField(parsed.facetValue);
            if (parsed.params.getBool("group.facet", false)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Interval Faceting can't be used with group.facet");
            }
            if (schemaField.getType().isPointField() && !schemaField.hasDocValues()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't use interval faceting on a PointField without docValues");
            }
            SimpleOrderedMap fieldResults = new SimpleOrderedMap();
            res.add(parsed.key, (Object)fieldResults);
            IntervalFacets intervalFacets = new IntervalFacets(schemaField, this.searcher, parsed.docs, intervalStrs, parsed.params);
            for (IntervalFacets.FacetInterval interval : intervalFacets) {
                fieldResults.add(interval.getKey(), (Object)interval.getCount());
            }
        }
        return res;
    }

    public NamedList getHeatmapCounts() throws IOException, SyntaxError {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] unparsedFields = this.rb.req.getParams().getParams("facet.heatmap");
        if (unparsedFields == null || unparsedFields.length == 0) {
            return resOuter;
        }
        if (this.global.getBool("group.facet", false)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Heatmaps can't be used with group.facet");
        }
        for (String unparsedField : unparsedFields) {
            ParsedParams parsed = this.parseParams("facet.heatmap", unparsedField);
            resOuter.add(parsed.key, SpatialHeatmapFacets.getHeatmapForField(parsed.key, parsed.facetValue, this.rb, parsed.params, parsed.docs));
        }
        return resOuter;
    }

    public SolrParams getGlobalParams() {
        return this.global;
    }

    public DocSet getDocsOrig() {
        return this.docsOrig;
    }

    public SolrQueryRequest getRequest() {
        return this.req;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.rb;
    }

    public static class CountPair<K extends Comparable<? super K>, V extends Comparable<? super V>>
    implements Comparable<CountPair<K, V>> {
        public K key;
        public V val;

        public CountPair(K k, V v) {
            this.key = k;
            this.val = v;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CountPair)) {
                return false;
            }
            CountPair that = (CountPair)o;
            return this.key.equals(that.key) && this.val.equals(that.val);
        }

        @Override
        public int compareTo(CountPair<K, V> o) {
            int vc = o.val.compareTo(this.val);
            return 0 != vc ? vc : this.key.compareTo(o.key);
        }
    }

    static enum FacetMethod {
        ENUM,
        FC,
        FCS,
        UIF;

    }

    protected static final class ParsedParams {
        public final SolrParams localParams;
        public final SolrParams params;
        public final SolrParams required;
        public final String facetValue;
        public final DocSet docs;
        public final String key;
        public final List<String> tags;
        public final int threads;

        public ParsedParams(SolrParams localParams, SolrParams params, SolrParams required, String facetValue, DocSet docs, String key, List<String> tags, int threads) {
            this.localParams = localParams;
            this.params = params;
            this.required = required;
            this.facetValue = facetValue;
            this.docs = docs;
            this.key = key;
            this.tags = tags;
            this.threads = threads;
        }

        public ParsedParams withDocs(DocSet docs) {
            return new ParsedParams(this.localParams, this.params, this.required, this.facetValue, docs, this.key, this.tags, this.threads);
        }
    }
}

