/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.PHPSerializedWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class PHPSerializedResponseWriter
implements QueryResponseWriter {
    static String CONTENT_TYPE_PHP_UTF8 = "text/x-php-serialized;charset=UTF-8";
    private String contentType = CONTENT_TYPE_PHP_UTF8;

    @Override
    public void init(NamedList namedList) {
        String contentType = (String)namedList.get("content-type");
        if (contentType != null) {
            this.contentType = contentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        try (PHPSerializedWriter w = new PHPSerializedWriter(writer, req, rsp);){
            w.writeResponse();
        }
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return this.contentType;
    }
}

