/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.search.spell.StringDistance;

public class StringDistanceFunction
extends ValueSource {
    protected ValueSource str1;
    protected ValueSource str2;
    protected StringDistance dist;

    public StringDistanceFunction(ValueSource str1, ValueSource str2, StringDistance measure) {
        this.str1 = str1;
        this.str2 = str2;
        this.dist = measure;
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues str1DV = this.str1.getValues(context, readerContext);
        final FunctionValues str2DV = this.str2.getValues(context, readerContext);
        return new FloatDocValues(this){

            public float floatVal(int doc) {
                String s1 = str1DV.strVal(doc);
                String s2 = str2DV.strVal(doc);
                if (null == s1 || null == s2) {
                    return s1 == s2 ? 1.0f : 0.0f;
                }
                return StringDistanceFunction.this.dist.getDistance(s1, s2);
            }

            public boolean exists(int doc) {
                return str1DV.exists(doc) && str2DV.exists(doc);
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append("strdist").append('(');
                sb.append(str1DV.toString(doc)).append(',').append(str2DV.toString(doc)).append(", dist=").append(StringDistanceFunction.this.dist.getClass().getName());
                sb.append(')');
                return sb.toString();
            }
        };
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("strdist").append('(');
        sb.append(this.str1).append(',').append(this.str2).append(", dist=").append(this.dist.getClass().getName());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringDistanceFunction)) {
            return false;
        }
        StringDistanceFunction that = (StringDistanceFunction)((Object)o);
        if (!this.dist.equals(that.dist)) {
            return false;
        }
        if (!this.str1.equals((Object)that.str1)) {
            return false;
        }
        return this.str2.equals((Object)that.str2);
    }

    public int hashCode() {
        int result = this.str1.hashCode();
        result = 31 * result + this.str2.hashCode();
        result = 31 * result + this.dist.hashCode();
        return result;
    }
}

