static char rcsid[] = "$Id: 4bd99054d3295ac2a5d388d66e1c7b6bf57fafa9 $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "concordance.h"

#include <stdlib.h>		/* For qsort */
#include <stdio.h>
#include <string.h>
#include <strings.h>

#include "assert.h"
#include "mem.h"
#include "univdiag.h"
#include "univdiagdef.h"
#include "transcript.h"

#include "trpath.h"
#include "trpath-convert.h"

#include "path.h"
#include "pathpair.h"
#include "path-solve.h"
#include "path-eval.h"		/* For Path_consolidate */

#ifdef LARGE_GENOMES
#include "intersect-concordance-uint8.h"
#else
#include "intersect-concordance-uint4.h"
#endif


static int subopt_levels;

static Chrpos_T pairmax_transcriptome;
static Chrpos_T pairmax_linear;	/* For two ends that both lack a splice */
static Chrpos_T pairmax_circular;

static bool two_pass_p;
static Chrpos_T adjacent_pairlength;  /* For two ends, one of which has a splice */

static bool *circularp;
static bool merge_samechr_p;


/* #define MAX_HITS 10000 */


#define T Path_T

/* Concordant paths */
#ifdef DEBUG0
#define debug0(x) x
#else
#define debug0(x)
#endif

#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif

/* Exhaustive listing of jj loop */
#ifdef DEBUG9
#define debug9(x) x
#else
#define debug9(x)
#endif

/* binary search */
#ifdef DEBUG10
#define debug10(x) x
#else
#define debug10(x)
#endif




#ifdef DEBUG
static char *
print_sense (int sense) {
  if (sense == SENSE_NULL) {
    return "sense:null";
  } else if (sense == SENSE_ANTI) {
    return "sense:anti";
  } else if (sense == SENSE_FORWARD) {
    return "sense:fwd";
  } else {
    abort();
  }
}
#endif



static List_T
do_transcriptome (int *found_score_paired, int *found_score_5, int *found_score_3, List_T pathpairs,
		  Trpath_T *trpaths5, int ntrpaths5, Trpath_T *trpaths3, int ntrpaths3,
		  Stage1_T stage1_5, Stage1_T stage1_3, Shortread_T queryseq5, Shortread_T queryseq3,
		  Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		  Compress_T query3_compress_fwd, Compress_T query3_compress_rev,
		  int querylength5, int querylength3, 

		  Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		  Listpool_T listpool,  Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		  Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, 
		  int sensedir) {
  
  List_T concordant_trpaths5 = NULL, concordant_trpaths3 = NULL;

  List_T paths5_gplus, paths5_gminus, paths3_gplus, paths3_gminus;
  int npaths5, npaths3;
  Trpath_T trpath5, trpath3;
  unsigned int trnum_low_5, trnum_high_5;

  bool solvedp = false;
  T *allpaths5, *allpaths3;

  int i, j;
  T path5, path3;
  Pathpair_T pathpair;


  debug(printf("Entered do_transcriptome with %d trpaths5 and %d trpaths3\n",ntrpaths5,ntrpaths3));

  i = j = 0;
  while (i < ntrpaths5 && j < ntrpaths3) {
    trpath5 = trpaths5[i];
    trpath3 = trpaths3[j];
    if (trpath5->trnum < trpath3->trnum) {
      i++;
    } else if (trpath3->trnum < trpath5->trnum) {
      j++;
    } else {
      concordant_trpaths5 = Listpool_push(concordant_trpaths5,listpool,(void *) trpath5
					  listpool_trace(__FILE__,__LINE__));
      concordant_trpaths3 = Listpool_push(concordant_trpaths3,listpool,(void *) trpath3
					  listpool_trace(__FILE__,__LINE__));
      i++;
      j++;
    }
  }

  if (sensedir == SENSE_FORWARD) {
    Trpath_convert_sense(&solvedp,&(*found_score_5),
			 &stage1_5->unsolved_sense_paths_gplus,&stage1_5->unsolved_sense_paths_gminus,
			 &paths5_gplus,&paths5_gminus,
			 concordant_trpaths5,query5_compress_fwd,query5_compress_rev,querylength5,
			 intlistpool,univcoordlistpool,listpool,pathpool,
			 transcriptpool,hitlistpool);
    Trpath_convert_sense(&solvedp,&(*found_score_3),
			 &stage1_3->unsolved_sense_paths_gplus,&stage1_3->unsolved_sense_paths_gminus,
			 &paths3_gplus,&paths3_gminus,
			 concordant_trpaths3,query3_compress_fwd,query3_compress_rev,querylength3,
			 intlistpool,univcoordlistpool,listpool,pathpool,
			 transcriptpool,hitlistpool);
  } else {
    Trpath_convert_antisense(&solvedp,&(*found_score_5),
			     &stage1_5->unsolved_antisense_paths_gplus,&stage1_5->unsolved_antisense_paths_gminus,
			     &paths5_gplus,&paths5_gminus,
			     concordant_trpaths5,query5_compress_fwd,query5_compress_rev,querylength5,
			     intlistpool,univcoordlistpool,listpool,pathpool,
			     transcriptpool,hitlistpool);
    Trpath_convert_antisense(&solvedp,&(*found_score_3),
			     &stage1_3->unsolved_antisense_paths_gplus,&stage1_3->unsolved_antisense_paths_gminus,
			     &paths3_gplus,&paths3_gminus,
			     concordant_trpaths3,query3_compress_fwd,query3_compress_rev,querylength3,
			     intlistpool,univcoordlistpool,listpool,pathpool,
			     transcriptpool,hitlistpool);
  }


  /* Analogous to do_genome, for gplus */
  paths5_gplus = Path_consolidate(paths5_gplus,queryseq5,
				  query5_compress_fwd,query5_compress_rev,
				  uintlistpool,intlistpool,univcoordlistpool,
				  listpool,pathpool,transcriptpool,hitlistpool);
  paths3_gplus = Path_consolidate(paths3_gplus,queryseq3,
				  query3_compress_fwd,query3_compress_rev,
				  uintlistpool,intlistpool,univcoordlistpool,
				  listpool,pathpool,transcriptpool,hitlistpool);

  if ((npaths5 = List_length(paths5_gplus)) > 0 &&
      (npaths3 = List_length(paths3_gplus)) > 0) {
    debug(printf("gplus: %d consolidated paths5 and %d consolidated paths3\n",
		 npaths5,npaths3));

    allpaths5 = (T *) List_to_array(paths5_gplus,NULL);
    allpaths3 = (T *) List_to_array(paths3_gplus,NULL);
    qsort(allpaths5,npaths5,sizeof(T),Path_trnum_high_cmp);
    qsort(allpaths3,npaths3,sizeof(T),Path_trnum_low_cmp);

    i = j = 0;
    while (i < npaths5) {
      path5 = allpaths5[i];
#ifdef DEBUG
      printf("i=%d/%d ",i,npaths5);
      Path_print(path5);
#endif
      trnum_low_5 = Path_trnum_low(path5);
      trnum_high_5 = Path_trnum_high(path5);

      while (j >= 0 && Path_trnum_high(allpaths3[j]) >= trnum_low_5) {
#ifdef DEBUG
	printf("  backup: j=%d/%d ",j,npaths3);
	Path_print(allpaths3[j]);
#endif
	j--;
      }
      j++;		/* Finish backup */

      while (j < npaths3 && Path_trnum_low(allpaths3[j]) <= trnum_high_5) {
	path3 = allpaths3[j];
#ifdef DEBUG
	printf("  forward: j=%d/%d ",j,npaths3);
	Path_print(path3);
#endif
	if (Pathpair_transcript_intersectp(path5,path3) == true &&
	    (pathpair =
	     Pathpair_new_concordant(path5,path3,queryseq5,queryseq3,/*plusp*/true,
				     intlistpool,univcoordlistpool,listpool,
				     pathpool,vectorpool,transcriptpool,hitlistpool,
				     /*copyLp*/true,/*copyHp*/true)) != NULL) {
	  debug(printf("Pathpair found\n"));
	  if (Pathpair_found_score(pathpair) < *found_score_paired) {
	    *found_score_paired = Pathpair_found_score(pathpair);
	  }
	  pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				   hitlistpool_trace(__FILE__,__LINE__));
	}

	j++;
      }
      
      j--;		/* Finish advance */
      
      i++;
    }

    FREE(allpaths3);
    FREE(allpaths5);
  }

  Path_gc(&paths3_gplus,intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
  Path_gc(&paths5_gplus,intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);


  /* Analogous to do_genome, for gminus */
  paths5_gminus = Path_consolidate(paths5_gminus,queryseq5,
				   query5_compress_fwd,query5_compress_rev,
				   uintlistpool,intlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,hitlistpool);
  paths3_gminus = Path_consolidate(paths3_gminus,queryseq3,
				   query3_compress_fwd,query3_compress_rev,
				   uintlistpool,intlistpool,univcoordlistpool,
				   listpool,pathpool,transcriptpool,hitlistpool);

  if ((npaths5 = List_length(paths5_gminus)) > 0 &&
      (npaths3 = List_length(paths3_gminus)) > 0) {
    debug(printf("gminus: %d consolidated paths5 and %d consolidated paths3\n",
		 npaths5,npaths3));

    allpaths5 = (T *) List_to_array(paths5_gminus,NULL);
    allpaths3 = (T *) List_to_array(paths3_gminus,NULL);
    qsort(allpaths5,npaths5,sizeof(T),Path_trnum_high_cmp);
    qsort(allpaths3,npaths3,sizeof(T),Path_trnum_low_cmp);

    i = j = 0;
    while (i < npaths5) {
      path5 = allpaths5[i];
#ifdef DEBUG
      printf("i=%d/%d ",i,npaths5);
      Path_print(path5);
#endif
      trnum_low_5 = Path_trnum_low(path5);
      trnum_high_5 = Path_trnum_high(path5);

      while (j >= 0 && Path_trnum_high(allpaths3[j]) >= trnum_low_5) {
#ifdef DEBUG
	printf("  backup: j=%d/%d ",j,npaths3);
	Path_print(allpaths3[j]);
#endif
	j--;
      }
      j++;		/* Finish backup */

      while (j < npaths3 && Path_trnum_low(allpaths3[j]) <= trnum_high_5) {
	path3 = allpaths3[j];
#ifdef DEBUG
	printf("  forward: j=%d/%d ",j,npaths3);
	Path_print(path3);
#endif
	if (Pathpair_transcript_intersectp(path5,path3) == true &&
	    (pathpair =
	     Pathpair_new_concordant(path3,path5,queryseq3,queryseq5,/*plusp*/false,
				     intlistpool,univcoordlistpool,listpool,
				     pathpool,vectorpool,transcriptpool,hitlistpool,
				     /*copyLp*/true,/*copyHp*/true)) != NULL) {
	  debug(printf("Pathpair found\n"));
	  if (Pathpair_found_score(pathpair) < *found_score_paired) {
	    *found_score_paired = Pathpair_found_score(pathpair);
	  }
	  pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				   hitlistpool_trace(__FILE__,__LINE__));
	}

	j++;
      }
      
      j--;		/* Finish advance */
      
      i++;
    }

    FREE(allpaths3);
    FREE(allpaths5);
  }


  Path_gc(&paths3_gminus,intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
  Path_gc(&paths5_gminus,intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);

  return pathpairs;
}


List_T
Concordance_tr (int *found_score_paired, int *found_score_5, int *found_score_3, List_T pathpairs,

		List_T newtrpaths5, List_T newtrpaths3,
		List_T trpaths5, List_T trpaths3,
		    
		Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		Compress_T query3_compress_fwd, Compress_T query3_compress_rev,

		Shortread_T queryseq5, Shortread_T queryseq3,
		int querylength5, int querylength3, Stage1_T stage1_5, Stage1_T stage1_3, 

		Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, int sensedir) {

  Trpath_T *alltrpaths5, *alltrpaths3;
  int nnewtrpaths5, nnewtrpaths3, ntrpaths5, ntrpaths3;

#ifdef DEBUG
  List_T p;
  printf("Entered Concordance_tr with %d pathpairs, newtrpaths5 %d, newtrpaths3 %d, trpaths5 %d, trpaths3 %d\n",
	 List_length(pathpairs),List_length(newtrpaths5),List_length(newtrpaths3),
	 List_length(trpaths5),List_length(trpaths3));
  printf("newtrpaths5:");
  for (p = newtrpaths5; p != NULL; p = List_next(p)) {
    printf(" %p",List_head(p));
  }
  printf("\n");

  printf("trpaths5:");
  for (p = trpaths5; p != NULL; p = List_next(p)) {
    printf(" %p",List_head(p));
  }
  printf("\n");

  printf("newtrpaths3:");
  for (p = newtrpaths3; p != NULL; p = List_next(p)) {
    printf(" %p",List_head(p));
  }
  printf("\n");

  printf("trpaths3:");
  for (p = trpaths3; p != NULL; p = List_next(p)) {
    printf(" %p",List_head(p));
  }
  printf("\n");
#endif

  nnewtrpaths5 = List_length(newtrpaths5);
  nnewtrpaths3 = List_length(newtrpaths3);
  ntrpaths5 = List_length(trpaths5);
  ntrpaths3 = List_length(trpaths3);

  debug(printf("%d new + %d old paths5 and %d new + %d old paths3\n",
	       nnewtrpaths5,ntrpaths5,nnewtrpaths3,ntrpaths3));

  if (nnewtrpaths5 + ntrpaths5 > 0 && nnewtrpaths3 + ntrpaths3 > 0) {
    debug(printf("Allocating %d+%d paths for allpaths5 and %d+%d paths for allpaths3\n",
		 nnewtrpaths5,ntrpaths5,nnewtrpaths3,ntrpaths3));
    alltrpaths5 = (Trpath_T *) MALLOC((nnewtrpaths5 + ntrpaths5)*sizeof(Path_T));
    alltrpaths3 = (Trpath_T *) MALLOC((nnewtrpaths3 + ntrpaths3)*sizeof(Path_T));

    /* (1) New trpaths 5 vs New trpaths 3 */
    List_fill_array((void **) alltrpaths5,newtrpaths5);
    List_fill_array((void **) alltrpaths3,newtrpaths3);

    qsort(alltrpaths5,nnewtrpaths5,sizeof(Trpath_T),Trpath_trnum_cmp);
    qsort(alltrpaths3,nnewtrpaths3,sizeof(Trpath_T),Trpath_trnum_cmp);

    pathpairs = do_transcriptome(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 alltrpaths5,nnewtrpaths5,
				 alltrpaths3,nnewtrpaths3,
				 stage1_5,stage1_3,/*queryseqL*/queryseq5,/*queryseqH*/queryseq3,
				 query5_compress_fwd,query5_compress_rev,
				 query3_compress_fwd,query3_compress_rev,
				 querylength5,querylength3,
				 intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				 vectorpool,hitlistpool,sensedir);

    /* (2) New trpaths 5 vs Old trpaths 3 */
    List_fill_array((void **) &(alltrpaths3[nnewtrpaths3]),trpaths3);
    qsort(&(alltrpaths3[nnewtrpaths3]),ntrpaths3,sizeof(Trpath_T),Trpath_trnum_cmp);
    
    pathpairs = do_transcriptome(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 alltrpaths5,nnewtrpaths5,
				 &(alltrpaths3[nnewtrpaths3]),ntrpaths3,
				 stage1_5,stage1_3,/*queryseqL*/queryseq5,/*queryseqH*/queryseq3,
				 query5_compress_fwd,query5_compress_rev,
				 query3_compress_fwd,query3_compress_rev,
				 querylength5,querylength3,
				 intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				 vectorpool,hitlistpool,sensedir);

    /* (3) Old trpaths 5 vs New trpaths 3 */
    List_fill_array((void **) &(alltrpaths5[nnewtrpaths5]),trpaths5);
    qsort(&(alltrpaths5[nnewtrpaths5]),ntrpaths5,sizeof(T),Trpath_trnum_cmp);

    pathpairs = do_transcriptome(&(*found_score_paired),&(*found_score_5),&(*found_score_3),pathpairs,
				 &(alltrpaths5[nnewtrpaths5]),ntrpaths5,
				 alltrpaths3,nnewtrpaths3,
				 stage1_5,stage1_3,/*queryseqL*/queryseq5,/*queryseqH*/queryseq3,
				 query5_compress_fwd,query5_compress_rev,
				 query3_compress_fwd,query3_compress_rev,
				 querylength5,querylength3,
				 intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				 vectorpool,hitlistpool,sensedir);

    FREE(alltrpaths3);
    FREE(alltrpaths5);
  }

  return pathpairs;
}


static List_T
make_pairs (int *nfound, int *found_score_paired, int *found_score_L, int *found_score_H,
	    List_T pathpairs, Path_T pathL, Path_T pathH, Shortread_T queryseqL, Shortread_T queryseqH,
	    Compress_T query_compress_L, Compress_T queryL_compress_fwd, Compress_T queryL_compress_rev,
	    Compress_T query_compress_H, Compress_T queryH_compress_fwd, Compress_T queryH_compress_rev,
	    char *queryptrL, char *queryptrH, int genestrand, int querylengthL, int querylengthH, 
	    int *mismatch_positions_alloc_L, int *mismatch_positions_alloc_H,
	    Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc, Stage1_T stage1L, Stage1_T stage1H,
	    Knownsplicing_T knownsplicing, Knownindels_T knownindels,
	    Spliceendsgen_T spliceendsgenL, Spliceendsgen_T spliceendsgenH,
	    int nmismatches_allowed_L, int nmismatches_allowed_H,
	    int max_insertionlen_L, int max_insertionlen_H, int max_deletionlen_L, int max_deletionlen_H,
	    Chrpos_T overall_end_distance_L, Chrpos_T overall_end_distance_H,
	    Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
	    Listpool_T listpool,  Pathpool_T pathpool, Transcriptpool_T transcriptpool,
	    Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, bool plusp) {

  Pathpair_T pathpair;
  List_T newpathsL, newpathsH, p, q;
  Path_T newpathL, newpathH;
  bool completeLp = false, completeHp = false;

  if (pathL->extendedp == true) {
    /* Already called Path_extend */
    newpathsL = pathL->extended_paths;
  } else if (Path_unextendedp(pathL,/*endtrim_allowed*/0,/*allow_ambig_p*/false) == false) {
    newpathsL = (List_T) NULL;
  } else {
    newpathsL = Path_extend(&completeLp,&(*found_score_L),
			    pathL,queryseqL,queryptrL,querylengthL,
			    mismatch_positions_alloc_L,novel_diagonals_alloc,localdb_alloc,
			    stage1L,knownsplicing,knownindels,query_compress_L,
			    queryL_compress_fwd,queryL_compress_rev,genestrand,
			    max_insertionlen_L,max_deletionlen_L,overall_end_distance_L,
			    nmismatches_allowed_L,/*paired_end_p*/true,/*lowp*/true,
			    intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			    vectorpool,hitlistpool,spliceendsgenL,
			    /*extend_qstart_p*/true,/*extend_qend_p*/true);
  }

  if (pathH->extendedp == true) {
    /* Already called Path_extend */
    newpathsH = pathH->extended_paths;
  } else if (Path_unextendedp(pathH,/*endtrim_allowed*/0,/*allow_ambig_p*/false) == false) {
    newpathsH = (List_T) NULL;
  } else {
    newpathsH = Path_extend(&completeHp,&(*found_score_H),
			    pathH,queryseqH,queryptrH,querylengthH,
			    mismatch_positions_alloc_H,novel_diagonals_alloc,localdb_alloc,
			    stage1H,knownsplicing,knownindels,query_compress_H,
			    queryH_compress_fwd,queryH_compress_rev,genestrand,
			    max_insertionlen_H,max_deletionlen_H,overall_end_distance_H,
			    nmismatches_allowed_H,/*paired_end_p*/true,/*lowp*/false,
			    intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
			    vectorpool,hitlistpool,spliceendsgenH,
			    /*extend_qstart_p*/true,/*extend_qend_p*/true);
  }
  
  /* Always copying path5 and path3 allows us to call Stage1hr_free with free_paths_p being true */
  if (newpathsL != NULL && newpathsH != NULL) {
    for (p = newpathsL; p != NULL; p = List_next(p)) {
      newpathL = (Path_T) List_head(p);
      for (q = newpathsH; q != NULL; q = List_next(q)) {
	newpathH = (Path_T) List_head(q);
	if ((pathpair =
	     Pathpair_new_concordant(newpathL,newpathH,queryseqL,queryseqH,plusp,
				     intlistpool,univcoordlistpool,listpool,
				     pathpool,vectorpool,transcriptpool,hitlistpool,
				     /*copyLp (was false)*/true,/*copyHp (was false)*/true)) != NULL) {
	  debug0(printf("Pathpair found\n"));
	  if (Pathpair_found_score(pathpair) < *found_score_paired) {
	    *found_score_paired = Pathpair_found_score(pathpair);
	  }
	  pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				   hitlistpool_trace(__FILE__,__LINE__));
	  (*nfound)++;
	}
      }
    }
    
  } else if (newpathsL != NULL) {
    for (p = newpathsL; p != NULL; p = List_next(p)) {
      newpathL = (Path_T) List_head(p);
      if ((pathpair =
	   Pathpair_new_concordant(newpathL,pathH,queryseqL,queryseqH,plusp,
				   intlistpool,univcoordlistpool,listpool,
				   pathpool,vectorpool,transcriptpool,hitlistpool,
				   /*copyLp (was false)*/true,/*copyHp*/true)) != NULL) {
	debug0(printf("Pathpair found\n"));
	if (Pathpair_found_score(pathpair) < *found_score_paired) {
	  *found_score_paired = Pathpair_found_score(pathpair);
	}
	pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				 hitlistpool_trace(__FILE__,__LINE__));
	(*nfound)++;
      }
    }
    
  } else if (newpathsH != NULL) {
    for (q = newpathsH; q != NULL; q = List_next(q)) {
      newpathH = (Path_T) List_head(q);
      if ((pathpair =
	   Pathpair_new_concordant(pathL,newpathH,queryseqL,queryseqH,plusp,
				   intlistpool,univcoordlistpool,listpool,
				   pathpool,vectorpool,transcriptpool,hitlistpool,
				   /*copyLp*/true,/*copyHp (was false)*/true)) != NULL) {
	debug0(printf("Pathpair found\n"));
	if (Pathpair_found_score(pathpair) < *found_score_paired) {
	  *found_score_paired = Pathpair_found_score(pathpair);
	}
	pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
				 hitlistpool_trace(__FILE__,__LINE__));
	(*nfound)++;
      }
    }
    
  } else {
    if ((pathpair =
	 Pathpair_new_concordant(pathL,pathH,queryseqL,queryseqH,plusp,
				 intlistpool,univcoordlistpool,listpool,
				 pathpool,vectorpool,transcriptpool,hitlistpool,
				 /*copyLp*/true,/*copyHp*/true)) != NULL) {
      debug0(printf("Pathpair found\n"));
      if (Pathpair_found_score(pathpair) < *found_score_paired) {
	*found_score_paired = Pathpair_found_score(pathpair);
      }
      pathpairs = Hitlist_push(pathpairs,hitlistpool,(void *) pathpair
			       hitlistpool_trace(__FILE__,__LINE__));
      (*nfound)++;
    }
  }
  
  if (newpathsL == NULL) {
    /* Skip */
  } else if (pathL->extended_paths != NULL) {
    /* newpathsL came from extended_paths */
  } else {
    pathL->extended_paths = newpathsL;
  }

  if (newpathsH == NULL) {
    /* Skip */
  } else if (pathH->extended_paths != NULL) {
    /* newpathsH came from extended_paths */
  } else {
    pathH->extended_paths = newpathsH;
  }


  /* Previously added extended paths to Stage1_T lists, but now adding them to extended_paths in Path_T object */

#if 0
  /* newpaths now saved as extended_paths in Path_T object */
  Hitlistpool_free_list(&newpathsL,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));
  Hitlistpool_free_list(&newpathsH,hitlistpool
			hitlistpool_trace(__FILE__,__LINE__));
#endif

  return pathpairs;
}



/* pathsL are the lower paths, and pathsH are the higher ones in the genome */
/* All paths are pointing toward higher coordinates, on the plus genome */
/* For alignment to the plus genome strand, pathsL is paths5 and pathsH is paths3 */
/* For alignment to the minus genome strand, pathsL is paths3 and pathsH is paths5 */
static List_T
do_genome (int *found_score_paired, int *found_score_L, int *found_score_H,
	   T *pathsL, Univcoord_T *coordsL, int *indicesL, int nuniqueL,
	   T *pathsH, Univcoord_T *coordsH, int *indicesH, int nuniqueH,
	   Shortread_T queryseqL, Shortread_T queryseqH,
	   Compress_T query_compress_L, Compress_T queryL_compress_fwd, Compress_T queryL_compress_rev,
	   Compress_T query_compress_H, Compress_T queryH_compress_fwd, Compress_T queryH_compress_rev,
	   char *queryptrL, char *queryptrH, int genestrand, int querylengthL, int querylengthH, 
	   int *mismatch_positions_alloc_L, int *mismatch_positions_alloc_H,
	   Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc, Stage1_T stage1L, Stage1_T stage1H,
	   Knownsplicing_T knownsplicing, Knownindels_T knownindels,
	   Spliceendsgen_T spliceendsgenL, Spliceendsgen_T spliceendsgenH,
	   int nmismatches_allowed_L, int nmismatches_allowed_H,
	   int max_insertionlen_L, int max_insertionlen_H, int max_deletionlen_L, int max_deletionlen_H,
	   Chrpos_T overall_end_distance_L, Chrpos_T overall_end_distance_H,
	   Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
	   Listpool_T listpool,  Pathpool_T pathpool, Transcriptpool_T transcriptpool,
	   Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, bool plusp) {

  List_T pathpairs = NULL;
  int *matches, *matchesL, *matchesH, m;
  int lowL, highL, indexL, lowH, highH, indexH;
  int ncoordpairs, nfound = 0, i, k;
  T pathL, pathH;
  /* Chrpos_T insert_length_max = pairmax_linear + querylengthL + querylengthH; */
  /* slopL_pos: insert_length_max - querylengthH = pairmax_linear + querylengthL */
  /* slopH_neg: insert_length_max - querylengthL = pairmax_linear + querylengthH */

  debug(printf("Entered do_genome with %d unique coordsL and %d unique coordsH\n",nuniqueL,nuniqueH));
  if (nuniqueL > 0 && nuniqueH > 0) {
    if ((ncoordpairs = Intersect_concordance(&matches,coordsL,nuniqueL,coordsH,nuniqueH,
					     /*slopL_neg*/querylengthL,
					     /*slopL_pos*/pairmax_linear + querylengthL,
					     /*slopH_neg*/pairmax_linear + querylengthH,
					     /*slopH_pos*/querylengthH)) > 0) {
      matchesL = &(matches[0]);
      matchesH = &(matches[1]);

      for (i = 0, k = 0; i < ncoordpairs; i++, k += 2) {
	m = matchesL[k];
	lowL = (m == 0) ? 0 : indicesL[m - 1];
	highL = indicesL[m];
	/* printf("L m %d => %d..%d\n",m,lowL,highL); */

	m = matchesH[k];
	lowH = (m == 0) ? 0 : indicesH[m - 1];
	highH = indicesH[m];
	/* printf("H m %d => %d..%d\n",m,lowH,highH); */

	for (indexL = lowL; indexL < highL; indexL++) {
	  pathL = pathsL[indexL];
	  for (indexH = lowH; indexH < highH; indexH++) {
	    pathH = pathsH[indexH];
	    pathpairs = make_pairs(&nfound,&(*found_score_paired),&(*found_score_L),&(*found_score_H),
				   pathpairs,pathL,pathH,queryseqL,queryseqH,
				   query_compress_L,queryL_compress_fwd,queryL_compress_rev,
				   query_compress_H,queryH_compress_fwd,queryH_compress_rev,
				   queryptrL,queryptrH,genestrand,querylengthL,querylengthH,
				   mismatch_positions_alloc_L,mismatch_positions_alloc_H,
				   novel_diagonals_alloc,localdb_alloc,stage1L,stage1H,
				   knownsplicing,knownindels,spliceendsgenL,spliceendsgenH,
				   nmismatches_allowed_L,nmismatches_allowed_H,
				   max_insertionlen_L,max_insertionlen_H,max_deletionlen_L,max_deletionlen_H,
				   overall_end_distance_L,overall_end_distance_H,
				   intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				   vectorpool,hitlistpool,plusp);
	  }
	}
      }
    }
    FREE(matches);
  }

  debug(printf("Returning %d concordant pathpairs, accumulated\n",List_length(pathpairs)));
  return pathpairs;
}


/* This procedure tries to find the best concordance, based on score.  But with paths, we want concordance before we have scored them */
/* Performs Path_filter on newpaths to reduce computational complexity */
/* Removes complete paths (either parent or child) from newpaths and merges them into Stage1_T arrays */
List_T
Concordance_gen (int *found_score_paired, int *found_score_5, int *found_score_3, List_T pathpairs,

		 List_T *newpaths5_gplus, List_T *newpaths5_gminus,
		 List_T *newpaths3_gplus, List_T *newpaths3_gminus,

		 Path_T **paths5_gplus, Path_T **paths5_gminus, Path_T **paths3_gplus, Path_T **paths3_gminus,
		 Univcoord_T **coords5_gplus, Univcoord_T **coords5_gminus, Univcoord_T **coords3_gplus, Univcoord_T **coords3_gminus,
		 int **indices5_gplus, int **indices5_gminus, int **indices3_gplus, int **indices3_gminus,
		 int *npaths5_gplus, int *npaths5_gminus, int *npaths3_gplus, int *npaths3_gminus,
		 int *nunique5_gplus, int *nunique5_gminus, int *nunique3_gplus, int *nunique3_gminus,
		    
		 Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		 Compress_T query3_compress_fwd, Compress_T query3_compress_rev,

		 Shortread_T queryseq5, Shortread_T queryseq3,
		 char *queryuc_ptr_5, char *queryrc5, char *queryuc_ptr_3, char *queryrc3,
		 int querylength5, int querylength3, Stage1_T stage1_5, Stage1_T stage1_3, 

		 int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
		 Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		 Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		 Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3,

		 int nmismatches_allowed_5, int nmismatches_allowed_3,
		 int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
		 Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,

		 Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		 Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		 Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, int genestrand,
		 bool mergep) {

  List_T incomplete5, incomplete3;
  Path_T *alloc5, *alloc3, *newpaths5, *newpaths3;
  Univcoord_T *coords5, *coords3, *newcoords5, *newcoords3;
  int *indices5, *indices3, *newindices5, *newindices3;
  int ncomplete5, ncomplete3, nnewpaths5, nnewpaths3;
  int nnewunique5, nnewunique3;

  debug(printf("Entered Concordance_gen with %d pathpairs, newpaths5 %d+%d, newpaths3 %d+%d, paths5 %d+%d, paths3 %d+%d\n",
	       List_length(pathpairs),List_length(*newpaths5_gplus),List_length(*newpaths5_gminus),
	       List_length(*newpaths3_gplus),List_length(*newpaths3_gminus),
	       *npaths5_gplus,*npaths5_gminus,*npaths3_gplus,*npaths3_gminus));


  CHECK_ALIGN(*coords5_gplus);
  CHECK_ALIGN(*coords5_gminus);
  CHECK_ALIGN(*coords3_gplus);
  CHECK_ALIGN(*coords3_gminus);

#if 0
  for (List_T p = *newpaths5_gplus; p != NULL; p = List_next(p)) {
    Path_print((Path_T) List_head(p));
  }
  for (List_T p = *newpaths5_gminus; p != NULL; p = List_next(p)) {
    Path_print((Path_T) List_head(p));
  }
  for (List_T p = *newpaths3_gplus; p != NULL; p = List_next(p)) {
    Path_print((Path_T) List_head(p));
  }
  for (List_T p = *newpaths3_gminus; p != NULL; p = List_next(p)) {
    Path_print((Path_T) List_head(p));
  }

  Stage1_list_paths(stage1_5);
  Stage1_list_paths(stage1_3);
#endif


#if 0
  newpaths5_gplus_orig = *newpaths5_gplus =
    Path_filter(*newpaths5_gplus,
		intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
  newpaths5_gminus_orig = *newpaths5_gminus =
    Path_filter(*newpaths5_gminus,
		intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
  newpaths3_gplus_orig = *newpaths3_gplus =
    Path_filter(*newpaths3_gplus,
		intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
  newpaths3_gminus_orig = *newpaths3_gminus =
    Path_filter(*newpaths3_gminus,
		intlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,hitlistpool);
#endif
  

  /* Plus */
  nnewpaths5 = List_length(*newpaths5_gplus);
  nnewpaths3 = List_length(*newpaths3_gplus);

  if (nnewpaths5 > 0 || nnewpaths3 > 0) {
    debug(printf("plus: %d new + %d old paths5 (pathsL) and %d new + %d old paths3 (pathsH)\n",
		 nnewpaths5,*npaths5_gplus,nnewpaths3,*npaths3_gplus));

    if (nnewpaths5 == 0) {
      newpaths5 = (Path_T *) NULL;
      newcoords5 = (Univcoord_T *) NULL;
      newindices5 = (int *) NULL;
      nnewunique5 = 0;
    } else {
      if (mergep == false) {
	newpaths5 = (Path_T *) List_to_array(*newpaths5_gplus,NULL);
	newcoords5 = (Univcoord_T *) MALLOC(nnewpaths5*sizeof(Univcoord_T));
	newindices5 = (int *) MALLOC(nnewpaths5*sizeof(int));
      } else {
	/* For paths in alloc, make a single call to MALLOC, rather than two.  First two parts are for the merged array, and the last part is temp */
	alloc5 = (Path_T *) MALLOC(((*npaths5_gplus) + nnewpaths5 + nnewpaths5)*sizeof(Path_T));
	MALLOC_ALIGN(coords5,((*npaths5_gplus) + nnewpaths5 + nnewpaths5)*sizeof(Univcoord_T));
	indices5 = (int *) MALLOC(((*npaths5_gplus) + nnewpaths5 + nnewpaths5)*sizeof(int));
	newpaths5 = &(alloc5[(*npaths5_gplus) + nnewpaths5]);
	newcoords5 = &(coords5[(*npaths5_gplus) + nnewpaths5]);
	newindices5 = &(indices5[(*npaths5_gplus) + nnewpaths5]);
	List_fill_array((void **) newpaths5,*newpaths5_gplus);
	Hitlistpool_free_list(&(*newpaths5_gplus),hitlistpool
			      hitlistpool_trace(__FILE__,__LINE__));
      }
      qsort(newpaths5,nnewpaths5,sizeof(T),Path_high_univdiagonal_cmp);
      nnewunique5 = Path_fill_high_univdiagonal(newcoords5,newindices5,newpaths5,nnewpaths5);
    }
      
    if (nnewpaths3 == 0) {
      newpaths3 = (Path_T *) NULL;
      newcoords3 = (Univcoord_T *) NULL;
      newindices3 = (int *) NULL;
      nnewunique3 = 0;
    } else {
      if (mergep == false) {
	newpaths3 = (Path_T *) List_to_array(*newpaths3_gplus,NULL);
	newcoords3 = (Univcoord_T *) MALLOC(nnewpaths3*sizeof(Univcoord_T));
	newindices3 = (int *) MALLOC(nnewpaths3*sizeof(int));
      } else {
	/* For paths in alloc, make a single call to MALLOC, rather than two.  First two parts are for the merged array, and the last part is temp */
	alloc3 = (Path_T *) MALLOC(((*npaths3_gplus) + nnewpaths3 + nnewpaths3)*sizeof(Path_T));
	MALLOC_ALIGN(coords3, ((*npaths3_gplus) + nnewpaths3 + nnewpaths3)*sizeof(Univcoord_T));
	indices3 = (int *) MALLOC(((*npaths3_gplus) + nnewpaths3 + nnewpaths3)*sizeof(int));
	newpaths3 = &(alloc3[(*npaths3_gplus) + nnewpaths3]);
	newcoords3 = &(coords3[(*npaths3_gplus) + nnewpaths3]);
	newindices3 = &(indices3[(*npaths3_gplus) + nnewpaths3]);
	List_fill_array((void **) newpaths3,*newpaths3_gplus);
	Hitlistpool_free_list(&(*newpaths3_gplus),hitlistpool
			      hitlistpool_trace(__FILE__,__LINE__));
      }
      qsort(newpaths3,nnewpaths3,sizeof(T),Path_low_univdiagonal_cmp);
      nnewunique3 = Path_fill_low_univdiagonal(newcoords3,newindices3,newpaths3,nnewpaths3);
    }

    /* (1, plus) New paths 5 vs New paths 3 */
    pathpairs = List_append(pathpairs,
			    do_genome(&(*found_score_paired),
				      /*found_score_L*/&(*found_score_5),/*found_score_H*/&(*found_score_3),
				      /*pathsL*/newpaths5,newcoords5,newindices5,/*nuniqueL*/nnewunique5,
				      /*pathsH*/newpaths3,newcoords3,newindices3,/*nuniqueH*/nnewunique3,
				      /*queryseqL*/queryseq5,/*queryseqH*/queryseq3,
				      /*query_compress_L*/query5_compress_fwd,query5_compress_fwd,query5_compress_rev,
				      /*query_compress_H*/query3_compress_fwd,query3_compress_fwd,query3_compress_rev,
				      queryuc_ptr_5,queryuc_ptr_3,genestrand,querylength5,querylength3,
				      mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				      novel_diagonals_alloc,localdb_alloc,/*stage1L*/stage1_5,/*stage1H*/stage1_3,
				      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				      nmismatches_allowed_5,nmismatches_allowed_3,
				      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				      overall_end_distance_5,overall_end_distance_3,
				      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				      vectorpool,hitlistpool,/*plusp*/true));

    /* (2, plus): New paths 5 vs Old paths 3 (already sorted) */
    pathpairs = List_append(pathpairs,
			    do_genome(&(*found_score_paired),
				      /*found_score_L*/&(*found_score_5),/*found_score_H*/&(*found_score_3),
				      /*pathsL*/newpaths5,newcoords5,newindices5,/*nuniqueL*/nnewunique5,
				      /*pathsH*/*paths3_gplus,*coords3_gplus,*indices3_gplus,/*nuniqueH*/*nunique3_gplus,
				      /*queryseqL*/queryseq5,/*queryseqH*/queryseq3,
				      /*query_compress_L*/query5_compress_fwd,query5_compress_fwd,query5_compress_rev,
				      /*query_compress_H*/query3_compress_fwd,query3_compress_fwd,query3_compress_rev,
				      queryuc_ptr_5,queryuc_ptr_3,genestrand,querylength5,querylength3,
				      mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				      novel_diagonals_alloc,localdb_alloc,/*stage1L*/stage1_5,/*stage1H*/stage1_3,
				      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				      nmismatches_allowed_5,nmismatches_allowed_3,
				      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				      overall_end_distance_5,overall_end_distance_3,
				      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				      vectorpool,hitlistpool,/*plusp*/true));

    /* (3, plus): Old paths 5 (already sorted) vs New paths 3 */
    pathpairs = List_append(pathpairs,
			    do_genome(&(*found_score_paired),
				      /*found_score_L*/&(*found_score_5),/*found_score_H*/&(*found_score_3),
				      /*pathsL*/*paths5_gplus,*coords5_gplus,*indices5_gplus,/*nuniqueL*/*nunique5_gplus,
				      /*pathsH*/newpaths3,newcoords3,newindices3,/*nuniqueH*/nnewunique3,
				      /*queryseqL*/queryseq5,/*queryseqH*/queryseq3,
				      /*query_compress_L*/query5_compress_fwd,query5_compress_fwd,query5_compress_rev,
				      /*query_compress_H*/query3_compress_fwd,query3_compress_fwd,query3_compress_rev,
				      queryuc_ptr_5,queryuc_ptr_3,genestrand,querylength5,querylength3,
				      mismatch_positions_alloc_5,mismatch_positions_alloc_3,
				      novel_diagonals_alloc,localdb_alloc,/*stage1L*/stage1_5,/*stage1H*/stage1_3,
				      knownsplicing,knownindels,spliceendsgen5,spliceendsgen3,
				      nmismatches_allowed_5,nmismatches_allowed_3,
				      max_insertionlen_5,max_insertionlen_3,max_deletionlen_5,max_deletionlen_3,
				      overall_end_distance_5,overall_end_distance_3,
				      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				      vectorpool,hitlistpool,/*plusp*/true));

    /* TODO: Merge paths if they are complete or have a complete child */

    if (nnewpaths5 == 0) {
      /* Keep old paths the same */
    } else if (mergep == false) {
      FREE(newpaths5);
      FREE(newcoords5);
      FREE(newindices5);
    } else {
      /* Third part of alloc5 is wasted */
      *nunique5_gplus = Path_merge_high_univdiagonal(&incomplete5,&ncomplete5,alloc5,coords5,indices5,
						     newpaths5,nnewpaths5,*paths5_gplus,*npaths5_gplus,
						     hitlistpool);
      *newpaths5_gplus = incomplete5;
      FREE(*paths5_gplus);
      FREE_ALIGN(*coords5_gplus);
      FREE(*indices5_gplus);
      *paths5_gplus = alloc5;
      *coords5_gplus = coords5;
      *indices5_gplus = indices5;
      *npaths5_gplus += ncomplete5;
    }

    if (nnewpaths3 == 0) {
      /* Keep old paths the same */
    } else if (mergep == false) {
      FREE(newpaths3);
      FREE(newcoords3);
      FREE(newindices3);
    } else {
      /* Third part of alloc5 is wasted */
      *nunique3_gplus = Path_merge_low_univdiagonal(&incomplete3,&ncomplete3,alloc3,coords3,indices3,
						    newpaths3,nnewpaths3,*paths3_gplus,*npaths3_gplus,
						    hitlistpool);
      *newpaths3_gplus = incomplete3;
      FREE(*paths3_gplus);
      FREE_ALIGN(*coords3_gplus);
      FREE(*indices3_gplus);
      *paths3_gplus = alloc3;
      *coords3_gplus = coords3;
      *indices3_gplus = indices3;
      *npaths3_gplus += ncomplete3;
    }
  }


  /* Minus */
  nnewpaths5 = List_length(*newpaths5_gminus);
  nnewpaths3 = List_length(*newpaths3_gminus);

  if (nnewpaths5 > 0 || nnewpaths3 > 0) {
    debug(printf("minus: %d new + %d old paths3 (pathsL) and %d new + %d old paths5 (pathsH)\n",
		 nnewpaths3,*npaths3_gminus,nnewpaths5,*npaths5_gminus));

    if (nnewpaths5 == 0) {
      newpaths5 = (Path_T *) NULL;
      newcoords5 = (Univcoord_T *) NULL;
      newindices5 = (int *) NULL;
      nnewunique5 = 0;
    } else {
      if (mergep == false) {
	newpaths5 = (Path_T *) List_to_array(*newpaths5_gminus,NULL);
	newcoords5 = (Univcoord_T *) MALLOC(nnewpaths5*sizeof(Univcoord_T));
	newindices5 = (int *) MALLOC(nnewpaths5*sizeof(int));
      } else {
	/* For paths in alloc, ake a single call to MALLOC, rather than two.  First two parts are for the merged array, and the last part is temp */
	alloc5 = (Path_T *) MALLOC(((*npaths5_gminus) + nnewpaths5 + nnewpaths5)*sizeof(Path_T));
	MALLOC_ALIGN(coords5, ((*npaths5_gminus) + nnewpaths5 + nnewpaths5)*sizeof(Univcoord_T));
	indices5 = (int *) MALLOC(((*npaths5_gminus) + nnewpaths5 + nnewpaths5)*sizeof(int));
	newpaths5 = &(alloc5[(*npaths5_gminus) + nnewpaths5]);
	newcoords5 = &(coords5[(*npaths5_gminus) + nnewpaths5]);
	newindices5 = &(indices5[(*npaths5_gminus) + nnewpaths5]);
	List_fill_array((void **) newpaths5,*newpaths5_gminus);
	Hitlistpool_free_list(&(*newpaths5_gminus),hitlistpool
			      hitlistpool_trace(__FILE__,__LINE__));
      }
      qsort(newpaths5,nnewpaths5,sizeof(T),Path_low_univdiagonal_cmp);
      nnewunique5 = Path_fill_low_univdiagonal(newcoords5,newindices5,newpaths5,nnewpaths5);
    }

    if (nnewpaths3 == 0) {
      newpaths3 = (Path_T *) NULL;
      newcoords3 = (Univcoord_T *) NULL;
      newindices3 = (int *) NULL;
      nnewunique3 = 0;
    } else {
      if (mergep == false) {
	newpaths3 = (Path_T *) List_to_array(*newpaths3_gminus,NULL);
	newcoords3 = (Univcoord_T *) MALLOC(nnewpaths3*sizeof(Univcoord_T));
	newindices3 = (int *) MALLOC(nnewpaths3*sizeof(int));
      } else {
	/* For paths in alloc, make a single call to MALLOC, rather than two.  First two parts are for the merged array, and the last part is temp */
	alloc3 = (Path_T *) MALLOC(((*npaths3_gminus) + nnewpaths3 + nnewpaths3)*sizeof(Path_T));
	MALLOC_ALIGN(coords3, ((*npaths3_gminus) + nnewpaths3 + nnewpaths3)*sizeof(Univcoord_T));
	indices3 = (int *) MALLOC(((*npaths3_gminus) + nnewpaths3 + nnewpaths3)*sizeof(int));
	newpaths3 = &(alloc3[(*npaths3_gminus) + nnewpaths3]);
	newcoords3 = &(coords3[(*npaths3_gminus) + nnewpaths3]);
	newindices3 = &(indices3[(*npaths3_gminus) + nnewpaths3]);
	List_fill_array((void **) newpaths3,*newpaths3_gminus);
	Hitlistpool_free_list(&(*newpaths3_gminus),hitlistpool
			      hitlistpool_trace(__FILE__,__LINE__));
      }
      qsort(newpaths3,nnewpaths3,sizeof(T),Path_high_univdiagonal_cmp);
      nnewunique3 = Path_fill_high_univdiagonal(newcoords3,newindices3,newpaths3,nnewpaths3);
    }

    /* (1, minus) New paths 3 vs New paths 5 */
    pathpairs = List_append(pathpairs,
			    do_genome(&(*found_score_paired),
				      /*found_score_L*/&(*found_score_3),/*found_score_H*/&(*found_score_5),
				      /*pathsL*/newpaths3,newcoords3,newindices3,/*nuniqueL*/nnewunique3,
				      /*pathsH*/newpaths5,newcoords5,newindices5,/*nuniqueH*/nnewunique5,
				      /*queryseqL*/queryseq3,/*queryseqH*/queryseq5,
				      /*query_compress_L*/query3_compress_rev,query3_compress_fwd,query3_compress_rev,
				      /*query_compress_H*/query5_compress_rev,query5_compress_fwd,query5_compress_rev,
				      queryrc3,queryrc5,genestrand,querylength3,querylength5,
				      mismatch_positions_alloc_3,mismatch_positions_alloc_5,
				      novel_diagonals_alloc,localdb_alloc,/*stage1L*/stage1_3,/*stage1H*/stage1_5,
				      knownsplicing,knownindels,spliceendsgen3,spliceendsgen5,
				      nmismatches_allowed_3,nmismatches_allowed_5,
				      max_insertionlen_3,max_insertionlen_5,max_deletionlen_3,max_deletionlen_5,
				      overall_end_distance_3,overall_end_distance_5,
				      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				      vectorpool,hitlistpool,/*plusp*/false));
  
    /* (2, minus) Old paths 3 (already sorted) vs New paths 5 */
    pathpairs = List_append(pathpairs,
			    do_genome(&(*found_score_paired),
				      /*found_score_L*/&(*found_score_3),/*found_score_H*/&(*found_score_5),
				      /*pathsL*/*paths3_gminus,*coords3_gminus,*indices3_gminus,/*nuniqueL*/*nunique3_gminus,
				      /*pathsH*/newpaths5,newcoords5,newindices5,/*nuniqueH*/nnewunique5,
				      /*queryseqL*/queryseq3,/*queryseqH*/queryseq5,
				      /*query_compress_L*/query3_compress_rev,query3_compress_fwd,query3_compress_rev,
				      /*query_compress_H*/query5_compress_rev,query5_compress_fwd,query5_compress_rev,
				      queryrc3,queryrc5,genestrand,querylength3,querylength5,
				      mismatch_positions_alloc_3,mismatch_positions_alloc_5,
				      novel_diagonals_alloc,localdb_alloc,/*stage1L*/stage1_3,/*stage1H*/stage1_5,
				      knownsplicing,knownindels,spliceendsgen3,spliceendsgen5,
				      nmismatches_allowed_3,nmismatches_allowed_5,
				      max_insertionlen_3,max_insertionlen_5,max_deletionlen_3,max_deletionlen_5,
				      overall_end_distance_3,overall_end_distance_5,
				      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				      vectorpool,hitlistpool,/*plusp*/false));

    /* (3, minus) New paths 3 vs Old paths 5 (already sorted) */
    pathpairs = List_append(pathpairs,
			    do_genome(&(*found_score_paired),
				      /*found_score_L*/&(*found_score_3),/*found_score_H*/&(*found_score_5),
				      /*pathsL*/newpaths3,newcoords3,newindices3,/*nuniqueL*/nnewunique3,
				      /*pathsH*/*paths5_gminus,*coords5_gminus,*indices5_gminus,/*nuniqueH*/*nunique5_gminus,
				      /*queryseqL*/queryseq3,/*queryseqH*/queryseq5,
				      /*query_compress_L*/query3_compress_rev,query3_compress_fwd,query3_compress_rev,
				      /*query_compress_H*/query5_compress_rev,query5_compress_fwd,query5_compress_rev,
				      queryrc3,queryrc5,genestrand,querylength3,querylength5,
				      mismatch_positions_alloc_3,mismatch_positions_alloc_5,
				      novel_diagonals_alloc,localdb_alloc,/*stage1L*/stage1_3,/*stage1H*/stage1_5,
				      knownsplicing,knownindels,spliceendsgen3,spliceendsgen5,
				      nmismatches_allowed_3,nmismatches_allowed_5,
				      max_insertionlen_3,max_insertionlen_5,max_deletionlen_3,max_deletionlen_5,
				      overall_end_distance_3,overall_end_distance_5,
				      intlistpool,uintlistpool,univcoordlistpool,listpool,pathpool,transcriptpool,
				      vectorpool,hitlistpool,/*plusp*/false));

    if (nnewpaths5 == 0) {
      /* Keep old paths the same */
    } else if (mergep == false) {
      FREE(newpaths5);
      FREE(newcoords5);
      FREE(newindices5);
    } else {
      /* Third part of alloc5 is wasted */
      *nunique5_gminus = Path_merge_low_univdiagonal(&incomplete5,&ncomplete5,alloc5,coords5,indices5,
						     newpaths5,nnewpaths5,*paths5_gminus,*npaths5_gminus,
						     hitlistpool);
      *newpaths5_gminus = incomplete5;
      FREE(*paths5_gminus);
      FREE_ALIGN(*coords5_gminus);
      FREE(*indices5_gminus);
      *paths5_gminus = alloc5;
      *coords5_gminus = coords5;
      *indices5_gminus = indices5;
      *npaths5_gminus += ncomplete5;
    }

    if (nnewpaths3 == 0) {
      /* Keep old paths the same */
    } else if (mergep == false) {
      FREE(newpaths3);
      FREE(newcoords3);
      FREE(newindices3);
    } else {
      /* Third part of alloc5 is wasted */
      *nunique3_gminus = Path_merge_high_univdiagonal(&incomplete3,&ncomplete3,alloc3,coords3,indices3,
						      newpaths3,nnewpaths3,*paths3_gminus,*npaths3_gminus,
						      hitlistpool);
      *newpaths3_gminus = incomplete3;
      FREE(*paths3_gminus);
      FREE_ALIGN(*coords3_gminus);
      FREE(*indices3_gminus);
      *paths3_gminus = alloc3;
      *coords3_gminus = coords3;
      *indices3_gminus = indices3;
      *npaths3_gminus += ncomplete3;
    }
  }

  return pathpairs;
}


void
Concordance_setup (int subopt_levels_in, Chrpos_T pairmax_transcriptome_in,
		   Chrpos_T pairmax_linear_in, Chrpos_T pairmax_circular_in,
		   bool *circularp_in, bool merge_samechr_p_in, bool two_pass_p_in) {
  subopt_levels = subopt_levels_in;

  pairmax_transcriptome = pairmax_transcriptome_in;
  pairmax_linear = pairmax_linear_in;
  pairmax_circular = pairmax_circular_in;

  adjacent_pairlength = 0;

  circularp = circularp_in;
  merge_samechr_p = merge_samechr_p_in;
  two_pass_p = two_pass_p_in;

  return;
}


void
Concordance_pass2_setup (double expected_pairlength_in, double pairlength_deviation_in) {
  adjacent_pairlength = (Chrpos_T) (expected_pairlength_in + pairlength_deviation_in);
  return;
}

