/* $Id: c2d8248301f76c304e492b8326a95cece3910ac2 $ */
#ifndef CONCORDANCE_INCLUDED
#define CONCORDANCE_INCLUDED
#ifdef HAVE_CONFIG_H
#include "config.h"		/* For HAVE_64_BIT */
#endif

#include "bool.h"
#include "list.h"
#include "types.h"
#include "genomicpos.h"
#include "pass.h"

#include "shortread.h"
#include "compress.h"
#include "knownsplicing.h"
#include "knownindels.h"
#include "spliceendsgen.h"
#include "stage1hr.h"

#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "listpool.h"
#include "hitlistpool.h"
#include "pathpool.h"
#include "transcriptpool.h"
#include "vectorpool.h"


extern List_T
Concordance_tr (int *found_score_paired, int *found_score_5, int *found_score_3, List_T pathpairs,

		List_T newtrpaths5, List_T newtrpaths3,
		List_T trpaths5, List_T trpaths3,
		    
		Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		Compress_T query3_compress_fwd, Compress_T query3_compress_rev,

		Shortread_T queryseq5, Shortread_T queryseq3,
		int querylength5, int querylength3, Stage1_T stage1_5, Stage1_T stage1_3, 

		Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, int sensedir);

extern List_T
Concordance_gen (int *found_score_paired, int *found_score_5, int *found_score_3,
		 List_T pathpairs,

		 List_T *newpaths5_gplus, List_T *newpaths5_gminus,
		 List_T *newpaths3_gplus, List_T *newpaths3_gminus,

		 Path_T **paths5_gplus, Path_T **paths5_gminus, Path_T **paths3_gplus, Path_T **paths3_gminus,
		 Univcoord_T **coords5_gplus, Univcoord_T **coords5_gminus, Univcoord_T **coords3_gplus, Univcoord_T **coords3_gminus,
		 int **indices5_gplus, int **indices5_gminus, int **indices3_gplus, int **indices3_gminus,
		 int *npaths5_gplus, int *npaths5_gminus, int *npaths3_gplus, int *npaths3_gminus,
		 int *nunique5_gplus, int *nunique5_gminus, int *nunique3_gplus, int *nunique3_gminus,

		 Compress_T query5_compress_fwd, Compress_T query5_compress_rev,
		 Compress_T query3_compress_fwd, Compress_T query3_compress_rev,

		 Shortread_T queryseq5, Shortread_T queryseq3,
		 char *queryuc_ptr_5, char *queryrc5, char *queryuc_ptr_3, char *queryrc3,
		 int querylength5, int querylength3, Stage1_T stage1_5, Stage1_T stage1_3, 

		 int *mismatch_positions_alloc_5, int *mismatch_positions_alloc_3,
		 Univcoord_T *novel_diagonals_alloc, unsigned short *localdb_alloc,
		 Knownsplicing_T knownsplicing, Knownindels_T knownindels,
		 Spliceendsgen_T spliceendsgen5, Spliceendsgen_T spliceendsgen3,

		 int nmismatches_allowed_5, int nmismatches_allowed_3,
		 int max_insertionlen_5, int max_insertionlen_3, int max_deletionlen_5, int max_deletionlen_3,
		 Chrpos_T overall_end_distance_5, Chrpos_T overall_end_distance_3,

		 Intlistpool_T intlistpool, Uintlistpool_T uintlistpool, Univcoordlistpool_T univcoordlistpool,
		 Listpool_T listpool, Pathpool_T pathpool, Transcriptpool_T transcriptpool,
		 Vectorpool_T vectorpool, Hitlistpool_T hitlistpool, int genestrand, bool mergep);

extern void
Concordance_setup (int subopt_levels_in, Chrpos_T pairmax_transcriptome_in,
		   Chrpos_T pairmax_linear_in, Chrpos_T pairmax_circular_in,
		   bool *circularp_in, bool merge_samechr_p_in, bool two_pass_p);

extern void
Concordance_pass2_setup (double expected_pairlength_in, double pairlength_deviation_in);

#undef T
#endif

