/* $Id: 05abbb551944d5adaf8b0bcf5f6f6071bcbd06c8 $ */
#ifndef KMER_SEARCH_INCLUDED
#define KMER_SEARCH_INCLUDED

#include "method.h"
#include "list.h"
#include "indexdb.h"
#include "iit-read-univ.h"
#include "ef64.h"
#include "transcriptome.h"
#include "compress.h"
#include "shortread.h"
#include "genomebits.h"
#include "indel.h"

#include "bool.h"
#include "pass.h"
#include "univdiag.h"
#include "stage1hr.h"
#include "mergeinfo.h"
#include "knownsplicing.h"
#include "knownindels.h"

#include "intlistpool.h"
#include "uintlistpool.h"
#include "univcoord.h"
#include "pathpool.h"
#include "transcriptpool.h"
#include "vectorpool.h"
#include "listpool.h"
#include "hitlistpool.h"
#include "spliceendsgen.h"


/* Does not take paired_end_p as a parameter.  ? Generates both sense and antisense */
extern int
Kmer_exact1 (Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
	     Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,
	     Stage1_T stage1, int querylength);

extern int
Kmer_exact2 (Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
	     Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,
	     Stage1_T stage1, int querylength);

extern int
Kmer_anypair (Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
	      Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,
	      Stage1_T stage1, int querylength);

extern int
Kmer_prevalent (Univcoord_T **all_univdiagonals_gplus, int *all_nunivdiagonals_gplus,
		int *max_npositions_gplus,
		Univcoord_T **all_univdiagonals_gminus, int *all_nunivdiagonals_gminus,
		int *max_npositions_gminus,

		Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
		Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,

		Stage1_T stage1, int querylength);

extern int
Kmer_widest (Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
	     Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,

	     Univcoord_T *all_univdiagonals_gplus, int all_nunivdiagonals_gplus,
	     int max_npositions_gplus,
	     Univcoord_T *all_univdiagonals_gminus, int all_nunivdiagonals_gminus,
	     int max_npositions_gminus,

	     Stage1_T stage1, int querylength);

extern int
Kmer_anchored_5 (Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
		 Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,

		 Univcoord_T *all_univdiagonals5_gplus, int all_nunivdiagonals5_gplus,
		 Univcoord_T *all_univdiagonals5_gminus, int all_nunivdiagonals5_gminus,

		 Univcoord_T *univdiagonals3_gplus, int nunivdiagonals3_gplus,
		 Univcoord_T *univdiagonals3_gminus, int nunivdiagonals3_gminus,

		 Univcoord_T slop);

extern int
Kmer_anchored_3 (Univcoord_T **univdiagonals_gplus, int *nunivdiagonals_gplus,
		 Univcoord_T **univdiagonals_gminus, int *nunivdiagonals_gminus,

		 Univcoord_T *univdiagonals5_gplus, int nunivdiagonals5_gplus,
		 Univcoord_T *univdiagonals5_gminus, int nunivdiagonals5_gminus,

		 Univcoord_T *all_univdiagonals3_gplus, int all_nunivdiagonals3_gplus,
		 Univcoord_T *all_univdiagonals3_gminus, int all_nunivdiagonals3_gminus,

		 Univcoord_T slop);

extern void
Kmer_exact_paths (bool *any_imperfect_ends_p, int *found_score,
		  List_T *sense_paths_gplus, List_T *sense_paths_gminus,
		  List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,

		  List_T exact_univdiagonals_gplus, Intlist_T exact_nunivdiagonals_gplus,
		  List_T exact_univdiagonals_gminus, Intlist_T exact_nunivdiagonals_gminus,

		  Compress_T query_compress_fwd, Compress_T query_compress_rev,
		  Shortread_T queryseq, char *queryuc_ptr, char *queryrc, int querylength,
		  int genestrand, Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		  Univcoordlistpool_T univcoordlistpool,
		  Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
		  Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool, Method_T method);

extern void
Kmer_search_end (int *found_score,

		 List_T *sense_paths_gplus, List_T *sense_paths_gminus,
		 List_T *antisense_paths_gplus, List_T *antisense_paths_gminus,

		 Stage1_T stage1, Shortread_T queryseq,
		 char *queryuc_ptr, char *queryrc, int querylength,
		 Compress_T query_compress_fwd, Compress_T query_compress_rev,
		 Intlistpool_T intlistpool, Uintlistpool_T uintlistpool,
		 Univcoordlistpool_T univcoordlistpool,
		 Listpool_T listpool, Pathpool_T pathpool, Vectorpool_T vectorpool,
		 Hitlistpool_T hitlistpool, Transcriptpool_T transcriptpool,
		 Method_T method);

extern void
Kmer_search_setup (int index1part_in, int index1interval_in,
		   Indexdb_T indexdb_in, EF64_T chromosome_ef64_in,
		   Genomebits_T genomebits_in, Genomebits_T genomebits_alt_in,
		   Univcoord_T genomelength_in, bool splicingp_in);
#endif
