/* $Id: 16fa7de374866862d560d01996466711aa0a9919 $ */
#ifndef SPLICE_INCLUDED
#define SPLICE_INCLUDED

typedef struct Spliceinfo_T *Spliceinfo_T;

#include "bool.h"
#include "types.h"
#include "genomicpos.h"
#include "compress.h"
#include "genomebits.h"
#include "knownsplicing.h"
#include "univcoord.h"
#include "indel.h"


#define SPLICE_PROB_HIGH 0.9
#define SPLICE_PROB_LOW 0.2

#define T Spliceinfo_T
struct T {
  int *mismatch_positions_left;
  int *mismatch_positions_right;

  int *segmenti_qpos_alloc;
  int *segmentj_qpos_alloc;

  /* Needed by Spliceindel_resolve to combine known and novel splice sites */
  int *segmenti_knowni_alloc;
  int *segmentj_knowni_alloc;
  int *segmenti_knownpos;
  int *segmentj_knownpos;
  int *segmenti_knowni;
  int *segmentj_knowni;

  /* Needed by find_middle_exon */
  Univcoord_T *segmenti_partners;
  Univcoord_T *segmentj_partners;
};


extern void
Splice_setup (Genomebits_T genomebits_in, Genomebits_T genomebits_alt_in,
	      bool novelsplicingp_in, int min_shortend_in);

extern void
Spliceinfo_free (T *old);

extern T
Spliceinfo_new (int querylength);

extern int
Splice_resolve (Univcoord_T *middle_univdiagonal, int *splice_qpos_i, int *splice_qpos_j,
		int *best_nindels, int *best_indel_pos,
		int *best_nmismatches_i, int *nmismatches_middle, int *best_nmismatches_j,
		int *best_nmismatches_indel,

		int *best_ref_nmismatches_i, int *ref_nmismatches_middle, int *best_ref_nmismatches_j,
		int *best_ref_nmismatches_indel, double *best_donor_prob, double *best_acceptor_prob,

		Univcoord_T univdiagonal_i, Univcoord_T univdiagonal_j,
		Compress_T query_compress, bool plusp, Univcoord_T chroffset, Univcoord_T chrhigh,

		int pos5, int pos3, int querylength,
		Indelinfo_T indelinfo, Spliceinfo_T spliceinfo, Knownsplicing_T knownsplicing,
		bool sense_forward_p, int genestrand, int max_insertionlen, int max_deletionlen,
		bool salvagep, bool check_support_p);

int
Splice_resolve_fusion (char *donor1, char *donor2, char *acceptor1, char *acceptor2,
		       int *best_nindels, int *best_indel_pos,
		       int *best_nmismatches_5, int *best_nmismatches_3,

		       int *best_ref_nmismatches_5, int *best_ref_nmismatches_3,
		       double *best_donor_prob, double *best_acceptor_prob,
		       
		       Univcoord_T univdiagonal5, Univcoord_T univdiagonal3,
		       Compress_T query_compress_5, bool plusp_5, Univcoord_T chroffset5,
		       Compress_T query_compress_3, bool plusp_3, Univcoord_T chroffset3,
		     
		       int querypos5, int querypos3, int querylength,
		       Indelinfo_T indelinfo, Spliceinfo_T spliceinfo, Knownsplicing_T knownsplicing,
		       bool sense_forward_p, int genestrand,
		       int nmismatches_allowed, int max_insertionlen, int max_deletionlen);

#undef T
#endif

